/*
 * Decompiled with CFR 0.152.
 */
package jaybot.bots;

import java.awt.geom.Point2D;
import java.util.Map;
import jaybot.bots.BaseBot;
import jaybot.guns.TargetFocus;
import jaybot.intel.Enemy;
import jaybot.intel.EnemyIntel;
import jaybot.strategies.SplitPersonalityStrategy;
import jaybot.strategies.Strategy;
import jaybot.strategies.Tactic;
import jaybot.strategies.TacticAnalyzer;
import jaybot.strategies.TacticMultiController;
import jaybot.tactics.OddBallPersonality;
import jaybot.tactics.OutaCenterPersonality;
import jaybot.tactics.SitAndSpinPersonality;
import jaybot.tactics.UnoKillerPersonality;

public class Oddball
extends BaseBot
implements TacticAnalyzer,
TargetFocus {
    protected SitAndSpinPersonality pSpin;
    protected OddBallPersonality pOddBall;
    protected UnoKillerPersonality pMonoKiller;
    protected OutaCenterPersonality pOuta;
    protected SplitPersonalityStrategy strat;

    protected Strategy createStrategy() {
        this.strat = new SplitPersonalityStrategy();
        this.strat.setPersonalityDecider(this);
        this.pSpin = new SitAndSpinPersonality(false);
        this.strat.addPersonality(this.pSpin);
        this.pOddBall = new OddBallPersonality();
        this.strat.addPersonality(this.pOddBall);
        this.pMonoKiller = new UnoKillerPersonality();
        this.strat.addPersonality(this.pMonoKiller);
        this.pOuta = new OutaCenterPersonality();
        this.strat.addPersonality(this.pOuta);
        return this.strat;
    }

    protected void announceBot() {
        this.logImportant("Oddball 3.0 by Jayson Minard");
    }

    protected EnemyIntel createEnemyIntel() {
        return new EnemyIntel();
    }

    protected void lastMinuteAdjustments() {
    }

    public Tactic getBestTactic(Strategy strat, TacticMultiController controller, Map availablePersonalities, Tactic currentPersonality) {
        Tactic result = currentPersonality;
        EnemyIntel tracker = this.opponentTracker;
        if (this.getOthers() <= 1) {
            result = this.pMonoKiller;
            if (result != currentPersonality) {
                this.stop();
            }
        } else if (currentPersonality == null) {
            result = this.pOuta;
        } else if (currentPersonality == this.pSpin) {
            if (this.getEnergy() > 100.0) {
                tracker.resetRunningStats(true, true, false);
            }
            if (this.getEnergy() <= 95.0 || tracker.getRunningCollisionCount() > 1 || tracker.getRunningShotsHitMe() > 2 || tracker.getActualAliveCompetitorCount() < 4 || this.pSpin.isGivingUp()) {
                result = this.pOuta;
            }
            if (result != currentPersonality) {
                this.stop();
            }
        }
        if (result != currentPersonality) {
            tracker.resetRunningStats();
        }
        return result;
    }

    public Point2D getAimingPosition() {
        Tactic mode = this.strat.getCurrentPersonality();
        if (mode instanceof TargetFocus) {
            return ((TargetFocus)((Object)mode)).getAimingPosition();
        }
        return this.getTankPosition();
    }

    public Enemy getCurrentTarget() {
        Tactic mode = this.strat.getCurrentPersonality();
        if (mode instanceof TargetFocus) {
            return ((TargetFocus)((Object)mode)).getCurrentTarget();
        }
        return null;
    }

    public double getSweetSpotForDistance() {
        Tactic mode = this.strat.getCurrentPersonality();
        if (mode instanceof TargetFocus) {
            return ((TargetFocus)((Object)mode)).getSweetSpotForDistance();
        }
        return 100.0;
    }
}

