/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Random;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MChromosoom;
import metal.shared.MDna;
import metal.shared.MMath;
import metal.shared.MPoint;
import robocode.HitByBulletEvent;

public class MChassisDna2 {
    static double MIN_DIST;
    public TreeMap bullets = new TreeMap();
    static int c;
    private static MPoint centre;
    static double dir;
    static MDna[] dnas;
    private static MPoint enemyPoint;
    private static double firePower;
    private static double fireTime;
    static boolean first;
    static int i;
    private static MPoint nextPoint;
    private static Random rand;
    static int speedCounter;

    static {
        rand = new Random();
        centre = null;
        nextPoint = null;
        enemyPoint = null;
        firePower = 0.0;
        fireTime = 0.0;
        dnas = new MDna[30];
        i = 0;
        first = true;
        c = 0;
        speedCounter = 0;
        MIN_DIST = 60.0;
        dir = 1.0;
    }

    public MChassisDna2() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
        centre = new MPoint(MBotData.self.getBattleFieldWidth() / 2.0, MBotData.self.getBattleFieldHeight() / 2.0);
        if (first) {
            MChassisDna2.init();
            first = false;
        }
    }

    public static void go(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-2.0, 2.0));
        MBotData.self.setAhead(dist);
    }

    private static void init() {
        int i = 0;
        while (i < dnas.length) {
            MChassisDna2.dnas[i] = new MDna();
            ++i;
        }
    }

    private static void initDNA() {
        int i = 0;
        while (i < dnas.length) {
            dnas[i].mergeDna(dnas[i].furtilize());
            ++i;
        }
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        MChassisDna2.go(MBotData.enemy);
    }

    public static void move() {
        try {
            if (MBotData.enemy.energy < 1.5 && MBotData.self.getEnergy() > 12.0 || MBotData.enemy.energy == 0.0) {
                MChassisDna2.kiss();
            } else {
                MChassisDna2.movement();
            }
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        double L = 0.0;
        double angle = 0.0;
        double distAngle = 0.0;
        double moveAngle = 0.0;
        double distance = MBotData.enemy.distance;
        boolean isCentered = false;
        boolean isVerticle = false;
        int index = 10;
        if (MMath.abs(MBotData.enemy.energyDiff - 1.55) < 1.46) {
            firePower = MBotData.enemy.energyDiff;
            fireTime = (1.0 + firePower / 5.0) / MBotData.self.getGunCoolingRate();
            fireTime = MBotData.enemy.time + fireTime - 1.0 + MMath.randomLarge(fireTime, 10.0);
            int indexD = (int)MMath.clamp(100.0, 0.0, distance / 5.0);
            index = (int)MMath.clamp(30.0, 0.0, (double)indexD / MBullet.getSpeed(firePower));
        }
        if (fireTime > (double)MBotData.self.getTime() && MBotData.self.getRoundNum() % 2 == 0 || MMath.abs(MBotData.self.getDistanceRemaining()) < MIN_DIST && MBotData.self.getRoundNum() % 2 == 1 || MMath.abs(MBotData.self.getDistanceRemaining()) > 250.0) {
            if (MMath.abs(MBotData.enemy.energyDiff - 1.55) < 1.46 || MBotData.enemy.distance < 200.0) {
                angle = MMath.abs((MBotData.enemy.bearing + 360.0) % 90.0);
                isCentered = MBotData.getLocation().distance(centre) < centre.distance(0.0, 0.0) / 2.0;
                isVerticle = angle < 22.5 || angle > 157.5 || isCentered;
                distAngle = 2.0 * Math.toDegrees(Math.asin(4.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                if (isVerticle) {
                    distAngle = Math.toDegrees(Math.asin(8.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                }
                MChromosoom crom = dnas[index].getFittest();
                double tola = crom.value == 0.0 ? 2.0 : crom.value * crom.dir * dir;
                MIN_DIST = 60.0 + Math.abs(crom.value) / MMath.random(1.0, 5.0);
                distAngle = MMath.atan(MMath.tan(distAngle) + (MIN_DIST / 2.0 - 4.0) / distance);
                if (distance < 200.0) {
                    // empty if block
                }
                distance += 30.0;
                do {
                    moveAngle += distAngle * MMath.random(crom.min, crom.value);
                    L = distance;
                    if (isVerticle) {
                        L /= MMath.cos(moveAngle);
                    }
                    distance -= 10.0;
                    nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + moveAngle, -L);
                } while (MPoint.getWallDistance(nextPoint) < 30.0);
                ++i;
                MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)((int)crom.index)).append((String)"").toString()).fitness = crom.index == 0.0 ? (MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)((int)crom.index)).append((String)"").toString()).fitness -= 3) : (crom.index == -1.0 || crom.index == 1.0 ? (MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)((int)crom.index)).append((String)"").toString()).fitness -= 2) : (MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)((int)crom.index)).append((String)"").toString()).fitness -= 2));
                ++MChassisDna2.dnas[index].counter;
                ++c;
            } else if (MBotData.self.getDistanceRemaining() == 0.0) {
                nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + 90.0 * MMath.sign(MMath.random(-1.0, 1.0)) + Math.toDegrees(Math.random() * 0.04 - 0.02), -MBotData.enemy.distance);
                MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? 6.0 : 8.0);
                fireTime = 0.0;
                MIN_DIST = 600.0;
                ++i;
            }
            if (nextPoint != null) {
                MChassisDna2.go(nextPoint);
            }
        }
        MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? 3.0 : 6.0 + Math.random() * 2.0);
        ++speedCounter;
    }

    public void update(HitByBulletEvent e) {
        try {
            dir *= -1.0;
            MBulletEnemy b = (MBulletEnemy)MBotData.enemy.bullets.get((e.getVelocity() + "     ").substring(0, 5));
            double dist = b.getDistance();
            double bearing = -e.getBearing();
            int indexD = (int)MMath.clamp(100.0, 0.0, dist / 5.0);
            int index = (int)MMath.clamp(30.0, 0.0, (double)indexD / e.getVelocity());
            int i = (int)Math.rint(bearing / 40.0) % 4;
            double d = b.power = b.power < 1.0 ? 1.0 : b.power;
            MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = i == 0 ? (int)((double)MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 5.0 * b.power) : (i == -1 || i == 1 ? (int)((double)MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 3.0 * b.power) : (int)((double)MChassisDna2.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.0 * b.power));
            dnas[index].mutate(i + "");
            MBotData.enemy.bullets.remove(b.toString());
        }
        catch (Exception ex) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED TIME: " + MBotData.self.getTime());
            MBotData.err("SYSTEM:   Err: No bullets matched! " + ex.toString());
        }
    }
}

