/*
 * Decompiled with CFR 0.152.
 */
package florent.gun;

import florent.BattleField;
import florent.Context;
import florent.FloatingTadpole;
import florent.gun.utils.BigFrame;
import florent.gun.utils.EvaluatedAngle;
import florent.gun.utils.PotentialAngle;
import florent.jUtil;
import florent.pattern.Frame;
import florent.pattern.PatternUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class MultiChoice {
    private static final boolean DEBUG = false;
    public static final int NO_ANGLE = -100000;
    private static final int MAX_MOVIE = 400;
    private static final int MAX_ROUND_LENGTH = 1500;
    private static final int MAX_LENGTH = 300;
    private static final int MAX_ANGLES = 50;
    private static int missedScan;
    private static ArrayList movie;
    private static int movieIndex;
    private double[] cumulDistance = new double[1500];
    private int cumulIndex;
    private Context context;
    private double velocity;
    private double approachVelocity;
    private double lateralVelocity;
    private double distance;
    private double heading;
    private double time;
    private double absoluteBearing;
    private Point2D.Double enemyLocation;
    private Point2D.Double myLocation;
    private double lastHeading;
    private double lastTime;
    private BattleField BF;
    private static BigFrame lastFrame;

    static {
        movie = new ArrayList(400);
    }

    public void init(AdvancedRobot me, Context context) {
        this.context = context;
        BigFrame.init(context.getRobot());
        this.BF = new BattleField(me);
    }

    private void synch() {
        if (this.time == this.context.getTime()) {
            return;
        }
        this.lastHeading = this.heading;
        this.lastTime = this.time;
        this.velocity = this.context.getVelocity();
        this.lateralVelocity = this.context.getLateralVelocity();
        this.approachVelocity = this.context.getApproachVelocity();
        this.distance = this.context.getDistance();
        this.enemyLocation = this.context.getEnemyLocation();
        this.heading = this.context.getHeading();
        this.myLocation = this.context.getMyLocation();
        this.absoluteBearing = this.context.getAbsoluteBearing();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point2D.Double lastEnemyLocation = this.enemyLocation;
        this.synch();
        int deltaTime = (int)((double)e.getTime() - this.time);
        if (deltaTime > 1 && e.getTime() > 20L) {
            System.out.println(deltaTime);
            missedScan += deltaTime - 1;
        }
        double distance = lastEnemyLocation == null ? this.velocity : this.enemyLocation.distance(lastEnemyLocation) * (double)FloatingTadpole.sign(this.velocity) / (double)deltaTime;
        this.lastTime = this.time;
        this.time = e.getTime();
        double distance15 = this.cumulIndex < 15 ? -100000.0 : this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 15];
        double distance30 = this.cumulIndex < 30 ? -100000.0 : this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 30];
        double distance60 = this.cumulIndex < 60 ? -100000.0 : this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 60];
        double distance120 = this.cumulIndex < 120 ? -100000.0 : this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 120];
        BigFrame frame = new BigFrame(this.enemyLocation, PatternUtils.normalRelativeAngle(this.lastHeading - this.heading), this.velocity, this.approachVelocity, this.lateralVelocity, distance, distance15, distance30, distance60, distance120);
        this.record(frame, deltaTime, distance);
        lastFrame = frame;
    }

    private void record(Frame frame, int deltaTime, double distance) {
        int i = 0;
        while (i < deltaTime) {
            this.recordFrame(frame);
            this.cumulDistance[this.cumulIndex] = distance + (this.cumulIndex == 0 ? 0.0 : this.cumulDistance[this.cumulIndex - 1]);
            ++this.cumulIndex;
            ++i;
        }
    }

    private void recordFrame(Frame frame) {
        movie.add(frame);
        if (movieIndex == 400) {
            movie.remove(0);
        } else {
            ++movieIndex;
        }
    }

    public double getAngle(double power) {
        this.synch();
        double angle = 0.0;
        ArrayList goodFrames = new ArrayList();
        ArrayList<PotentialAngle> potentials = new ArrayList<PotentialAngle>();
        ArrayList<EvaluatedAngle> evaluated = new ArrayList<EvaluatedAngle>();
        Point2D.Double arrived = new Point2D.Double();
        if ((int)((double)(movieIndex - 1) - this.distance / jUtil.bulletVelocity(power)) <= 0) {
            return 0.0;
        }
        int i = (int)((double)(movieIndex - 1) - this.distance / jUtil.bulletVelocity(power));
        while (i > Math.max(0, (int)((double)(movieIndex - 1) - this.distance / jUtil.bulletVelocity(power)) - 300)) {
            goodFrames.add(movie.get(i));
            --i;
        }
        Collections.sort(goodFrames, lastFrame);
        int j = 0;
        while (j < Math.min(50, goodFrames.size())) {
            int i2 = movie.lastIndexOf(goodFrames.get(j));
            double desiredDirection = PatternUtils.projectedBearing(i2, this.enemyLocation, this.myLocation, movie, movieIndex, this.heading, jUtil.bulletVelocity(power), arrived);
            if (this.BF.contains(arrived)) {
                boolean val = false;
                potentials.add(new PotentialAngle(PatternUtils.normalRelativeAngle(desiredDirection - this.absoluteBearing), arrived.distance(this.myLocation), (double)val));
            }
            ++j;
        }
        if (!potentials.isEmpty()) {
            int angleCount = 0;
            int sameAngle = 0;
            int i3 = 0;
            while (i3 < potentials.size()) {
                PotentialAngle currentPotential = (PotentialAngle)potentials.get(i3);
                EvaluatedAngle current = new EvaluatedAngle(currentPotential);
                int idx = evaluated.indexOf(current);
                if (idx == -1) {
                    evaluated.add(current);
                    current.mark(currentPotential);
                    ++angleCount;
                } else {
                    ++sameAngle;
                    current = (EvaluatedAngle)evaluated.get(idx);
                    current.mark(currentPotential);
                }
                ++i3;
            }
            Collections.sort(evaluated);
            return ((EvaluatedAngle)evaluated.get(0)).getAngle();
        }
        return -100000.0;
    }

    public static int getMissedScan() {
        return missedScan;
    }
}

