/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.shield.iceShield;

import dsekercioglu.shield.iceShield.Bullet;
import dsekercioglu.shield.iceShield.ShieldUtils;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class IceShield {
    AdvancedRobot a;
    Point2D.Double myLocation = new Point2D.Double();
    Point2D.Double enemyLocation;
    ArrayList<Double> absBearings;
    ArrayList<Point2D.Double> enemyLocations;
    double energy;
    float[] moves = new float[]{-0.2f, -0.15f, -0.1f, -0.05f, 0.05f, 0.1f, 0.15f, 0.2f};
    FiringSolution bestFiringSolution = new FiringSolution(0.0, 0.0, 0, 0.0);
    int tick = 0;
    double bestMove;

    public IceShield(AdvancedRobot a) {
        this.a = a;
    }

    public void run() {
        this.absBearings = new ArrayList();
        this.enemyLocations = new ArrayList();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tick = (int)this.a.getTime();
        this.myLocation.setLocation(this.a.getX(), this.a.getY());
        double distance = e.getDistance();
        double absBearing = this.a.getHeadingRadians() + e.getBearingRadians();
        this.enemyLocation = ShieldUtils.project(this.myLocation, absBearing, distance);
        this.absBearings.add(absBearing);
        this.energy = e.getEnergy();
        double deltaEnergy = this.energy - this.energy;
        if (deltaEnergy > 0.099 && deltaEnergy < 3.01) {
            Bullet b = new Bullet();
            b.bulletPower = deltaEnergy;
            b.velocity = 20.0 - 3.0 * deltaEnergy;
            b.source = this.enemyLocations.get(0);
            this.bestFiringSolution = new FiringSolution(absBearing, 0.0, 0, Double.POSITIVE_INFINITY);
            this.bestMove = 0.0;
            for (int i = 0; i < this.moves.length; ++i) {
                double move = this.moves[i];
                Point2D.Double futurePos = ShieldUtils.project(this.myLocation, this.a.getHeadingRadians(), move);
                double maxPower = b.bulletPower;
                for (int j = 0; j < 100; ++j) {
                    double power = 0.1 + Math.max(maxPower - 0.1, 0.1) * (double)j * 0.01;
                    FiringSolution fs = this.getFireAngleAndPower(futurePos, this.myLocation, b, 1, power);
                    if (!(fs.DEVIATION < this.bestFiringSolution.DEVIATION)) continue;
                    try {
                        this.bestFiringSolution = (FiringSolution)fs.clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        Logger.getLogger(IceShield.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.bestMove = move;
                }
            }
            this.a.setTurnRightRadians(0.0);
            this.a.setAhead(this.bestMove);
        }
        if (this.tick == this.bestFiringSolution.FIRE_TICK) {
            this.a.setFire(this.bestFiringSolution.FIRE_POWER);
        }
        if (this.tick == this.bestFiringSolution.FIRE_TICK + 1) {
            this.a.setAhead(-this.bestMove);
        }
        if (this.tick != this.bestFiringSolution.FIRE_TICK && this.a.getDistanceRemaining() == 0.0) {
            this.bestFiringSolution = new FiringSolution(absBearing, 0.0, 0, Double.POSITIVE_INFINITY);
            this.a.setTurnRightRadians(Utils.normalRelativeAngle((double)(absBearing + 1.5707963267948966 - this.a.getHeadingRadians())));
        }
        this.a.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.bestFiringSolution.AIM_ANGLE - this.a.getGunHeadingRadians())));
        this.enemyLocations.add(0, (Point2D.Double)this.enemyLocation.clone());
        if (this.enemyLocations.size() > 2) {
            this.enemyLocations.remove(2);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.energy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.energy += Rules.getBulletHitBonus((double)e.getPower());
    }

    public FiringSolution getFireAngleAndPower(Point2D.Double fireLocation, Point2D.Double shieldLocation, Bullet eb, int timeElapsed, double power) {
        double enemyBulletAngle = ShieldUtils.absoluteBearing(this.enemyLocations.get(1), shieldLocation);
        double bulletSpeed = 20.0 - 3.0 * power;
        Point2D.Double enemyBulletFireLocation = ShieldUtils.project(eb.source, enemyBulletAngle, eb.velocity);
        Point2D.Double aimPos = IceShield.intercept(fireLocation, bulletSpeed, ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, eb.velocity * (double)timeElapsed), enemyBulletAngle, eb.velocity);
        int enemyTime = (int)Math.ceil(enemyBulletFireLocation.distance(aimPos) / eb.velocity);
        aimPos = ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, ((double)enemyTime - 0.5) * eb.velocity);
        double aimAngle = ShieldUtils.absoluteBearing(fireLocation, aimPos);
        int realTime = (int)Math.ceil(fireLocation.distance(aimPos) / bulletSpeed);
        Line2D.Double eLine = new Line2D.Double(ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, eb.velocity * (double)(enemyTime - 1)), ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, eb.velocity * (double)enemyTime));
        Line2D.Double line = new Line2D.Double(ShieldUtils.project(fireLocation, aimAngle, bulletSpeed * (double)(realTime - 1)), ShieldUtils.project(fireLocation, aimAngle, bulletSpeed * (double)realTime));
        Point2D.Double enemyCenter = ShieldUtils.project(enemyBulletFireLocation, enemyBulletAngle, eb.velocity * ((double)enemyTime - 0.5));
        Point2D.Double myCenter = ShieldUtils.project(fireLocation, aimAngle, bulletSpeed * ((double)realTime - 0.5));
        return new FiringSolution(aimAngle, power, this.tick + timeElapsed, eLine.intersectsLine(line) ? enemyCenter.distanceSq(myCenter) : Double.POSITIVE_INFINITY);
    }

    public static Point2D.Double intercept(Point2D.Double pos, double vel, Point2D.Double tPos, double tHeading, double tVel) {
        double tVelX = Math.sin(tHeading) * tVel;
        double tVelY = Math.cos(tHeading) * tVel;
        double relX = tPos.getX() - pos.getX();
        double relY = tPos.getY() - pos.getY();
        double b = relX * tVelX + relY * tVelY;
        double a = vel * vel - tVel * tVel;
        b = (b + Math.sqrt(b * b + a * (relX * relX + relY * relY))) / a;
        return new Point2D.Double(tVelX * b + tPos.getX(), tVelY * b + tPos.getY());
    }

    public class FiringSolution
    implements Cloneable {
        final double AIM_ANGLE;
        final double FIRE_POWER;
        final int FIRE_TICK;
        final double DEVIATION;

        public FiringSolution(double aimAngle, double firePower, int fireTick, double deviation) {
            this.AIM_ANGLE = aimAngle;
            this.FIRE_POWER = firePower;
            this.FIRE_TICK = fireTick;
            this.DEVIATION = deviation;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

