/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.shield;

import xander.core.Resources;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;

public class BulletShieldingDrive
implements Drive {
    private State state = State.RESETTING;
    private double shiftAmount;

    public String getDstate() {
        return this.state.toString();
    }

    @Override
    public String getName() {
        return "Bullet Shielding Drive";
    }

    @Override
    public void onRoundBegin() {
        this.reset();
    }

    public void reset() {
        this.state = State.RESETTING;
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        if (this.state == State.MOVING_TO_FIRE || this.state == State.MOVING_TO_STANDING) {
            if (Math.abs(Resources.getRobotProxy().getVelocity()) < 0.01) {
                if (this.state == State.MOVING_TO_FIRE) {
                    this.state = State.AT_FIRING;
                } else if (this.state == State.MOVING_TO_STANDING) {
                    this.state = State.AT_STANDING;
                }
            } else {
                return;
            }
        }
        if (this.state == State.REQ_MOVE_TO_FIRE) {
            this.state = State.MOVING_TO_FIRE;
            driveController.setTurnRightDegrees(0.0);
            driveController.setAhead(this.shiftAmount);
            driveController.setMaxVelocity(8.0);
        } else if (this.state == State.REQ_MOVE_TO_STANDING) {
            this.state = State.MOVING_TO_STANDING;
            driveController.setTurnRightDegrees(0.0);
            driveController.setBack(this.shiftAmount);
            driveController.setMaxVelocity(8.0);
        } else if (this.state != State.AT_FIRING) {
            if (this.state == State.RESETTING) {
                this.state = State.MOVING_TO_STANDING;
            }
            Snapshot mySnapshot = Resources.getSnapshotHistory().getMySnapshot();
            double perpAngle = RCMath.normalizeDegrees(RCMath.getRobocodeAngle(mySnapshot, opponentSnapshot) + 90.0);
            driveController.drive(perpAngle, 0.0);
        }
    }

    @Override
    public void drive(DriveController driveController) {
        driveController.drive(Resources.getRobotProxy().getBackAsFrontHeadingDegrees(), 0.0);
    }

    public int getMoveTimeNeededForWave(Wave wave) {
        return Math.abs(wave.getInitialAttackerSnapshot().getVelocity()) < 0.01 ? 2 : 0;
    }

    public void requestMoveToFiringPosition(Wave targetedWave) {
        this.shiftAmount = Math.abs(targetedWave.getInitialAttackerSnapshot().getVelocity()) < 0.01 ? 0.01 : 0.0;
        this.state = this.shiftAmount == 0.0 ? State.AT_FIRING : State.REQ_MOVE_TO_FIRE;
    }

    public void requestMoveToStandingPosition() {
        this.state = this.shiftAmount == 0.0 ? State.AT_STANDING : State.REQ_MOVE_TO_STANDING;
    }

    public boolean isAtFiringPosition() {
        return this.state == State.AT_FIRING;
    }

    public boolean isAtStandingPosition() {
        return this.state == State.AT_STANDING;
    }

    private static enum State {
        RESETTING,
        MOVING_TO_STANDING,
        AT_STANDING,
        REQ_MOVE_TO_FIRE,
        MOVING_TO_FIRE,
        AT_FIRING,
        REQ_MOVE_TO_STANDING;

    }
}

