/*
 * Decompiled with CFR 0.152.
 */
package tornyil.Lajcsi2;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import tornyil.Lajcsi2.utils.Lajcsi2Utils;
import tornyil.Lajcsi2.utils.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lajcsi2sm
extends AdvancedRobot {
    static final int BINS = 49;
    static final int BINS_MIDDLE = 24;
    static final int BTIME_SEGMENTS = 5;
    static final int LATVEL_SEGMENTS = 8;
    static final int INACTIVE_WAVE_REMOVE_OFFSET = 5;
    static final double DISTANCE_HOT = 50.0;
    static double[][][] btimeLatvel_GuessFactors;
    private static final double CHANGE_DIR_RND_FACTOR = 0.05;
    private static final double WALL_STICK = 130.0;
    private static Rectangle2D.Double fieldRect;
    ArrayList waves;
    int enemyDirection;
    double enemyEnergy;
    boolean isTC;
    int moveDirection;

    public void run() {
        this.waves = new ArrayList();
        if (btimeLatvel_GuessFactors == null) {
            btimeLatvel_GuessFactors = new double[5][8][49];
        }
        this.setColors(Color.red, Color.black, Color.red);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        Bullet bullet;
        Point2D.Double double_ = new Point2D.Double(this.getX(), this.getY());
        double d = scannedRobotEvent.getDistance();
        Point2D point2D = Lajcsi2Utils.project(double_, this.getHeadingRadians() + scannedRobotEvent.getBearingRadians(), d);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + scannedRobotEvent.getBearingRadians() - this.getRadarHeadingRadians())) * (double)2);
        this.enemyEnergy = scannedRobotEvent.getEnergy();
        double d2 = this.calcFirePower(scannedRobotEvent);
        double d3 = Lajcsi2Utils.calcLateralVelocity(scannedRobotEvent.getVelocity(), scannedRobotEvent.getHeadingRadians(), scannedRobotEvent.getBearingRadians(), this.getHeadingRadians());
        int n = this.segmentOnBTime(d / Lajcsi2Utils.bulletVelocity(d2));
        int n2 = this.segmentOnLatVel(d3);
        this.updateWaves(point2D.getX(), point2D.getY(), this.getTime());
        if (scannedRobotEvent.getVelocity() != 0.0) {
            this.enemyDirection = d3 < 0.0 ? -1 : 1;
        }
        Wave wave = new Wave(this.getX(), this.getY(), this.getHeadingRadians(), scannedRobotEvent.getBearingRadians(), d2, this.enemyDirection, this.getTime(), d3, d, false);
        this.waves.add(wave);
        if (this.waves.size() > 0) {
            double d4 = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
            if (this.enemyEnergy > 1.0E-4 && d > 50.0) {
                d4 += this.calcNewGunOffset(btimeLatvel_GuessFactors[n][n2]);
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(d4 - this.getGunHeadingRadians())));
        }
        if (Math.abs(this.getGunTurnRemainingRadians()) < Lajcsi2Utils.botWidthAimAngle(d) / (double)2 && (bullet = this.setFireBullet(d2)) != null) {
            wave.setFiring(true);
            wave.setGunHeadingWhenFired(this.getGunHeadingRadians());
        }
        double d5 = Math.atan2(((Point2D)double_).getX() - point2D.getX(), ((Point2D)double_).getY() - point2D.getY());
        if (Math.random() < 0.05) {
            this.moveDirection *= -1;
        }
        d5 += (double)this.moveDirection * 0.7 * Math.PI / (double)2;
        d5 = Lajcsi2sm.wallSmoothing(double_, d5, this.moveDirection);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(d5 - this.getHeadingRadians())));
        this.setAhead(Double.POSITIVE_INFINITY);
    }

    double calcFirePower(ScannedRobotEvent scannedRobotEvent) {
        if (this.isTC) {
            return 3;
        }
        double d = this.getEnergy();
        double d2 = d < 10.0 ? 1.0 : (double)2;
        d2 = this.enemyEnergy < 1.0E-4 ? 1.0 : Math.min(d2, this.enemyEnergy / (double)5);
        d2 = Math.min(d2, d);
        return d2;
    }

    int segmentOnBTime(double d) {
        return Math.min(4, (int)(d * (double)5 / 91.0));
    }

    int segmentOnLatVel(double d) {
        return Math.min(7, (int)((d + 8.0) * 8.0 / 16.1));
    }

    void updateWaves(double d, double d2, long l) {
        int n = 0;
        while (n < this.waves.size()) {
            Wave wave = (Wave)this.waves.get(n);
            if (wave.getAlreadyPassed()) {
                if (wave.passed(d, d2, l - (long)5)) {
                    this.waves.remove(n--);
                }
            } else if (wave.passed(d, d2, l)) {
                wave.setAlreadyPassed();
                this.registerWaveHit(d, d2, wave);
            }
            ++n;
        }
    }

    void registerWaveHit(double d, double d2, Wave wave) {
        int n = this.segmentOnBTime(wave.getBFT());
        int n2 = this.segmentOnLatVel(wave.getLateralVelocity());
        double d3 = Lajcsi2Utils.botWidthAimAngle(wave.getDistance());
        double d4 = wave.calcAngleOffset(d, d2);
        this.adjustBin(n, n2, wave.calcGuessFactor(d4));
        this.adjustBin(n, n2, wave.calcGuessFactor(d4 + d3));
        this.adjustBin(n, n2, wave.calcGuessFactor(d4 - d3));
    }

    void adjustBin(int n, int n2, double d) {
        int n3 = (int)Math.round(24.0 * (d + 1.0));
        int n4 = 0;
        while (n4 < 49) {
            Lajcsi2sm.btimeLatvel_GuessFactors[n][n2][n4] = (500.0 * btimeLatvel_GuessFactors[n][n2][n4] + 1.0 / (Math.pow(n4 - n3, 2) + 1.0)) / 501.0;
            ++n4;
        }
        double[] dArray = btimeLatvel_GuessFactors[n][n2];
        int n5 = n3;
        dArray[n5] = dArray[n5] + 1.0;
    }

    double calcNewGunOffset(double[] dArray) {
        Wave wave = (Wave)this.waves.get(this.waves.size() - 1);
        int n = 24;
        int n2 = 0;
        while (n2 < 49) {
            if (dArray[n] < dArray[n2]) {
                n = n2;
            }
            ++n2;
        }
        double d = ((double)n - 24.0) / 24.0;
        return (double)this.enemyDirection * d * wave.maxEscapeAngle();
    }

    private static final double wallSmoothing(Point2D point2D, double d, int n) {
        while (!fieldRect.contains(Lajcsi2Utils.project(point2D, d, 130.0))) {
            d += (double)n * 0.05;
        }
        return d;
    }

    private final /* synthetic */ void this() {
        this.enemyDirection = 1;
        this.moveDirection = 1;
    }

    public Lajcsi2sm() {
        this.this();
    }

    static {
        fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    }
}

