/*
 * Decompiled with CFR 0.152.
 */
package us.bluetorch.robocode.movement;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import us.bluetorch.robocode.movement.Movement;

public class MinimumRisk
extends Movement {
    static Point2D myLocation;
    static Point2D last;
    static HashMap enemies;
    static HashMap stats;
    static int round;
    static Point2D next;
    static EnemyInfo currentTarget;

    public MinimumRisk(AdvancedRobot robot) {
        super(robot);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        enemies.remove(e.getName());
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        EnemyInfo enemy = (EnemyInfo)enemies.get(e.getName());
        if (enemy != null) {
            enemy.lastHit = this.robot.getTime();
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        double velocity;
        int[][][][] currentStats;
        String name = e.getName();
        EnemyInfo enemy = (EnemyInfo)enemies.get(name);
        if (enemy == null) {
            enemy = new EnemyInfo();
            enemies.put(name, enemy);
        }
        if ((currentStats = (int[][][][])stats.get(name)) == null) {
            currentStats = new int[2][3][13][31];
            stats.put(name, currentStats);
        }
        Point2D.Double myLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        double absBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double distance = e.getDistance();
        Point2D loc = MinimumRisk.projectPoint(myLocation, absBearing, distance);
        enemy.setLocation(loc);
        enemy.velocity = velocity = e.getVelocity();
        int accl = (int)Math.round(Math.abs(enemy.velocity) - Math.abs(velocity));
        if (accl != 0) {
            accl = accl < 0 ? 1 : 2;
        }
        double latd = e.getHeadingRadians() - absBearing;
        double energy = enemy.energy = e.getEnergy();
        double power = Math.min(Math.min(3.0, 1200.0 / distance), Math.min(this.robot.getEnergy(), enemy.energy) / 4.0);
        double bulletv = 20.0 - 3.0 * power;
        int[] current = currentStats[Math.min(this.robot.getOthers() - 1, 1)][this.robot.getOthers() == 1 ? accl : (int)(Math.cos(latd) * velocity / Math.abs(velocity) * 1.4 + 1.4)][(int)(distance / bulletv / 15.0)];
        double direction = (double)(Math.sin(latd) * velocity < 0.0 ? -1 : 1) * Math.asin(8.0 / bulletv);
        Vector waves = enemy.waves;
        int i = waves.size();
        while (i > 0) {
            if (!((MeleeBullet)waves.elementAt(--i)).updateEnemy(loc, this.robot.getTime())) continue;
            waves.removeElementAt(i);
        }
        MeleeBullet wave = new MeleeBullet();
        waves.add(wave);
        wave.startPoint = myLocation;
        wave.startgunheading = absBearing;
        wave.direction = direction;
        wave.lastPoint = loc;
        wave.bulletspeed = bulletv;
        wave.lasttime = this.robot.getTime();
        wave.segment = current;
    }

    @Override
    public void init() {
        if (this.robot.getRoundNum() > round) {
            round = this.robot.getRoundNum();
            enemies = new HashMap();
            next = null;
            currentTarget = null;
        }
        myLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        if (this.getTarget() != null) {
            currentTarget = (EnemyInfo)enemies.get(this.getTarget());
        }
        if (currentTarget != null) {
            if (next == null) {
                next = last = myLocation;
            }
            if (next.distance(myLocation) < 15.0 || this.robot.getOthers() > 1) {
                boolean changed = false;
                double angle = 0.0;
                double moveDist = myLocation.distance(currentTarget);
                moveDist = (this.robot.getOthers() == 1 ? Math.random() * moveDist : Math.min(500.0, moveDist)) * 0.5;
                do {
                    Point2D p;
                    if (!this.inField(p = MinimumRisk.projectPoint(myLocation, angle, moveDist)) || !(this.findRisk(p) < this.findRisk(next))) continue;
                    changed = true;
                    next = p;
                } while ((angle += 0.1) < Math.PI * 2);
                if (changed) {
                    last = myLocation;
                }
            }
            double a2 = Utils.normalRelativeAngle((double)(MinimumRisk.angle(next, myLocation) - this.robot.getHeadingRadians()));
            double a1 = Math.atan(Math.tan(a2));
            this.robot.setTurnRightRadians(a1);
            this.robot.setAhead(Math.abs(this.robot.getTurnRemainingRadians()) > 1.0 ? 0.0 : (a1 == a2 ? 1.0 : -1.0) * next.distance(myLocation));
        }
        this.robot.execute();
    }

    private double findRisk(Point2D point) {
        double risk = 0.0;
        Collection enemySet = enemies.values();
        Iterator it = enemySet.iterator();
        do {
            EnemyInfo e = (EnemyInfo)it.next();
            double thisrisk = (e.energy + 50.0) / point.distanceSq(e);
            int closer = 0;
            Iterator it2 = enemySet.iterator();
            do {
                EnemyInfo e2;
                if (!(e.distance(e2 = (EnemyInfo)it2.next()) * 0.9 > e.distance(point))) continue;
                ++closer;
            } while (it2.hasNext());
            if (closer <= 1 || e.lastHit > this.robot.getTime() - 200L) {
                thisrisk *= 2.0 + 2.0 * Math.abs(Math.cos(MinimumRisk.angle(myLocation, point) - MinimumRisk.angle(e, myLocation)));
            }
            risk += thisrisk;
        } while (it.hasNext());
        if (this.robot.getOthers() > 1) {
            risk += Math.random() / last.distanceSq(point);
        }
        return risk += Math.random() / 5.0 / myLocation.distanceSq(point);
    }

    public static Point2D projectPoint(Point2D startPoint, double theta, double dist) {
        return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
    }

    public static double angle(Point2D point2, Point2D point1) {
        return Math.atan2(point2.getX() - point1.getX(), point2.getY() - point1.getY());
    }

    public boolean inField(Point2D p) {
        return new Rectangle2D.Double(30.0, 30.0, this.robot.getBattleFieldWidth() - 60.0, this.robot.getBattleFieldHeight() - 60.0).contains(p);
    }

    static {
        enemies = null;
        stats = new HashMap();
        round = Integer.MIN_VALUE;
        next = null;
        currentTarget = null;
    }

    public class MeleeBullet {
        Point2D startPoint;
        Point2D lastPoint;
        double startgunheading;
        double direction;
        double bulletspeed;
        double bulletd;
        long lasttime;
        int[] segment;

        public boolean updateEnemy(Point2D enemy, long time) {
            long dtime = time - this.lasttime;
            double dx = (enemy.getX() - this.lastPoint.getX()) / (double)dtime;
            double dy = (enemy.getY() - this.lastPoint.getY()) / (double)dtime;
            while (this.lasttime < time) {
                if (this.startPoint.distance(this.lastPoint) <= this.bulletd) {
                    int n = Math.min(30, Math.max(0, (int)Math.round((1.0 + Utils.normalRelativeAngle((double)(MinimumRisk.angle(this.lastPoint, this.startPoint) - this.startgunheading)) / this.direction) * 15.0)));
                    this.segment[n] = this.segment[n] + 1;
                    return true;
                }
                ++this.lasttime;
                this.bulletd += this.bulletspeed;
                this.lastPoint.setLocation(this.lastPoint.getX() + dx, this.lastPoint.getY() + dy);
            }
            return false;
        }
    }

    private class EnemyInfo
    extends Point2D.Double {
        long lastHit;
        double energy;
        double velocity;
        Vector waves = new Vector();

        private EnemyInfo() {
        }
    }
}

