/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun.segmentation;

import ags.muse.gun.segmentation.Dimension;
import ags.muse.gun.segmentation.SegmentConfig;
import ags.util.BinUtils;
import ags.util.Range;

public class SegmentedStorage {
    private final SegmentConfig config;
    private final double[][] buffers;
    private final double[] totals;
    private final int[] agestamp;
    private final int bins;
    private final double halfLife;
    private double total;
    private int age;

    public SegmentedStorage(SegmentConfig config, int bins) {
        this(config, bins, Double.POSITIVE_INFINITY);
    }

    public SegmentedStorage(SegmentConfig config, int bins, double halfLife) {
        if (config.getLength() == 0) {
            throw new IllegalArgumentException();
        }
        this.config = new SegmentConfig(config);
        this.buffers = new double[this.getConfig().getLength()][];
        this.totals = new double[this.getConfig().getLength()];
        this.agestamp = new int[this.getConfig().getLength()];
        this.bins = bins;
        this.age = 0;
        this.total = 0.0;
        this.halfLife = halfLife;
    }

    public double[] getInterpolatedBuffer(Dimension.Data<Double> d) {
        double[] floatIndicies = this.getConfig().getFloatIndicies(d);
        double[] buffer = new double[this.bins];
        this.recursiveRead(buffer, floatIndicies, 0, 0, 1, 1.0);
        if (this.total != 0.0) {
            SegmentedStorage.multBins(buffer, 1.0 / this.total);
        }
        return buffer;
    }

    public void recordGF(Dimension.Data<Double> d, Range gfRange, double weight) {
        this.recursiveWrite(BinUtils.makeSmoothedBins(this.bins, gfRange), this.getConfig().getFloatIndicies(d), 0, 0, 1, weight);
    }

    private void recursiveRead(double[] dest, double[] floatIndicies, int indexCount, int index, int multiplier, double weight) {
        if (indexCount == floatIndicies.length) {
            if (this.buffers[index] != null) {
                if (this.halfLife != Double.POSITIVE_INFINITY && this.age != this.agestamp[index]) {
                    double ageFactor = Math.pow(0.5, (double)(this.age - this.agestamp[index]) / this.halfLife);
                    SegmentedStorage.multBins(this.buffers[index], ageFactor);
                    int n = index;
                    this.totals[n] = this.totals[n] * ageFactor;
                    this.agestamp[index] = this.age;
                }
                SegmentedStorage.sumBins(dest, this.buffers[index], weight);
            }
            return;
        }
        double i = floatIndicies[indexCount];
        int fi = (int)Math.floor(i);
        int ci = (int)Math.ceil(i);
        if ((double)fi == i) {
            this.recursiveRead(dest, floatIndicies, indexCount + 1, index + multiplier * fi, multiplier * this.getConfig().getSegmentLength(indexCount), weight);
            return;
        }
        this.recursiveRead(dest, floatIndicies, indexCount + 1, index + multiplier * fi, multiplier * this.getConfig().getSegmentLength(indexCount), weight * ((double)ci - i));
        this.recursiveRead(dest, floatIndicies, indexCount + 1, index + multiplier * ci, multiplier * this.getConfig().getSegmentLength(indexCount), weight * (i - (double)fi));
    }

    private void recursiveWrite(double[] src, double[] floatIndicies, int indexCount, int index, int multiplier, double weight) {
        if (indexCount == floatIndicies.length) {
            if (this.buffers[index] == null) {
                this.buffers[index] = new double[this.bins];
            } else if (this.halfLife != Double.POSITIVE_INFINITY && this.age != this.agestamp[index]) {
                double ageFactor = Math.pow(0.5, (double)(this.age - this.agestamp[index]) / this.halfLife);
                SegmentedStorage.multBins(this.buffers[index], ageFactor);
                int n = index;
                this.totals[n] = this.totals[n] * ageFactor;
            }
            SegmentedStorage.sumBins(this.buffers[index], src, weight);
            int n = index;
            this.totals[n] = this.totals[n] + weight;
            this.total += weight;
            this.agestamp[index] = this.age;
            return;
        }
        double i = floatIndicies[indexCount];
        int fi = (int)Math.floor(i);
        int ci = (int)Math.ceil(i);
        if ((double)fi == i) {
            this.recursiveWrite(src, floatIndicies, indexCount + 1, index + multiplier * fi, multiplier * this.getConfig().getSegmentLength(indexCount), weight);
            return;
        }
        this.recursiveWrite(src, floatIndicies, indexCount + 1, index + multiplier * fi, multiplier * this.getConfig().getSegmentLength(indexCount), weight * ((double)ci - i));
        this.recursiveWrite(src, floatIndicies, indexCount + 1, index + multiplier * ci, multiplier * this.getConfig().getSegmentLength(indexCount), weight * (i - (double)fi));
    }

    private static void sumBins(double[] dest, double[] source, double weight) {
        int i = 0;
        while (i < source.length) {
            int n = i;
            dest[n] = dest[n] + source[i] * weight;
            ++i;
        }
    }

    private static void multBins(double[] dest, double v) {
        int i = 0;
        while (i < dest.length) {
            int n = i++;
            dest[n] = dest[n] * v;
        }
    }

    public SegmentConfig getConfig() {
        return this.config;
    }

    public void incrementAge() {
        ++this.age;
        if (this.halfLife != Double.POSITIVE_INFINITY) {
            this.total *= Math.pow(0.5, 1.0 / this.halfLife);
        }
    }

    public static void main(String[] args) {
        SegmentConfig conf = new SegmentConfig(){
            {
                this.add(Dimension.ACCEL, true, 0.0, 4.0, 8.0);
            }
        };
        Dimension.Data<Double> s = new Dimension.Data<Double>();
        s.put(Dimension.ACCEL, -200.0);
        SegmentedStorage stor = new SegmentedStorage(conf, 5);
        stor.recordGF(s, new Range(0.1, 0.5), 1.0);
        int i = 0;
        while (i < stor.buffers.length) {
            int j = 0;
            while (j < stor.buffers[i].length) {
                System.out.print(String.valueOf(stor.buffers[i][j]) + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        Dimension.Data<Double> a = new Dimension.Data<Double>();
        a.put(Dimension.ACCEL, 0.1);
        double[] ss = stor.getInterpolatedBuffer(a);
        int j = 0;
        while (j < ss.length) {
            System.out.print(String.valueOf(ss[j]) + "  ");
            ++j;
        }
        System.out.println();
    }
}

