/*
 * Decompiled with CFR 0.152.
 */
package ags.util;

import ags.util.Range;

public final class BinUtils {
    private BinUtils() {
    }

    public static double indexToGF(int bins, double index) {
        return index / (double)(bins - 1) * 2.0 - 1.0;
    }

    public static double gfToIndex(int bins, double gf) {
        return Math.min(1.0, Math.max(0.0, (gf + 1.0) / 2.0)) * (double)(bins - 1);
    }

    public static double[] makeSmoothedBins(int bins, Range range) {
        double[] d = new double[bins];
        BinUtils.makeSmoothedBins(d, range, 1.0);
        return d;
    }

    public static void makeSmoothedBins(double[] bins, Range range, double weight) {
        Range indexRange = new Range(BinUtils.gfToIndex(bins.length, range.getLower()), BinUtils.gfToIndex(bins.length, range.getUpper()));
        double center = indexRange.getCenter();
        int i = 0;
        while (i < bins.length) {
            int n = i;
            bins[n] = bins[n] + weight / Math.pow(indexRange.distanceOutside(i) * 1.3 + 0.2 * Math.abs((double)i - center) + 1.0, 1.5);
            ++i;
        }
    }

    public static double[] makeFullSBins(int bins, Range range) {
        double[] d = new double[bins];
        BinUtils.makeFullSBins(d, range, 1.0);
        return d;
    }

    public static void makeFullSBins(double[] bins, Range range, double weight) {
        int centerIndex = (int)Math.round(BinUtils.gfToIndex(bins.length, range.getCenter()));
        int i = 0;
        while (i < bins.length) {
            int n = i;
            bins[n] = bins[n] + weight / Math.pow(1.5 * (double)Math.abs(i - centerIndex) + 1.0, 1.5);
            ++i;
        }
    }

    public static double[] makeRectBins(int bins, Range range) {
        double[] d = new double[bins];
        BinUtils.makeRectBins(d, range, 1.0);
        return d;
    }

    public static void makeRectBins(double[] bins, Range range, double weight) {
        double lower = BinUtils.gfToIndex(bins.length, range.getLower());
        double upper = BinUtils.gfToIndex(bins.length, range.getUpper());
        int minindex = (int)Math.floor(lower);
        int maxindex = (int)Math.ceil(upper);
        int i = minindex;
        while (i <= maxindex) {
            if (i > minindex && i < maxindex) {
                int n = i;
                bins[n] = bins[n] + 1.0 * weight;
            } else {
                int n = i;
                bins[n] = bins[n] + (1.0 - Math.max(0.0, lower - (double)i) - Math.max(0.0, (double)i - upper)) * weight;
            }
            ++i;
        }
    }

    public static double getTotal(double[] bins) {
        double total = 0.0;
        int i = 0;
        while (i < bins.length) {
            total += bins[i];
            ++i;
        }
        return total;
    }

    public static double getTotalInRect(double[] bins, Range range) {
        double total = 0.0;
        double lower = BinUtils.gfToIndex(bins.length, range.getLower());
        double upper = BinUtils.gfToIndex(bins.length, range.getUpper());
        int minindex = (int)Math.floor(lower);
        int maxindex = (int)Math.ceil(upper);
        int i = minindex;
        while (i <= maxindex) {
            total = i > minindex && i < maxindex ? (total += bins[i]) : (total += bins[i] * (1.0 - Math.max(0.0, lower - (double)i) - Math.max(0.0, (double)i - upper)));
            ++i;
        }
        return total;
    }

    public static double getPeakInRange(double[] bins, Range range) {
        double lower = BinUtils.gfToIndex(bins.length, range.getLower());
        double upper = BinUtils.gfToIndex(bins.length, range.getUpper());
        int minindex = Math.max(0, (int)Math.ceil(lower));
        int maxindex = Math.min(bins.length - 1, (int)Math.floor(upper));
        int max = minindex;
        int i = minindex + 1;
        while (i <= maxindex) {
            if (bins[i] > bins[max]) {
                max = i;
            }
            ++i;
        }
        return bins[max];
    }

    public static double getPeakOutsideRange(double[] bins, Range range) {
        double lower = BinUtils.gfToIndex(bins.length, range.getLower());
        double upper = BinUtils.gfToIndex(bins.length, range.getUpper());
        int minindex = Math.max(0, (int)Math.floor(lower));
        int maxindex = Math.min(bins.length - 1, (int)Math.ceil(upper));
        int max = 0;
        int i = 0;
        while (i < bins.length) {
            if (i == minindex + 1) {
                i = maxindex;
            }
            if (bins[i] > bins[max]) {
                max = i;
            }
            ++i;
        }
        return bins[max];
    }

    public static double getMinOutsideRange(double[] bins, Range range) {
        double lower = BinUtils.gfToIndex(bins.length, range.getLower());
        double upper = BinUtils.gfToIndex(bins.length, range.getUpper());
        int minindex = Math.max(0, (int)Math.floor(lower));
        int maxindex = Math.min(bins.length - 1, (int)Math.ceil(upper));
        int min = 0;
        int i = 0;
        while (i < bins.length) {
            if (i == minindex + 1) {
                i = maxindex;
            }
            if (bins[i] < bins[min]) {
                min = i;
            }
            ++i;
        }
        return bins[min];
    }
}

