/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

import java.awt.geom.Point2D;
import java.io.Serializable;
import labg.util.FriendlyBullet;
import labg.util.Stat;

public class Enemy
implements Serializable {
    public String name = "";
    public transient double prevBearing = 0.0;
    public transient double currBearing = 0.0;
    public transient double currBearingRel2Gun = 0.0;
    public transient double prevBearingRel2Gun = 0.0;
    public transient double distance = 100000.0;
    public transient double currEnergy = 0.0;
    public transient double prevEnergy = 0.0;
    public transient double velocity = 0.0;
    public transient double prevVelocity = 0.0;
    public transient double heading = 0.0;
    public transient double prevHeading = 0.0;
    public transient long timeLastSeen = -10000L;
    public transient long prevTimeLastSeen = -10000L;
    public transient boolean isAlive = true;
    public transient boolean isTarget = false;
    public transient double xPos;
    public transient double yPos;
    public transient double prevXPos;
    public transient double prevYPos;
    public transient double xPosAdjust;
    public transient double yPosAdjust;
    public transient double damToMe = 0.0;
    public transient double timeLastHitMe = 0.0;
    public transient double energyChangedAmount;
    public transient double timeLastChecked;
    public transient double energyLastChecked = 100.0;
    public transient double hits = 1.0E-6;
    public transient double shots = 1.0E-6;
    public transient double accuracy;
    public transient boolean takenShot = true;
    private Stat[][][] stats;

    public Enemy(String name) {
        this.name = name;
        this.stats = new Stat[2][4][22];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 4) {
                double gf = -2.0;
                int k = 0;
                while (k < 22) {
                    this.stats[i][j][k] = new Stat(gf);
                    gf += 0.2;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public Point2D.Double guessPosition(long when) {
        double diff = when - this.timeLastSeen;
        double newY = this.yPos + Math.cos(this.heading) * this.velocity * diff;
        double newX = this.xPos + Math.sin(this.heading) * this.velocity * diff;
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessCircularPosition(long when, double factor, int iteration) {
        double diff = when - this.timeLastSeen;
        double factVel = this.velocity + this.getAccPerTick() * (double)iteration;
        if (factVel > 8.0) {
            factVel = 8.0;
        } else if (factVel < -8.0) {
            factVel = -8.0;
        }
        double radius = factVel * factor / (this.heading - this.prevHeading);
        double tothead = diff * (this.heading - this.prevHeading);
        double newY = this.yPos + Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius;
        double newX = this.xPos + Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius;
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessPosition(long when, double factor, int iteration) {
        double factVel = this.velocity + this.getAccPerTick() * (double)iteration;
        if (factVel > 8.0) {
            factVel = 8.0;
        } else if (factVel < -8.0) {
            factVel = -8.0;
        }
        double diff = when - this.timeLastSeen;
        double newY = this.yPos + Math.cos(this.heading) * (factVel * factor) * diff;
        double newX = this.xPos + Math.sin(this.heading) * (factVel * factor) * diff;
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessCircularPosition(long when) {
        double diff = when - this.timeLastSeen;
        double radius = this.velocity / (this.heading - this.prevHeading);
        double tothead = diff * (this.heading - this.prevHeading);
        double newY = this.yPos + Math.sin(this.heading + tothead) * radius - Math.sin(this.heading) * radius;
        double newX = this.xPos + Math.cos(this.heading) * radius - Math.cos(this.heading + tothead) * radius;
        return new Point2D.Double(newX, newY);
    }

    private double getAccPerTick() {
        return (this.velocity - this.prevVelocity) / (double)(this.timeLastSeen - this.prevTimeLastSeen);
    }

    public boolean energyChanged() {
        if (this.currEnergy != this.energyLastChecked) {
            this.energyChangedAmount = this.energyLastChecked - this.currEnergy;
            if (this.energyChangedAmount >= 0.09 && this.energyChangedAmount <= 3.01) {
                this.energyLastChecked = this.currEnergy;
                return true;
            }
            this.energyLastChecked = this.currEnergy;
            return false;
        }
        return false;
    }

    public void updateStats(FriendlyBullet b, boolean hit, boolean melee) {
        if (melee) {
            if (hit) {
                this.stats[0][b.distanceIndex][b.guessIndex].addHit();
            } else {
                this.stats[0][b.distanceIndex][b.guessIndex].addMiss();
            }
        } else if (hit) {
            this.stats[1][b.distanceIndex][b.guessIndex].addHit();
        } else {
            this.stats[1][b.distanceIndex][b.guessIndex].addMiss();
        }
    }

    public double getBestGuessFactor(int distIndex, boolean melee) {
        double gf = 1.0;
        double bestAcc = 0.0;
        int bestIndex = 0;
        int i = 0;
        while (i < 22) {
            double tempAcc;
            if (melee) {
                tempAcc = this.stats[0][distIndex][i].getAccuracy();
                if (tempAcc > bestAcc) {
                    bestAcc = tempAcc;
                    bestIndex = i;
                    if (bestAcc > 0.0) {
                        gf = this.stats[0][distIndex][i].gf;
                    }
                }
            } else {
                tempAcc = this.stats[1][distIndex][i].getAccuracy();
                if (tempAcc > bestAcc) {
                    bestAcc = tempAcc;
                    bestIndex = i;
                    if (bestAcc > 0.0) {
                        gf = this.stats[1][distIndex][i].gf;
                    }
                }
            }
            ++i;
        }
        return gf;
    }

    public double getTargetPotential() {
        this.accuracy = this.hits / this.shots * 100.0;
        if (this.shots < 10.0) {
            return 1.0 / this.distance;
        }
        return this.isAlive ? this.hits / this.shots / this.distance : -1000.0;
    }

    public void reset() {
        this.isAlive = true;
        this.prevBearing = 0.0;
        this.currBearing = 0.0;
        this.currBearingRel2Gun = 0.0;
        this.prevBearingRel2Gun = 0.0;
        this.distance = 100000.0;
        this.currEnergy = 0.0;
        this.prevEnergy = 0.0;
        this.velocity = 0.0;
        this.prevVelocity = 0.0;
        this.heading = 0.0;
        this.prevHeading = 0.0;
        this.timeLastSeen = -10000L;
        this.prevTimeLastSeen = -10000L;
        this.isAlive = true;
        this.isTarget = false;
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.xPosAdjust = 0.0;
        this.yPosAdjust = 0.0;
        this.damToMe = 0.0;
        this.timeLastHitMe = 0.0;
        this.energyChangedAmount = 0.0;
        this.timeLastChecked = 0.0;
        this.energyLastChecked = 100.0;
        this.takenShot = true;
    }
}

