/*
 * Decompiled with CFR 0.152.
 */
package ds.gun;

import ds.DateTime;
import ds.Hud;
import ds.constant.ConstantManager;
import ds.gun.FireSolution;
import ds.targeting.ITargetManager;
import java.awt.Color;
import robocode.AdvancedRobot;

public abstract class AbstractGun {
    private DateTime m_lastFsTime;
    private FireSolution m_lastFs;
    private AdvancedRobot m_owner;
    private ITargetManager m_targetManager;
    private Color m_color;
    private String m_name;

    public AbstractGun(String name, AdvancedRobot owner, ITargetManager targetManager, Color color) {
        this.m_owner = owner;
        this.m_targetManager = targetManager;
        this.m_color = color;
        this.m_lastFsTime = new DateTime(-1L, -1L);
        this.m_name = name;
    }

    public final FireSolution getFireSolution(double bulletPower) {
        DateTime currentDateTime = new DateTime(this.m_owner.getRoundNum(), this.m_owner.getTime());
        if (this.m_lastFsTime.before(currentDateTime)) {
            this.m_lastFs = this.computeFireSolution(bulletPower);
        }
        this.m_lastFsTime = currentDateTime;
        return this.m_lastFs;
    }

    protected abstract FireSolution computeFireSolution(double var1);

    protected final AdvancedRobot getOwner() {
        return this.m_owner;
    }

    protected final ITargetManager getTargetManager() {
        return this.m_targetManager;
    }

    public Color getColor() {
        return this.m_color;
    }

    public String getName() {
        return this.m_name;
    }

    public double getConfidence() {
        return ConstantManager.getInstance().getDoubleConstant("gun." + this.getName() + ".confidence");
    }

    public void Act(double power) {
    }

    public abstract void paint(Hud var1, long var2);

    public void virtualFire(double power) {
    }
}

