/*
 * Decompiled with CFR 0.152.
 */
package arthord.micro;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Muffin
extends AdvancedRobot {
    static final int GUESS_FACTORS = 101;
    static final int FACTOR_OFFSET = 50;
    static final int DIST_FACTORS = 10;
    static final int DIST_SIZE = 120;
    static final int VELOCITY_FACTORS = 6;
    static final int VELOCITY_SIZE = 3;
    static final int ACCEL_FACTORS = 3;
    static final int WAVE_INTERVAL = 3;
    static final int DESIRED_DISTANCE = 500;
    static final double DEGRADATION_RATE = 1.05;
    static int eLastVel;
    static int direction;
    static int[][][][] guessFactors;
    static double eX;
    static double eY;
    static double eLastEnergy;
    static double lastShotVelocity;
    static double targetDistance;
    static double lastDirectionChangeTime;
    static boolean flatten;

    public void run() {
        eLastVel = 0;
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double d2;
        double d3;
        int x = 0;
        int bestx = 50;
        int best = 0;
        double patternOffset = 0.0;
        double targetVelocity = e.getVelocity();
        double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        int eDir = d3 * Math.sin(e.getHeadingRadians() - d2) > 0.0 ? 1 : -1;
        targetDistance = e.getDistance();
        int[] currentSegment = guessFactors[Math.min(Math.max((int)targetVelocity - eLastVel, -1), 1) + 1][(int)(targetVelocity + 8.0) / 3][(int)targetDistance / 120];
        eLastVel = (int)targetVelocity;
        double X = this.getX();
        eX = X + targetDistance * Math.sin(targetBearing);
        double Y = this.getY();
        eY = Y + targetDistance * Math.cos(targetBearing);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(targetBearing - this.getRadarHeadingRadians())) * (double)2);
        eLastEnergy -= e.getEnergy();
        if (d >= 0.1 && eLastEnergy <= (double)3) {
            lastShotVelocity = 20.0 - (double)3 * eLastEnergy;
        }
        eLastEnergy = e.getEnergy();
        double attackAngle = 1.5882496193148399;
        while (!new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0).contains(X + (double)(direction * 117) * Math.sin(targetBearing + (attackAngle -= Math.PI / 180)), Y + (double)(direction * 117) * Math.cos(targetBearing + attackAngle))) {
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(e.getBearingRadians() + attackAngle)));
        if (Math.random() < 2.25 / (targetDistance / lastShotVelocity + 9.0) && flatten || attackAngle < 0.7853981633974483) {
            direction = -direction;
            lastDirectionChangeTime = this.getTime();
        }
        this.setAhead(direction * 100);
        do {
            if (this.getEnergy() > (double)3 && this.getTime() % (long)3 == 0L) {
                VirtualBullet vb = new VirtualBullet();
                vb.x = X;
                vb.y = Y;
                vb.heading = targetBearing + (double)eDir * Math.toRadians(x - 50);
                vb.guessFactor = x;
                vb.currentSegment = currentSegment;
                this.addCustomEvent(vb);
            }
            if (currentSegment[x] <= best) continue;
            best = currentSegment[x];
            bestx = x;
        } while (++x < 101);
        if (e.getEnergy() <= 0.0) {
            eDir = 0;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetBearing + (double)eDir * Math.toRadians(bestx - 50) - this.getGunHeadingRadians())));
        if (this.getEnergy() > 1.0) {
            this.setFire(this.getEnergy() - (double)2);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if ((double)this.getTime() - lastDirectionChangeTime > targetDistance / e.getVelocity() && targetDistance > 200.0) {
            flatten = true;
        }
    }

    static {
        direction = 1;
        guessFactors = new int[3][6][10][101];
        flatten = false;
    }

    private class VirtualBullet
    extends Condition {
        int guessFactor;
        int[] currentSegment;
        double x;
        double y;
        double heading;

        public boolean test() {
            this.x += Math.sin(this.heading) * 11.0;
            this.y += Math.cos(this.heading) * 11.0;
            if (Point2D.Double.distance(this.x, this.y, eX, eY) < 20.0) {
                int n = this.guessFactor;
                this.currentSegment[n] = this.currentSegment[n] + 1;
                Muffin.this.removeCustomEvent(this);
            }
            if (!new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0).contains(this.x, this.y)) {
                Muffin.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

