/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.predict.Tracer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TracerController {
    private List tracers = new LinkedList();
    private List hitTracers = new LinkedList();
    private List missedTracers = new LinkedList();
    private int tracersFired = 0;
    private int tracersHit = 0;
    private int tracersMissed = 0;

    public void addTracer(Tracer t) {
        this.tracers.add(t);
        ++this.tracersFired;
    }

    public void doTurn() {
        this.hitTracers.clear();
        this.missedTracers.clear();
        Iterator iter = this.tracers.iterator();
        while (iter.hasNext()) {
            Tracer t = (Tracer)iter.next();
            int status = t.track();
            switch (status) {
                case 0: {
                    break;
                }
                case 1: {
                    this.hitTracers.add(t);
                    iter.remove();
                    ++this.tracersHit;
                    break;
                }
                case 2: {
                    this.missedTracers.add(t);
                    iter.remove();
                    ++this.tracersMissed;
                }
            }
        }
    }

    public List getHitTracers() {
        return this.hitTracers;
    }

    public List getMissedTracers() {
        return this.missedTracers;
    }

    public List getTracers() {
        return this.tracers;
    }

    public int getTracersFiredCount() {
        return this.tracersFired;
    }

    public int getTracersHitCount() {
        return this.tracersHit;
    }

    public int getTracersMissedCount() {
        return this.tracersMissed;
    }

    public void printStats(PrintStream out) {
        out.println("fired = " + this.tracersFired + " hit = " + this.tracersHit + " missed = " + this.tracersMissed);
    }
}

