/*
 * Decompiled with CFR 0.152.
 */
package kid.robot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import kid.cluster.Comparison;
import kid.cluster.Space;
import kid.data.Data;
import kid.data.Drawable;
import kid.data.factor.GuessFactor;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.segmentation.Segmentable;
import kid.utils.Utils;
import kid.virtual.DataWave;
import kid.virtual.VirtualWave;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.Robot;

public class EnemyProfile
implements Drawable {
    private AdvancedRobot robot;
    private RobotData reference;
    private EnemyData enemy;
    private ArrayList<DataWave<GuessFactor, RobotData, RobotData>> waves;
    private Space<GuessFactor, RobotData, RobotData> space = null;
    private int dataPerWave = 10;

    public EnemyProfile(AdvancedRobot myRobot, EnemyData enemy, Comparison[] comparisons) {
        this.init(myRobot, enemy, comparisons, -1);
    }

    public EnemyProfile(AdvancedRobot myRobot, EnemyData enemy, Comparison[] comparisons, int dataPerWave) {
        this.init(myRobot, enemy, comparisons, dataPerWave);
    }

    private void init(AdvancedRobot r, EnemyData e, Comparison[] c, int d) {
        this.robot = r;
        this.reference = new RobotData((Robot)r);
        this.enemy = e;
        if (d > 0) {
            this.dataPerWave = d;
        }
        r.addCustomEvent((Condition)new WaveWatcher(r.getTime()));
        this.waves = new ArrayList();
        this.space = new Space(c);
    }

    public void update(AdvancedRobot r) {
        this.reference = new RobotData((Robot)r);
        r.addCustomEvent((Condition)new WaveWatcher(r.getTime()));
        this.waves = new ArrayList();
    }

    public void fire(double power) {
        power = Utils.limit(0.1, power, 3.0);
        EnemyData view = this.enemy.copy();
        RobotData reference = this.reference.copy();
        Data[] data = this.space.getCluster(view, reference, this.dataPerWave).toArray(new GuessFactor[0]);
        this.waves.add(new DataWave(reference, (RobotData)view, power, data, (Segmentable)view, (Segmentable)reference));
    }

    public GuessFactor[] getCluster(int size) {
        return this.space.getCluster(this.enemy, this.reference.copy(), size).toArray(new GuessFactor[0]);
    }

    public void print() {
        this.space.print(System.out);
    }

    @Override
    public void draw(RGraphics grid) {
        if (DrawMenu.getValue("Waves", "Targeting")) {
            for (DataWave<GuessFactor, RobotData, RobotData> w : this.waves) {
                double dist = w.getDist(grid.getTime()) - 5.0;
                GuessFactor[] data = (GuessFactor[])w.getData();
                double[] bins = new double[101];
                GuessFactor[] guessFactorArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    GuessFactor gf = guessFactorArray[n2];
                    int i = 0;
                    while (i < bins.length) {
                        int n3 = i;
                        bins[n3] = bins[n3] + Utils.limit(0.0, 10.0 / (30.0 * Utils.sqr(Utils.getGuessFactor(i, bins.length) - gf.getGuessFactor()) + 1.0) - 4.99, 5.0);
                        ++i;
                    }
                    ++n2;
                }
                double max = 1.0;
                double[] dArray = bins;
                int n4 = bins.length;
                int n5 = 0;
                while (n5 < n4) {
                    double i = dArray[n5];
                    max = Math.max(max, i);
                    ++n5;
                }
                grid.setStroke(new BasicStroke(1.5f));
                float hue = 0.0f;
                hue = 0.3125f;
                double heading = w.getHeading();
                double x = w.getStartX();
                double y = w.getStartY();
                RobotData view = w.getView();
                double d = Utils.getDirection(view.getHeading(), view.getVelocity(), Utils.angle(x, y, view.getX(), view.getY()));
                double angle = d * Utils.getMaxEscapeAngle(w.getFirePower());
                double angleGF = heading + angle * Utils.getGuessFactor(0, bins.length);
                double prevX = Utils.getX(x, dist, angleGF);
                double prevY = Utils.getY(y, dist, angleGF);
                int i = 1;
                while (i < bins.length) {
                    float brightness = (float)(0.1 + 0.9 * bins[i] / max);
                    grid.setColor(Color.getHSBColor(hue, 1.0f, brightness));
                    angleGF = heading + angle * Utils.getGuessFactor(i, bins.length);
                    double d2 = prevX;
                    double d3 = prevY;
                    prevX = Utils.getX(x, dist, angleGF);
                    prevY = Utils.getY(y, dist, angleGF);
                    grid.drawLine(d2, d3, prevX, prevY);
                    ++i;
                }
            }
        }
    }

    private class WaveWatcher
    extends Condition {
        private long time;

        public WaveWatcher(long curTime) {
            this.time = curTime;
        }

        public boolean test() {
            int i = 0;
            while (i < EnemyProfile.this.waves.size()) {
                DataWave w = (DataWave)EnemyProfile.this.waves.get(i);
                if (w.testHit(EnemyProfile.this.enemy.getX(), EnemyProfile.this.enemy.getY(), EnemyProfile.this.reference.getTime())) {
                    GuessFactor gf = new GuessFactor(Utils.getGuessFactor((VirtualWave)w, (RobotData)w.getView(), EnemyProfile.this.enemy));
                    EnemyProfile.this.space.add(gf, (RobotData)w.getView(), (RobotData)w.getReference());
                    EnemyProfile.this.waves.remove(i--);
                }
                if (w.getCreationTime() == this.time) {
                    ((RobotData)w.getReference()).update((Robot)EnemyProfile.this.robot);
                }
                ++i;
            }
            ++this.time;
            EnemyProfile.this.reference.update((Robot)EnemyProfile.this.robot);
            return false;
        }
    }
}

