/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.FUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Mirror {
    private double awayFactor = 1.0;
    private Rectangle2D.Double BF;
    private AdvancedRobot me;
    private Point2D.Double lastEnemyLocation;
    private Point2D.Double enemyLocation;
    private Point2D.Double myLocation;
    private Point2D.Double center;
    private Point2D.Double mirrorMyLocation;

    public Mirror(AdvancedRobot me) {
        this.me = me;
        this.BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastEnemyLocation = this.enemyLocation;
        this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        this.enemyLocation = FUtils.projectMotion(this.myLocation, this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        if (this.lastEnemyLocation == null) {
            this.lastEnemyLocation = this.enemyLocation;
        }
        this.center = FUtils.projectMotion(this.lastEnemyLocation, FUtils.absoluteBearing(this.lastEnemyLocation, this.myLocation), e.getDistance() / 2.0);
        double tolerance = 0.0;
        double delta = 0.0;
        do {
            this.mirrorMyLocation = FUtils.projectMotion(this.enemyLocation, FUtils.absoluteBearing(this.enemyLocation, this.center) + delta, (e.getDistance() + 0.0 * tolerance) * this.awayFactor);
            tolerance -= 5.0;
            delta += 0.1;
        } while (!this.BF.contains(this.mirrorMyLocation));
    }

    public void doMove() {
        double theta = FUtils.absoluteBearing(this.myLocation, this.mirrorMyLocation) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    public void setAwayFactor(double awayFactor) {
        this.awayFactor = awayFactor;
    }
}

