/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import barontrozo.BulletFollower;
import barontrozo.ChooseStrategicPosition;
import barontrozo.CirclePatrol;
import barontrozo.ConfigurationValues;
import barontrozo.GotoManoeubre;
import barontrozo.PowerSelector;
import barontrozo.PredictFireablePositions;
import barontrozo.PredictorHistory;
import barontrozo.StatusBuilder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class BaronTrozo
extends AdvancedRobot {
    static ConfigurationValues conf_ = new ConfigurationValues();
    static String burrada_ = new String();
    static long bulletFired_ = 0L;
    static long bulletHits_ = 0L;
    double fieldWidth_;
    double fieldHeight_;
    double minLimit_;
    double maxYLimit_;
    double maxXLimit_;
    Point2D.Double myPosition_;
    Point2D.Double myPrevPosition_;
    double myHeading_;
    double myVelocity_;
    double myPrevHeading_;
    double myPrevVelocity_;
    double myRadarHeading_;
    Point2D.Double enemyPosition_;
    Point2D.Double enemyPrevPosition_;
    double enemyEnergy_;
    double enemyHeading_;
    double enemyVelocity_;
    double enemyGlobalHeading_;
    CirclePatrol circlePatrol_;
    GotoManoeubre gotoManoeubre_;
    Point2D.Double estimatePoint_;
    boolean found_;
    PredictFireablePositions enemyPredictions_;
    PredictFireablePositions maxEnemyPredictions_;
    PredictFireablePositions myPredictions_;
    PredictFireablePositions avoidancePredictions_;
    List<BulletFollower> myBulletsFired_;
    List<BulletFollower> myVirtualBulletsFired_;
    List<BulletFollower> enemyBulletsFired_;
    List<BulletFollower> enemyVirtualBulletsFired_;
    static PredictorHistory myFiredPredictorHistory_ = new PredictorHistory();
    static PredictorHistory enemyFiredPredictorHistory_ = new PredictorHistory();
    ChooseStrategicPosition strategicposition_;
    Point2D.Double strategicPoint_;
    Point2D.Double centerPoint_;
    boolean avoidClockwiseOnrunAway_;
    boolean avoidCounterClockwiseOnrunAway_;
    double angleTarget_;
    double firePower_;
    double angleChoose_;
    long turn_;
    PowerSelector powerSelector_;
    boolean endedRound_;

    public void run() {
        conf_.Init(this.getDataFile("conf.txt"));
        this.firePower_ = 3.0;
        this.angleChoose_ = -1.0;
        this.fieldWidth_ = this.getBattleFieldWidth();
        this.fieldHeight_ = this.getBattleFieldHeight();
        this.minLimit_ = (this.getHeight() < this.getWidth() ? this.getHeight() : this.getWidth()) / 2.0;
        this.maxXLimit_ = this.fieldWidth_ - this.minLimit_;
        this.maxYLimit_ = this.fieldHeight_ - this.minLimit_;
        this.found_ = false;
        this.avoidClockwiseOnrunAway_ = false;
        this.avoidCounterClockwiseOnrunAway_ = false;
        myFiredPredictorHistory_.SetLimit(this.fieldWidth_, this.fieldHeight_, this.minLimit_ * 0.8);
        enemyFiredPredictorHistory_.SetLimit(this.fieldWidth_, this.fieldHeight_, this.minLimit_);
        StatusBuilder.SetDimesions(this.fieldWidth_, this.fieldHeight_);
        this.strategicposition_ = new ChooseStrategicPosition(this.fieldWidth_, this.fieldHeight_, this.minLimit_, BaronTrozo.conf_.distanceToKeep_);
        this.strategicPoint_ = new Point2D.Double(this.fieldWidth_ / 2.0, this.fieldHeight_ / 2.0);
        this.centerPoint_ = new Point2D.Double(this.fieldWidth_ / 2.0, this.fieldHeight_ / 2.0);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.myPosition_ = new Point2D.Double(0.0, 0.0);
        this.enemyPosition_ = new Point2D.Double(0.0, 0.0);
        this.estimatePoint_ = new Point2D.Double(0.0, 0.0);
        this.enemyPredictions_ = new PredictFireablePositions(this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.maxEnemyPredictions_ = new PredictFireablePositions(this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.myPredictions_ = new PredictFireablePositions(this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.avoidancePredictions_ = new PredictFireablePositions(this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.myPrevPosition_ = new Point2D.Double(0.0, 0.0);
        this.enemyPrevPosition_ = new Point2D.Double(0.0, 0.0);
        this.enemyEnergy_ = 0.0;
        this.myBulletsFired_ = new ArrayList<BulletFollower>();
        this.enemyBulletsFired_ = new ArrayList<BulletFollower>();
        this.myVirtualBulletsFired_ = new ArrayList<BulletFollower>();
        this.enemyVirtualBulletsFired_ = new ArrayList<BulletFollower>();
        double rad = this.fieldWidth_;
        if (rad > this.fieldHeight_) {
            rad = this.fieldHeight_;
        }
        this.circlePatrol_ = new CirclePatrol(this.centerPoint_, rad *= 0.4, true, this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.gotoManoeubre_ = new GotoManoeubre(this.minLimit_, this.maxXLimit_, this.maxYLimit_);
        this.powerSelector_ = new PowerSelector(this.getGunCoolingRate());
        this.endedRound_ = false;
        while (true) {
            double[] status;
            double val;
            BulletFollower follower;
            if (this.endedRound_ || this.getEnergy() < 0.1) {
                this.execute();
                continue;
            }
            this.turn_ = this.getTime();
            this.myPosition_.setLocation(this.getX(), this.getY());
            this.myVelocity_ = this.getVelocity();
            this.myHeading_ = this.getHeadingRadians();
            this.myRadarHeading_ = this.getRadarHeadingRadians();
            if (!this.enemyBulletsFired_.isEmpty()) {
                BulletFollower follower2 = this.enemyBulletsFired_.get(0);
                this.avoidancePredictions_.CalculatePosiblePositionsMantainDistance(this.myPosition_, this.myVelocity_, this.myHeading_, follower2.bulletPower_, follower2.firePos_, this.enemyPosition_, this.strategicposition_.desiredLen_, this.turn_ - follower2.turnInitial_, true, false);
                this.strategicposition_.CalculateStrategicPoint(this.enemyPosition_, this.myPosition_, this.strategicPoint_);
                this.avoidancePredictions_.CalculatePosiblePositions(this.myPosition_, this.myVelocity_, this.myHeading_, follower2.bulletPower_, follower2.firePos_, follower2.firePos_, this.turn_ - follower2.turnInitial_, true, true);
                Point2D.Double pointSave = this.enemyBulletsFired_.size() > 1 ? enemyFiredPredictorHistory_.ChooseSavePlace(this.avoidancePredictions_.posiblePositions_, this.avoidancePredictions_.positionsTurns_, follower2, this.enemyBulletsFired_.get(1), this.strategicPoint_, this.turn_, this.strategicposition_.desiredLen_) : enemyFiredPredictorHistory_.ChooseSavePlace(this.avoidancePredictions_.posiblePositions_, this.avoidancePredictions_.positionsTurns_, follower2, null, this.strategicPoint_, this.turn_, this.strategicposition_.desiredLen_);
                this.gotoManoeubre_.SetObjetive(pointSave, (int)BaronTrozo.enemyFiredPredictorHistory_.turnsToReach_);
                this.gotoManoeubre_.SetTankStatus(this.myPosition_, this.myHeading_, this.myVelocity_);
                if (this.enemyBulletsFired_.size() > 1) {
                    this.gotoManoeubre_.IfPosiblePerpendicularTo(this.enemyBulletsFired_.get((int)1).firePos_);
                } else {
                    this.gotoManoeubre_.IfPosiblePerpendicularTo(this.enemyPosition_);
                }
                this.gotoManoeubre_.CalculateMovement();
                this.setAhead(this.gotoManoeubre_.orderAhead_);
                this.setTurnRightRadians(this.gotoManoeubre_.orderHeading_);
            } else if (this.found_) {
                this.strategicposition_.CalculateStrategicPoint(this.enemyPosition_, this.myPosition_, this.strategicPoint_);
                this.gotoManoeubre_.SetObjetive(this.strategicPoint_, Integer.MAX_VALUE);
                this.gotoManoeubre_.SetTankStatus(this.myPosition_, this.myHeading_, this.myVelocity_);
                this.gotoManoeubre_.IfPosiblePerpendicularTo(this.enemyPosition_);
                this.gotoManoeubre_.CalculateMovement();
                this.setAhead(this.gotoManoeubre_.orderAhead_);
                this.setTurnRightRadians(this.gotoManoeubre_.orderHeading_);
            } else {
                this.circlePatrol_.AnulateAngularDestiny();
                this.circlePatrol_.SetTankStatus(this.myPosition_, this.myHeading_, this.myVelocity_);
                this.circlePatrol_.CalculateMovement();
                this.avoidClockwiseOnrunAway_ = false;
                this.avoidCounterClockwiseOnrunAway_ = false;
                if (this.circlePatrol_.IsGoingToHitAWall()) {
                    if (this.circlePatrol_.clockwise_) {
                        this.avoidClockwiseOnrunAway_ = true;
                    } else {
                        this.avoidCounterClockwiseOnrunAway_ = true;
                    }
                    this.circlePatrol_.SetClockwise(!this.circlePatrol_.clockwise_);
                }
                this.setAhead(this.circlePatrol_.orderAhead_);
                this.setTurnRightRadians(this.circlePatrol_.orderHeading_);
            }
            Iterator<BulletFollower> iterator = this.myBulletsFired_.iterator();
            long turn = this.getTime();
            while (iterator.hasNext()) {
                follower = iterator.next();
                if (follower.IsValid(this.enemyPosition_, turn)) continue;
                val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, this.enemyPosition_);
                status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
                myFiredPredictorHistory_.AddResult(val, status);
                iterator.remove();
            }
            iterator = this.enemyBulletsFired_.iterator();
            while (iterator.hasNext()) {
                follower = iterator.next();
                if (follower.IsValid(this.myPosition_, turn)) continue;
                val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, this.myPosition_);
                status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
                enemyFiredPredictorHistory_.AddMoveAvoidResult(val, status);
                this.powerSelector_.IncrementEnemyStats(follower.bulletPower_, false);
                iterator.remove();
            }
            iterator = this.myVirtualBulletsFired_.iterator();
            while (iterator.hasNext()) {
                follower = iterator.next();
                if (follower.IsValid(this.enemyPosition_, turn)) continue;
                val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, this.enemyPosition_);
                status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
                myFiredPredictorHistory_.AddVirtualResult(val, status);
                iterator.remove();
            }
            iterator = this.enemyVirtualBulletsFired_.iterator();
            while (iterator.hasNext()) {
                follower = iterator.next();
                if (follower.IsValid(this.myPosition_, turn)) continue;
                val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, this.myPosition_);
                status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
                enemyFiredPredictorHistory_.AddVirtualResult(val, status);
                iterator.remove();
            }
            if (this.getEnergy() >= 0.1 && this.found_ && this.enemyPredictions_.distance_ > 0.0) {
                double angleToPoint;
                double angGun = this.getGunHeadingRadians();
                double ang = Math.atan2(this.myPosition_.getX() - this.enemyPosition_.getX(), this.myPosition_.getY() - this.enemyPosition_.getY());
                ang = Utils.normalRelativeAngle((double)(this.enemyHeading_ - ang));
                BulletFollower nWB = new BulletFollower(this.myPosition_, this.enemyPredictions_.angleBegin_, this.enemyPredictions_.angleArc_, this.enemyPredictions_.distance_, this.firePower_, this.minLimit_, turn, angGun, this.enemyPosition_, this.enemyVelocity_, ang);
                if (this.getGunHeat() == 0.0 && this.angleChoose_ > -1.0 && Math.abs(angGun - this.angleChoose_) < 0.001) {
                    for (BulletFollower follower3 : this.enemyBulletsFired_) {
                        follower3.FoundBulletShadows(nWB);
                    }
                    this.myBulletsFired_.add(nWB);
                    this.setFire(this.firePower_);
                    this.angleChoose_ = -1.0;
                } else {
                    this.myVirtualBulletsFired_.add(nWB);
                }
                int turnsToFire = (int)Math.round(Math.ceil(this.getGunHeat() / this.getGunCoolingRate()));
                if (turnsToFire <= (int)Math.round(Math.ceil(this.enemyPredictions_.angleArc_ / 2.0 / 20.0))) {
                    BulletFollower auxFollower = new BulletFollower(this.myPosition_, this.enemyPredictions_.angleBegin_, this.enemyPredictions_.angleArc_, this.enemyPredictions_.distance_, this.firePower_, 0.0, 0L, 0.0, this.enemyPosition_, this.enemyVelocity_, ang);
                    double[] status2 = StatusBuilder.GetStatusArrayFromBulletFollower(auxFollower);
                    if (this.angleChoose_ < 0.0) {
                        this.angleChoose_ = myFiredPredictorHistory_.ChooseAngleToFire(auxFollower, status2);
                    } else {
                        double otherAngle = myFiredPredictorHistory_.ChooseAngleToFire(auxFollower, status2);
                        if (Math.round(Math.ceil(Math.abs(otherAngle - angGun) / 20.0)) <= (long)turnsToFire) {
                            this.angleChoose_ = otherAngle;
                        }
                    }
                    angleToPoint = this.angleChoose_;
                } else {
                    angleToPoint = Utils.normalAbsoluteAngle((double)(this.enemyPredictions_.angleBegin_ + this.enemyPredictions_.angleArc_ / 2.0));
                }
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angleToPoint - angGun)));
            }
            if (!this.found_) {
                this.setTurnRadarRightRadians(0.7853981633974483);
            } else {
                double turnRadar;
                this.setTurnRadarRightRadians(turnRadar += (turnRadar = Utils.normalRelativeAngle((double)(this.enemyGlobalHeading_ - this.myRadarHeading_))) > 0.0 ? 0.39269908169872414 : -0.39269908169872414);
                this.found_ = false;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double myEnergy = this.getEnergy();
        if (myEnergy < 0.1) {
            return;
        }
        this.found_ = true;
        this.myPosition_.setLocation(this.getX(), this.getY());
        this.enemyGlobalHeading_ = this.getHeadingRadians() + e.getBearingRadians();
        this.enemyPosition_.setLocation(this.myPosition_.getX() + Math.sin(this.enemyGlobalHeading_) * e.getDistance(), this.myPosition_.getY() + Math.cos(this.enemyGlobalHeading_) * e.getDistance());
        this.enemyHeading_ = e.getHeadingRadians();
        this.enemyVelocity_ = e.getVelocity();
        double ener = e.getEnergy();
        this.firePower_ = this.powerSelector_.GetBestPower();
        double maxPower = this.powerSelector_.GetMaxUseful(ener, myEnergy);
        if (maxPower <= this.firePower_) {
            this.firePower_ = maxPower;
        }
        this.enemyPredictions_.CalculatePosiblePositions(this.enemyPosition_, e.getVelocity(), this.enemyHeading_, this.firePower_, this.myPosition_, this.myPosition_, 0L, true, false);
        if (maxPower > this.firePower_) {
            this.maxEnemyPredictions_.CalculatePosiblePositions(this.enemyPosition_, e.getVelocity(), this.enemyHeading_, maxPower, this.myPosition_, this.myPosition_, 0L, false, false);
            double dist = this.myPosition_.distance(this.enemyPosition_) * this.maxEnemyPredictions_.angleArc_;
            if (dist <= this.minLimit_ * 3.0) {
                this.firePower_ = maxPower;
                this.enemyPredictions_.CalculatePosiblePositions(this.enemyPosition_, e.getVelocity(), this.enemyHeading_, this.firePower_, this.myPosition_, this.myPosition_, 0L, true, false);
            }
        }
        if (ener < this.enemyEnergy_) {
            ener = this.enemyEnergy_ - ener;
            double ang = Math.atan2(this.enemyPrevPosition_.getX() - this.myPrevPosition_.getX(), this.enemyPrevPosition_.getY() - this.myPrevPosition_.getY());
            ang = Utils.normalRelativeAngle((double)(this.myPrevHeading_ - ang));
            if (ener >= 0.1 && ener <= 3.0) {
                this.myPredictions_.CalculatePosiblePositions(this.myPrevPosition_, this.myPrevVelocity_, this.myPrevHeading_, ener, this.enemyPrevPosition_, this.enemyPrevPosition_, 0L, false, false);
                BulletFollower nBW = new BulletFollower(this.enemyPrevPosition_, this.myPredictions_.angleBegin_, this.myPredictions_.angleArc_, this.myPredictions_.distance_, ener, -this.minLimit_, this.getTime() - 1L, 0.0, this.myPrevPosition_, this.myPrevVelocity_, ang);
                for (BulletFollower follower : this.myBulletsFired_) {
                    nBW.FoundBulletShadows(follower);
                }
                this.enemyBulletsFired_.add(nBW);
            } else {
                double pow = this.powerSelector_.GetEnemyMostUsedPower();
                this.myPredictions_.CalculatePosiblePositions(this.myPrevPosition_, this.myPrevVelocity_, this.myPrevHeading_, pow, this.enemyPrevPosition_, this.enemyPrevPosition_, 0L, false, false);
                BulletFollower nBW = new BulletFollower(this.enemyPrevPosition_, this.myPredictions_.angleBegin_, this.myPredictions_.angleArc_, this.myPredictions_.distance_, ener, -this.minLimit_, this.getTime() - 1L, 0.0, this.myPrevPosition_, this.myPrevVelocity_, ang);
                this.enemyVirtualBulletsFired_.add(nBW);
            }
        }
        this.enemyEnergy_ = e.getEnergy();
        this.myPrevPosition_.setLocation(this.myPosition_);
        this.myPrevVelocity_ = this.getVelocity();
        this.myPrevHeading_ = this.getHeadingRadians();
        this.enemyPrevPosition_.setLocation(this.enemyPosition_);
    }

    public void onHitWall(HitWallEvent e) {
        System.out.printf("Me comi la pared!!!\n", new Object[0]);
        this.avoidClockwiseOnrunAway_ = false;
        this.avoidCounterClockwiseOnrunAway_ = false;
        if (this.circlePatrol_.clockwise_) {
            this.avoidClockwiseOnrunAway_ = true;
        } else {
            this.avoidCounterClockwiseOnrunAway_ = true;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        double latDist;
        double rad;
        double distBullet;
        double dist;
        BulletFollower follower;
        double myEnergy = this.getEnergy();
        if (myEnergy < 0.1) {
            return;
        }
        double bx = event.getHitBullet().getX();
        double by = event.getHitBullet().getY();
        double radBullet = event.getHitBullet().getHeadingRadians();
        Iterator<BulletFollower> iterator = this.enemyBulletsFired_.iterator();
        while (iterator.hasNext()) {
            follower = iterator.next();
            dist = follower.firePos_.distance(bx, by);
            distBullet = follower.bulletSpeed_ * (double)(this.getTime() - follower.turnInitial_);
            rad = Utils.normalAbsoluteAngle((double)Math.atan2(bx - follower.firePos_.getX(), by - follower.firePos_.getY()));
            latDist = Math.abs(rad - radBullet) * distBullet;
            if (!(Math.abs(dist - distBullet) <= this.minLimit_ * 2.0) || !(latDist <= this.minLimit_ * 2.0)) continue;
            Point2D.Double auxiliarPoint = new Point2D.Double(bx, by);
            double val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, auxiliarPoint);
            double[] status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
            enemyFiredPredictorHistory_.AddResult(val, status);
            this.powerSelector_.IncrementEnemyStats(follower.bulletPower_, false);
            iterator.remove();
        }
        iterator = this.myBulletsFired_.iterator();
        bx = event.getBullet().getX();
        by = event.getBullet().getY();
        while (iterator.hasNext()) {
            follower = iterator.next();
            dist = follower.firePos_.distance(bx, by);
            distBullet = follower.bulletSpeed_ * (double)(this.getTime() - follower.turnInitial_);
            rad = Utils.normalAbsoluteAngle((double)Math.atan2(bx - follower.firePos_.getX(), by - follower.firePos_.getY()));
            latDist = Math.abs(rad - radBullet) * distBullet;
            if (!(Math.abs(dist - distBullet) <= this.minLimit_ * 2.0) || !(latDist <= this.minLimit_ * 2.0)) continue;
            iterator.remove();
        }
        this.powerSelector_.IncrementStats(event.getBullet().getPower(), false);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        double myEnergy = this.getEnergy();
        if (myEnergy < 0.1) {
            return;
        }
        this.myPosition_.setLocation(this.getX(), this.getY());
        this.enemyEnergy_ += Rules.getBulletHitBonus((double)event.getPower());
        Iterator<BulletFollower> iterator = this.enemyBulletsFired_.iterator();
        while (iterator.hasNext()) {
            BulletFollower follower = iterator.next();
            double dist = follower.firePos_.distance(this.myPosition_);
            double distBullet = follower.bulletSpeed_ * (double)(this.getTime() - follower.turnInitial_);
            double rad = Utils.normalAbsoluteAngle((double)Math.atan2(this.myPosition_.getX() - follower.firePos_.getX(), this.myPosition_.getY() - follower.firePos_.getY()));
            double radBullet = event.getHeadingRadians();
            double latDist = Math.abs(rad - radBullet) * distBullet;
            if (!(Math.abs(dist - distBullet) <= this.minLimit_ * 2.0) || !(latDist <= this.minLimit_ * 2.0)) continue;
            double val = StatusBuilder.GetValueOfPositionOnBulletFollower(follower, this.myPosition_);
            double[] status = StatusBuilder.GetStatusArrayFromBulletFollower(follower);
            enemyFiredPredictorHistory_.AddResult(val, status);
            this.powerSelector_.IncrementEnemyStats(follower.bulletPower_, true);
            iterator.remove();
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.enemyEnergy_ -= Rules.getBulletDamage((double)event.getBullet().getPower());
        this.powerSelector_.IncrementStats(event.getBullet().getPower(), true);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.powerSelector_.IncrementStats(event.getBullet().getPower(), false);
    }

    public void onDeath(DeathEvent event) {
        System.out.println("Me mataron--\n");
        this.endedRound_ = true;
    }

    public void onWin(WinEvent event) {
        System.out.println("Gane--\n");
        this.endedRound_ = true;
    }

    public void onBattleEnded(BattleEndedEvent event) {
    }

    public void onRoundEnded(RoundEndedEvent event) {
        System.out.println("Me ------------------\n");
        this.powerSelector_.PrintFactor();
    }

    public void onPaint(Graphics2D g) {
        for (BulletFollower follower : this.enemyBulletsFired_) {
            follower.onPaint(g, Color.RED, (int)this.getTime());
        }
        if (this.found_ && this.enemyPredictions_.distance_ > 0.0) {
            enemyFiredPredictorHistory_.onPaint(g);
        }
        g.setColor(Color.BLUE);
        g.drawRect((int)(this.strategicPoint_.getX() - this.minLimit_), (int)(this.strategicPoint_.getY() - this.minLimit_), (int)(2.0 * this.minLimit_), (int)(2.0 * this.minLimit_));
        g.setColor(Color.GREEN);
        g.draw(new Arc2D.Double(this.myPosition_.getX() - this.enemyPredictions_.distance_, this.myPosition_.getY() - this.enemyPredictions_.distance_, this.enemyPredictions_.distance_ * 2.0, this.enemyPredictions_.distance_ * 2.0, Math.toDegrees(this.enemyPredictions_.angleBegin_) - 90.0, Math.toDegrees(this.enemyPredictions_.angleArc_), 2));
        int size = this.enemyPredictions_.posiblePositions_.size();
        int i = 0;
        while (i < size) {
            g.drawRect((int)(this.enemyPredictions_.posiblePositions_.get(i).getX() - 1.0), (int)(this.enemyPredictions_.posiblePositions_.get(i).getY() - 1.0), 2, 2);
            ++i;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        System.out.println("***************SKIPED TURN*************************\n");
    }
}

