/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils.geom;

import java.awt.geom.Point2D;
import voidious.utils.DiaUtils;
import voidious.utils.geom.LineSeg;

public class Circle {
    public double h;
    public double k;
    public double r;

    public Circle(double x, double y, double r) {
        this.h = x;
        this.k = y;
        this.r = r;
    }

    public Circle(Point2D.Double p, double r) {
        this(p.x, p.y, r);
    }

    public Point2D.Double[] intersectsLineSeg(LineSeg seg) {
        return this.intersectsLineSeg(seg, false);
    }

    public Point2D.Double[] intersectsLineSeg(LineSeg seg, boolean inverted) {
        double a = seg.m * seg.m + 1.0;
        double b = 2.0 * (seg.b * seg.m - this.k * seg.m - this.h);
        double c = this.h * this.h + this.k * this.k + seg.b * seg.b - 2.0 * seg.b * this.k - this.r * this.r;
        Point2D.Double[] solutions = new Point2D.Double[]{null, null};
        int i = 0;
        if (a == Double.POSITIVE_INFINITY) {
            LineSeg invSeg = new LineSeg(seg.y1, seg.x1, seg.y2, seg.x2);
            Circle invCircle = new Circle(this.k, this.h, this.r);
            Point2D.Double[] invSolutions = invCircle.intersectsLineSeg(invSeg, true);
            for (int x = 0; x < invSolutions.length; ++x) {
                if (invSolutions[x] == null) continue;
                double t = invSolutions[x].x;
                invSolutions[x].x = invSolutions[x].y;
                invSolutions[x].y = t;
            }
            return invSolutions;
        }
        double discrim = b * b - 4.0 * a * c;
        if (discrim < 0.0) {
            return solutions;
        }
        double sqrtDiscrim = Math.sqrt(discrim);
        double x1 = (-b + sqrtDiscrim) / (2.0 * a);
        double y1 = seg.m * x1 + seg.b;
        if (x1 > seg.xMin && x1 < seg.xMax) {
            solutions[i++] = new Point2D.Double(x1, y1);
        }
        if (sqrtDiscrim > 0.0) {
            double x2 = (-b - sqrtDiscrim) / (2.0 * a);
            double y2 = seg.m * x2 + seg.b;
            if (x2 > seg.xMin && x2 < seg.xMax) {
                solutions[i++] = new Point2D.Double(x2, y2);
            }
        }
        return solutions;
    }

    public boolean contains(Point2D.Double p) {
        double z = DiaUtils.square(p.x - this.h) + DiaUtils.square(p.y - this.k);
        return z < this.r * this.r;
    }
}

