/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.bullets.firedBullet;
import eem.gun.cachedTarget;
import eem.gun.gunStats;
import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.target.InfoBot;
import eem.target.target;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import robocode.Bullet;

public class baseGun {
    protected EvBot myBot;
    protected InfoBot firingBot;
    protected String gunName = "base";
    protected boolean gunFired = false;
    protected boolean gunHasTargetPoint = false;
    protected Random gun_rand = new Random();
    public Color gunColor = Color.black;
    protected Point2D.Double targetFuturePosition;
    protected int numTicsInColdState = 0;
    protected double firePower;
    private static int bulletHitCount = 0;
    private static int bulletMissedCount = 0;
    private static int bulletFiredCount = 0;
    private static LinkedList<cachedTarget> cachedTargets = new LinkedList();
    public static HashMap<String, gunStats> mapOfGunStats = new HashMap();
    private String strSep = "__zzz__";

    private String buildMapKey(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = "";
        string = bl ? "virtual" : "real";
        String string2 = this.gunName + this.strSep + infoBot2.getName() + this.strSep + infoBot.getName() + this.strSep + string;
        return string2;
    }

    public int getNumTicsInColdState() {
        return this.numTicsInColdState;
    }

    public int getBulletVirtFiredCount(InfoBot infoBot, InfoBot infoBot2) {
        boolean bl = true;
        return this.getBulletFiredCount(infoBot, infoBot2, bl);
    }

    public int getBulletVirtFiredCount(InfoBot infoBot) {
        return this.getBulletVirtFiredCount(infoBot, EvBot._tracker);
    }

    public int getBulletVirtFiredCount() {
        return this.getBulletVirtFiredCount(this.myBot._trgt, EvBot._tracker);
    }

    public int getBulletFiredCount(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = this.buildMapKey(infoBot, infoBot2, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            return 0;
        }
        return gunStats2.getBulletFiredCount();
    }

    public int getBulletRealFiredCount(InfoBot infoBot) {
        boolean bl = false;
        return this.getBulletFiredCount(infoBot, EvBot._tracker, bl);
    }

    public int getBulletHitCount(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = this.buildMapKey(infoBot, infoBot2, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            return 0;
        }
        return gunStats2.getBulletHitCount();
    }

    public int getBulletRealHitCount(InfoBot infoBot) {
        boolean bl = false;
        return this.getBulletHitCount(infoBot, EvBot._tracker, bl);
    }

    public int getBulletVirtHitCount(InfoBot infoBot, InfoBot infoBot2) {
        boolean bl = true;
        return this.getBulletHitCount(infoBot, EvBot._tracker, bl);
    }

    public int getBulletVirtHitCount(InfoBot infoBot) {
        return this.getBulletVirtHitCount(infoBot, EvBot._tracker);
    }

    public int getBulletVirtHitCount() {
        return this.getBulletVirtHitCount(this.myBot._trgt, EvBot._tracker);
    }

    public double getGunVirtHitRate(InfoBot infoBot, InfoBot infoBot2) {
        boolean bl = true;
        String string = this.buildMapKey(infoBot, infoBot2, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        return gunStats2.getGunHitRate();
    }

    public double getGunVirtHitRate(InfoBot infoBot) {
        return this.getGunVirtHitRate(infoBot, EvBot._tracker);
    }

    public double getGunVirtHitRate() {
        return this.getGunVirtHitRate(this.myBot._trgt, EvBot._tracker);
    }

    public double getGunVirtPerformance(InfoBot infoBot, InfoBot infoBot2) {
        boolean bl = true;
        String string = this.buildMapKey(infoBot, infoBot2, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        return gunStats2.getGunPerformance();
    }

    public double getGunVirtPerformance(InfoBot infoBot) {
        return this.getGunVirtPerformance(infoBot, EvBot._tracker);
    }

    public double getGunVirtPerformance() {
        return this.getGunVirtPerformance(this.myBot._trgt, EvBot._tracker);
    }

    protected void updBulletFiredCount(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = this.buildMapKey(infoBot2, infoBot, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        gunStats2.updBulletFiredCount();
    }

    public void updBulletFiredCount(InfoBot infoBot, InfoBot infoBot2, firedBullet firedBullet2) {
        if (firedBullet2.isItVirtual()) {
            this.updBulletFiredCount(infoBot, infoBot2, true);
        } else {
            this.updBulletFiredCount(infoBot, infoBot2, false);
            this.updBulletFiredCount(infoBot, infoBot2, true);
        }
    }

    protected void updBulletHitCount(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = this.buildMapKey(infoBot2, infoBot, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        gunStats2.updBulletHitCount();
    }

    public void updBulletHitCount(InfoBot infoBot, InfoBot infoBot2, firedBullet firedBullet2) {
        if (firedBullet2.isItVirtual()) {
            this.updBulletHitCount(infoBot, infoBot2, true);
        } else {
            this.updBulletHitCount(infoBot, infoBot2, true);
            this.updBulletHitCount(infoBot, infoBot2, false);
        }
    }

    public String gunStatsHeader(InfoBot infoBot, InfoBot infoBot2) {
        String string = this.buildMapKey(infoBot2, infoBot, true);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        String string2 = "";
        string2 = string2 + String.format("%12s", "gun name");
        string2 = string2 + gunStats2.header("Virt");
        string2 = string2 + gunStats2.header("Real");
        string2 = string2 + " | ";
        string2 = string2 + String.format("%20s", "fire rate");
        return string2;
    }

    public String gunStatsFormat(InfoBot infoBot, InfoBot infoBot2, boolean bl) {
        String string = this.buildMapKey(infoBot2, infoBot, bl);
        gunStats gunStats2 = mapOfGunStats.get(string);
        if (gunStats2 == null) {
            gunStats2 = new gunStats();
            mapOfGunStats.put(string, gunStats2);
        }
        String string2 = "";
        string2 = string2 + gunStats2.format();
        return string2;
    }

    public String gunStatsFormat(InfoBot infoBot, InfoBot infoBot2) {
        String string = "";
        string = string + String.format("%12s", this.getName());
        string = string + this.gunStatsFormat(infoBot, infoBot2, true);
        string = string + this.gunStatsFormat(infoBot, infoBot2, false);
        string = string + " | ";
        string = string + logger.hitRateFormat(this.getBulletFiredCount(infoBot2, infoBot, false), this.getBulletFiredCount(infoBot2, infoBot, true));
        return string;
    }

    public baseGun() {
    }

    public baseGun(EvBot evBot) {
        this();
        this.myBot = evBot;
        this.firingBot = EvBot._tracker;
        this.calcGunSettings();
    }

    public void initTic() {
        if (this.myBot.getGunHeat() == 0.0) {
            ++this.numTicsInColdState;
        }
    }

    public boolean doesItNeedTrackedTarget() {
        return physics.gunCoolingTime(this.myBot.getGunHeat()) <= 3;
    }

    public void manage() {
        if (this.myBot._trgt.haveTarget) {
            this.calcGunSettings();
            logger.noise("Predicted target X coordinate = " + this.getTargetFuturePosition().x);
            logger.noise("Predicted target Y coordinate = " + this.getTargetFuturePosition().y);
            double d = math.angle2pt(this.myBot.myCoord, this.getTargetFuturePosition());
            double d2 = this.myBot.getGunHeading();
            double d3 = math.shortest_arc(d - d2);
            logger.noise("Pointing gun to enemy by rotating by angle = " + d3);
            this.myBot.setTurnGunRight(d3);
            double d4 = d3 * Math.PI / 180.0 * this.myBot._trgt.getLastDistance(this.myBot.myCoord);
            logger.noise("Gun heat = " + this.myBot.getGunHeat());
            if (this.myBot.getGunHeat() == 0.0) {
                if (Math.abs(d4) < Math.min(this.myBot.getHeight(), this.myBot.getWidth()) / 5.0) {
                    logger.noise("Firing the gun with power = " + this.firePower);
                    this.fireGun();
                    return;
                }
                int n = 1;
                if (this.numTicsInColdState > n) {
                    logger.dbg("The gun is not firing for " + this.numTicsInColdState + " tics, we permit to not fire only for " + n + ". Hell, with targeting, fire anyway");
                    this.fireGun();
                    return;
                }
            }
        }
    }

    public void fireGun() {
        if (this.firePower != 0.0) {
            logger.noise("Gun fire power = " + this.firePower);
            Bullet bullet = this.myBot.setFireBullet(this.firePower);
            if (bullet == null) {
                logger.error("Gun did not fire  = " + bullet);
                return;
            }
            logger.noise("fired bullet  = " + bullet);
            this.myBot._bmanager.add(new firedBullet(this.myBot, bullet, this));
            this.gunFired = true;
            this.resetTicsInColdState();
            this.gunHasTargetPoint = false;
        }
    }

    public void resetTicsInColdState() {
        this.numTicsInColdState = 0;
    }

    public String getName() {
        return this.gunName;
    }

    public boolean isGunFired() {
        return this.gunFired;
    }

    public Point2D.Double getTargetFuturePosition() {
        return (Point2D.Double)this.targetFuturePosition.clone();
    }

    private Point2D.Double addRandomOffsetToTargetFuturePosition(Point2D.Double double_, Point2D.Double double_2) {
        double d = math.angle2pt(double_, double_2);
        d = Math.toRadians(d);
        double d2 = double_.distance(double_2);
        double d3 = 0.05;
        double d4 = Math.atan2(d3 * (double)this.myBot.robotHalfSize, d2);
        double d5 = Math.random();
        double_2.x = double_.x + d2 * Math.sin(d += (double)math.signNoZero(d5 - 0.5) * d4);
        double_2.y = double_.y + d2 * Math.cos(d);
        return (Point2D.Double)double_2.clone();
    }

    public void setTargetFuturePosition(target target2) {
        this.targetFuturePosition = (Point2D.Double)this.calcTargetFuturePosition(EvBot._tracker, this.firePower, (InfoBot)target2).clone();
    }

    protected double firePoverVsDistance(double d) {
        logger.noise("Target distance = " + d);
        double d2 = -100.0;
        if (this.myBot.fightType().equals("melee")) {
            d2 = Math.min(500.0 / d, 3.0);
        }
        if (this.myBot.fightType().equals("meleeMidle")) {
            d2 = Math.min(500.0 / d, 3.0);
        }
        if (this.myBot.fightType().equals("meelee1on1")) {
            d2 = Math.min(500.0 / d, 3.0);
        }
        if (this.myBot.fightType().equals("1on1")) {
            d2 = Math.min(700.0 / d, 3.0);
        }
        if (d2 < 0.0) {
            d2 = Math.min(500.0 / d, 3.0);
        }
        d2 = Math.max(d2, 0.1);
        logger.noise("Fire power = " + d2);
        return d2;
    }

    protected Point2D.Double futureTargetWithinPhysicalLimitsBasedOnVelocity(Point2D.Double double_, Point2D.Double double_2) {
        double d;
        double d2;
        double d3 = this.myBot.robotHalfSize;
        Point2D.Double double_3 = (Point2D.Double)this.myBot.BattleField.clone();
        Point2D.Double double_4 = (Point2D.Double)double_.clone();
        double_3.x -= 2.0 * d3;
        double_3.y -= 2.0 * d3;
        double_4.x -= d3;
        double_4.y -= d3;
        if (!math.isItOutOfBorders(double_4, double_3)) {
            return double_;
        }
        if (double_2.x == 0.0) {
            double_2.x = 1.0E-6;
        }
        if ((d2 = double_4.x) < -(d = 2.0)) {
            double_4.x -= d2;
            double_4.y -= d2 / double_2.x * double_2.y;
        }
        if ((d2 = double_4.x - double_3.x) > d) {
            double_4.x -= d2;
            double_4.y -= d2 / double_2.x * double_2.y;
        }
        if (double_2.y == 0.0) {
            double_2.y = 1.0E-6;
        }
        if ((d2 = double_4.y) < -d) {
            double_4.y -= d2;
            double_4.x -= d2 / double_2.y * double_2.x;
        }
        if ((d2 = double_4.y - double_3.y) > d) {
            double_4.y -= d2;
            double_4.x -= d2 / double_2.y * double_2.x;
        }
        double_4.x += d3;
        double_4.y += d3;
        return double_4;
    }

    private Point2D.Double findSettingInCachedTargets(cachedTarget cachedTarget2) {
        if (cachedTargets.size() == 0) {
            return null;
        }
        long l = cachedTarget2.getTime();
        for (int i = cachedTargets.size() - 1; i >= 0; --i) {
            if (cachedTargets.get(i).getTime() < l) {
                return null;
            }
            if (!cachedTarget2.conditionEquals(cachedTargets.get(i))) continue;
            return cachedTargets.get(i).getTargetFuturePosition();
        }
        return null;
    }

    public Point2D.Double calcTargetFuturePosition(InfoBot infoBot, double d, InfoBot infoBot2) {
        Point2D.Double double_ = (Point2D.Double)infoBot.getPosition().clone();
        Point2D.Double double_2 = null;
        cachedTarget cachedTarget2 = new cachedTarget(this.myBot, this, infoBot, infoBot2);
        double_2 = this.findSettingInCachedTargets(cachedTarget2);
        if (double_2 != null) {
            return double_2;
        }
        double_2 = this.calcTargetFuturePosition(double_, d, infoBot2);
        double_2 = this.addRandomOffsetToTargetFuturePosition(double_, double_2);
        double_2 = math.putWithinBorders(double_2, this.myBot.BattleField);
        cachedTarget2.setTargetFuturePosition(double_2);
        cachedTargets.add(cachedTarget2);
        return double_2;
    }

    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot) {
        return infoBot.getPosition();
    }

    public void calcGunSettings() {
        if (this.myBot._trgt.haveTarget) {
            this.setFirePower();
            Point2D.Double double_ = this.calcTargetFuturePosition(EvBot._tracker, this.firePower, (InfoBot)this.myBot._trgt);
            this.targetFuturePosition = (Point2D.Double)double_.clone();
        }
    }

    public void setFirePower() {
        this.firePower = this.calcFirePower();
    }

    protected double calcFirePower() {
        double d = 0.0;
        if (this.myBot._trgt.haveTarget) {
            d = this.firePoverVsDistance(this.myBot._trgt.getLastDistance(this.myBot.myCoord));
            d = Math.max(d, physics.minimalAllowedBulletEnergy);
            d = Math.min(d, physics.minReqBulEnergyToKillTarget(this.myBot._trgt.getEnergy()));
            d = Math.min(d, this.myBot.getEnergy() - 1.0E-4);
            d = Math.max(d, physics.minimalAllowedBulletEnergy);
            if (this.myBot.getEnergy() <= d + 1.0E-4) {
                d = 0.0;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    public double getFirePower() {
        return this.firePower;
    }

    private void drawTargetFuturePosition(Graphics2D graphics2D) {
        if (null != this.targetFuturePosition) {
            graphics2D.setColor(this.gunColor);
            graphics.fillSquare(graphics2D, this.targetFuturePosition, 40.0);
        }
    }

    private void drawTargetLastPosition(Graphics2D graphics2D) {
        this.myBot._trgt.onPaint(graphics2D);
    }

    private void drawLineToTargetFuturePosition(Graphics2D graphics2D) {
        if (null != this.targetFuturePosition) {
            graphics2D.setColor(this.gunColor);
            graphics.drawLine(graphics2D, this.getTargetFuturePosition(), this.myBot.myCoord);
        }
    }

    private void drawLineToTarget(Graphics2D graphics2D) {
        graphics2D.setColor(this.gunColor);
        graphics2D.drawLine((int)this.myBot._trgt.getX(), (int)this.myBot._trgt.getY(), (int)this.myBot.myCoord.x, (int)this.myBot.myCoord.y);
    }

    public void onPaint(Graphics2D graphics2D) {
        if (this.myBot._trgt.haveTarget) {
            this.drawTargetFuturePosition(graphics2D);
            this.drawTargetLastPosition(graphics2D);
            this.drawLineToTarget(graphics2D);
            this.drawLineToTargetFuturePosition(graphics2D);
        }
    }
}

