/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.Pair;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.info.BotInfo;
import dsekercioglu.mega.rMove.info.EnemyTargetingInfo;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.info.battle.BattleInfo;
import dsekercioglu.mega.rMove.info.battle.BattleSummary;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.FlattenerFormula;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.NormalFormula;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.SimpleFormula;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.SimpleFormula2;
import dsekercioglu.mega.rMove.movetree.nodes.Node;
import dsekercioglu.mega.rMove.movetree.nodes.learn.ETP;
import dsekercioglu.mega.rMove.movetree.nodes.learn.MP;
import dsekercioglu.mega.rMove.movetree.nodes.modify.condition.ConditionalInNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.condition.ConditionalOutNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.condition.NoInNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.decay.KNNScanNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.optimize.CacheNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.optimize.CombineNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.weight.AreaNormNode;
import dsekercioglu.mega.rMove.movetree.nodes.modify.weight.WeightedNode;
import dsekercioglu.mega.rMove.sim.ShadowBullet;
import dsekercioglu.mega.rMove.sim.Wave;
import dsekercioglu.mega.rMove.ws.WaveSurfingGT;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RavenFlight {
    private final double SMOOTH_FACTOR = 0.16;
    private final BattleInfo BATTLE_INFO;
    private final BotInfo BOT_INFO;
    private final List<BattleSummary> PAST_SUMMARY = new ArrayList<BattleSummary>();
    private final List<EnemyTargetingInfo> PAST_ENEMY_TARGETING_INFO = new ArrayList<EnemyTargetingInfo>();
    private final List<Wave> WAVES = new ArrayList<Wave>();
    private final List<ShadowBullet> BULLETS = new ArrayList<ShadowBullet>();
    private final Node PREDICTOR;
    private final WaveSurfingGT WS_GT;

    public RavenFlight(AdvancedRobot robot) {
        this.BOT_INFO = new BotInfo(robot);
        this.BATTLE_INFO = new BattleInfo(robot);
        SimpleFormula simpleFormula = new SimpleFormula();
        SimpleFormula2 simpleFormula2 = new SimpleFormula2();
        NormalFormula normalFormula = new NormalFormula();
        FlattenerFormula flattenerFormula = new FlattenerFormula();
        ConditionalOutNode simple = new ConditionalOutNode(new AreaNormNode(new ETP(simpleFormula, 15, 1, 24.0), 0.16), 0.0, 0.09);
        ConditionalOutNode simple2 = new ConditionalOutNode(new AreaNormNode(new ETP(simpleFormula2, 15, 1, 24.0), 0.16), 0.0, 0.09);
        CacheNode normal = new CacheNode(new AreaNormNode(new ETP(normalFormula, 30, 2, 24.0), 0.16));
        NoInNode decay = new NoInNode(new ConditionalOutNode(new AreaNormNode(new KNNScanNode(2.2, normal), 0.16), 0.06, 1.0));
        ConditionalInNode flattener = new ConditionalInNode(new ConditionalOutNode(new AreaNormNode(new KNNScanNode(2.2, new MP(flattenerFormula, 30, 5, 24.0)), 0.16), 0.09, 1.0), 0.09, 1.0);
        AreaNormNode learn = new AreaNormNode(new CombineNode(31, new WeightedNode(new double[]{0.5, 0.5, 1.0, 1.0}, simple, simple2, normal, decay)), 0.16);
        this.PREDICTOR = new WeightedNode(new double[]{0.5, 0.5}, learn, flattener);
        this.WS_GT = new WaveSurfingGT(robot, 0.16);
    }

    public void run() {
        this.PAST_SUMMARY.clear();
        this.PAST_ENEMY_TARGETING_INFO.clear();
        this.WAVES.clear();
        this.BULLETS.clear();
        this.BATTLE_INFO.run();
        this.BOT_INFO.run();
        this.WS_GT.run();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.BATTLE_INFO.onScannedRobot(e);
        this.BOT_INFO.onScannedRobot(e);
        this.updateWaves();
        if (this.BATTLE_INFO.enemyFired()) {
            double firePower = this.BATTLE_INFO.getEnemyFirePower();
            int size = this.PAST_SUMMARY.size();
            BattleSummary battleSummary = this.PAST_SUMMARY.get(size - 2);
            WaveData waveData = new WaveData(battleSummary, firePower);
            EnemyTargetingInfo enemyTargetingInfo = this.PAST_ENEMY_TARGETING_INFO.get(size - 1);
            Wave w = new Wave(enemyTargetingInfo, waveData, battleSummary, 2);
            List<GuessFactor> predictions = this.PREDICTOR.getGuessFactors(new WaveData(battleSummary, firePower));
            w.setGuessFactors(predictions);
            this.WAVES.add(w);
            this.WS_GT.onWaveUpdate();
        }
        if (this.BOT_INFO.botFired()) {
            this.BULLETS.add(new ShadowBullet(this.BOT_INFO.getFireLocation(), this.BOT_INFO.getGunHeading(), Rules.getBulletSpeed((double)this.BOT_INFO.getFirePower())));
        }
        BattleSummary summary = this.BATTLE_INFO.getSummary();
        this.PAST_SUMMARY.add(summary);
        this.PAST_ENEMY_TARGETING_INFO.add(this.BATTLE_INFO.getEnemyTargetingInfo());
        this.WS_GT.surf(this.WAVES, this.BATTLE_INFO, summary);
    }

    private void updateWaves() {
        for (int i = 0; i < this.BULLETS.size(); ++i) {
            ShadowBullet b = this.BULLETS.get(i);
            boolean remove = b.update();
            if (!remove) continue;
            this.BULLETS.remove(i);
            --i;
        }
        Point2D.Double targetLocation = this.BATTLE_INFO.getBotLocation();
        for (int i = 0; i < this.WAVES.size(); ++i) {
            Wave wave = this.WAVES.get(i);
            if (wave.update(targetLocation)) {
                this.WAVES.remove(i);
                --i;
            }
            if (wave.botVisited()) {
                GuessFactor guessFactor = new GuessFactor(wave.getGuessFactor(this.BATTLE_INFO.getBotLocation().getX(), this.BATTLE_INFO.getBotLocation().getY()), 1.0, this.BATTLE_INFO.getEnemyHitNum());
                this.PREDICTOR.addData(wave.getWaveData(), guessFactor, false);
            }
            for (ShadowBullet b : this.BULLETS) {
                wave.addShadow(b.getLocation(), b.getVelocity(), b.getAbsBearing());
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.BATTLE_INFO.onHitByBullet(e);
        this.BOT_INFO.onHitByBullet(e);
        Bullet hitBullet = e.getBullet();
        Wave w = this.bulletDetectedRealWave(hitBullet.getX(), hitBullet.getY(), hitBullet.getVelocity());
        if (w != null) {
            this.logHit(w, w.getPreciseGuessFactor(hitBullet.getX(), hitBullet.getY()));
        } else {
            System.out.println("HitByBulletEvent: Wave couldn't be identified");
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bullet hitBullet = e.getHitBullet();
        Wave w = this.bulletDetectedRealWave(hitBullet.getX(), hitBullet.getY(), hitBullet.getVelocity());
        if (w != null) {
            this.logHit(w, w.getPreciseGuessFactor(hitBullet.getX(), hitBullet.getY()));
        } else {
            System.out.println("BulletHitBulletEvent: Wave couldn't be identified");
        }
        this.removeShadows(e.getBullet());
    }

    public void onBulletHit(BulletHitEvent e) {
        this.BATTLE_INFO.onBulletHit(e);
        this.BOT_INFO.onBulletHit(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.WS_GT.onWaveUpdate();
        this.BATTLE_INFO.onHitRobot(e);
        this.BOT_INFO.onHitRobot(e);
    }

    public void logHit(Wave w, double guessFactor) {
        GuessFactor hitGuessFactor = new GuessFactor(guessFactor, 1.0, this.BATTLE_INFO.getEnemyHitNum());
        WaveData data = w.getWaveData();
        this.PREDICTOR.addData(data, hitGuessFactor, true);
        this.updateWaveDanger(w);
    }

    public void updateWaveDanger(Wave w) {
        this.WS_GT.onWaveUpdate();
        for (Wave wave : this.WAVES) {
            wave.setGuessFactors(this.PREDICTOR.getGuessFactors(w.getWaveData()));
        }
    }

    public Wave bulletDetectedRealWave(double bulletX, double bulletY, double bulletVelocity) {
        for (int i = 0; i < this.WAVES.size(); ++i) {
            Wave wave = this.WAVES.get(i);
            Point2D.Double source = wave.getSource();
            if (!(Math.abs(source.distance(bulletX, bulletY) - wave.getDistanceTraveled()) < wave.getWaveVelocity() * 3.0) || !(Math.abs(wave.getWaveVelocity() - bulletVelocity) < 0.2)) continue;
            this.WAVES.remove(i);
            return wave;
        }
        return null;
    }

    public void removeShadows(Bullet bullet) {
        for (int i = 0; i < this.BULLETS.size(); ++i) {
            ShadowBullet sb = this.BULLETS.get(i);
            if (!(Math.abs(Utils.normalRelativeAngle((double)(sb.getAbsBearing() - bullet.getHeadingRadians()))) < 0.003)) continue;
            Point2D.Double double_ = new Point2D.Double(bullet.getX(), bullet.getY());
            if (!(sb.getLocation().distance(double_) < sb.getVelocity() + 1.0)) continue;
            this.BULLETS.remove(sb);
            break;
        }
    }

    public void onRoundEnded(RoundEndedEvent e) {
        System.out.println("Enemy weighted hit rate: " + (double)((int)(this.BATTLE_INFO.getEnemyWeightedHitRate() * 1000.0)) / 10.0 + "%");
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.drawRect((int)(this.BATTLE_INFO.getEnemyLocation().getX() - 18.0), (int)(this.BATTLE_INFO.getEnemyLocation().getY() - 18.0), 36, 36);
        int ARTIFICIAL_BINS = 153;
        int MID_BIN = 76;
        double BIN_WIDTH = 0.013071895424836602;
        for (Wave wave : this.WAVES) {
            Object p1;
            double angle;
            double guessFactor;
            int j;
            g.setStroke(new BasicStroke(2.0f));
            ArrayList<Line2D.Double> segments = new ArrayList<Line2D.Double>();
            ArrayList<Double> dangers = new ArrayList<Double>();
            for (j = (int)(76.0 - 76.0 * (wave.getMEACounterClowise() / wave.getMEA()) + 0.5); j < 76; ++j) {
                guessFactor = (double)(j - 76) * 1.0 / 76.0;
                angle = wave.getAbsoluteBearing() + wave.getMEA() * guessFactor;
                p1 = MoveUtils.project(wave.getSource(), angle, wave.getDistanceTraveled());
                Point2D.Double double_ = MoveUtils.project(wave.getSource(), angle, wave.getDistanceTraveled() - wave.getWaveVelocity());
                segments.add(new Line2D.Double((Point2D)p1, double_));
                dangers.add(wave.getDanger((guessFactor *= wave.getLateralDirection()) - 0.006535947712418301, guessFactor + 0.006535947712418301, 0.16));
            }
            for (j = 76; j < (int)(76.0 + 76.0 * (wave.getMEAClockwise() / wave.getMEA()) + 0.5); ++j) {
                guessFactor = (double)(j - 76) * 1.0 / 76.0;
                angle = wave.getAbsoluteBearing() + wave.getMEA() * guessFactor;
                p1 = MoveUtils.project(wave.getSource(), angle, wave.getDistanceTraveled());
                Point2D.Double double_ = MoveUtils.project(wave.getSource(), angle, wave.getDistanceTraveled() - wave.getWaveVelocity());
                segments.add(new Line2D.Double((Point2D)p1, double_));
                dangers.add(wave.getDanger((guessFactor *= wave.getLateralDirection()) - 0.006535947712418301, guessFactor + 0.006535947712418301, 0.16));
            }
            ArrayList<Pair<Integer, Double>> dangerIndices = new ArrayList<Pair<Integer, Double>>();
            for (int i = 0; i < dangers.size(); ++i) {
                dangerIndices.add(new Pair<Integer, Double>(i, (Double)dangers.get(i)));
            }
            dangerIndices.sort(Collections.reverseOrder());
            ArrayList<Double> updatedProbabilities = new ArrayList<Double>();
            ArrayList<Line2D.Double> updatedSegments = new ArrayList<Line2D.Double>();
            double probability = 0.0;
            for (Pair pair : dangerIndices) {
                double currentProbability = (Double)pair.getComparable();
                if (!(probability + currentProbability <= 0.5)) continue;
                probability += currentProbability;
                int index = (Integer)pair.getObject();
                updatedProbabilities.add((Double)dangers.get(index));
                updatedSegments.add((Line2D.Double)segments.get(index));
            }
            double average = MoveUtils.mean(updatedProbabilities);
            double stdDev = MoveUtils.stdDev(updatedProbabilities);
            for (int j2 = 0; j2 < updatedSegments.size(); ++j2) {
                Line2D.Double line = (Line2D.Double)updatedSegments.get(j2);
                Point2D previous = line.getP1();
                Point2D current = line.getP2();
                g.setColor(RavenFlight.heatMap((Double)updatedProbabilities.get(j2), average, stdDev));
                g.drawLine((int)previous.getX(), (int)previous.getY(), (int)current.getX(), (int)current.getY());
            }
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.GREEN);
        for (ShadowBullet shadowBullet : this.BULLETS) {
            Point2D.Double currentPos = shadowBullet.getLocation();
            Point2D.Double oldPos = MoveUtils.project(currentPos, shadowBullet.getAbsBearing() + Math.PI, shadowBullet.getVelocity());
            g.drawLine((int)(currentPos.x + 0.5), (int)(currentPos.y + 0.5), (int)(oldPos.x + 0.5), (int)(oldPos.y + 0.5));
        }
        this.WS_GT.onPaint(g);
    }

    private static Color heatMap(double normalizedValue, double average, double stdDev) {
        if (normalizedValue == 0.0) {
            return Color.GREEN;
        }
        double min = average - 2.0 * stdDev;
        double max = average + 2.0 * stdDev;
        double range = max - min;
        double value = MoveUtils.limit(0.0, (normalizedValue - min) / range, 1.0);
        return new Color((int)Math.min(value * 510.0, 255.0), 0, (int)Math.min(510.0 - value * 510.0, 255.0));
    }
}

