/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.BulletData;
import deo.virtual.EnemyBot;
import deo.virtual.RobotData;
import deo.virtual.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

public class AdvancedEnemyBot
extends EnemyBot {
    private double x;
    private double y;
    private double distanceRemaining;
    private double remainingAngle;
    long lastUpdated;
    long lastEnergyChange;
    LinkedList bullets;
    double maxBulletTime;
    AdvancedEnemyBot owner;
    int oldAcceleration;
    public Map robots;

    public AdvancedEnemyBot() {
        this.reset();
    }

    public RobotData getRobotData(String s) {
        return (RobotData)this.robots.get(s);
    }

    public boolean inactivityTimerExpired() {
        return this.owner.getTime() - this.lastEnergyChange > 200L;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public void reset() {
        super.reset();
        this.robots = new HashMap(20);
        this.x = 0.0;
        this.y = 0.0;
    }

    public List activeBullets() {
        ArrayList<BulletData> arraylist = new ArrayList<BulletData>(this.bullets.size());
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            BulletData bulletdata = (BulletData)iterator.next();
            if ((double)(this.owner.getTime() - bulletdata.getTime()) > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            if (!bulletdata.isActive()) continue;
            arraylist.add(bulletdata);
        }
        return arraylist;
    }

    public int getOldAcceleration() {
        return this.oldAcceleration;
    }

    public BulletData getBullet(Bullet bullet, long l) {
        Iterator iterator = this.bullets.iterator();
        BulletData bulletdata = null;
        double d = Double.POSITIVE_INFINITY;
        while (iterator.hasNext()) {
            BulletData bulletdata1 = (BulletData)iterator.next();
            if ((double)(this.owner.getTime() - bulletdata1.getTime()) > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            double d1 = Util.distance(bulletdata1.getOriginX(), bulletdata1.getOriginY(), bullet.getX(), bullet.getY());
            double d2 = Math.abs((double)(l - bulletdata1.getTime()) * bullet.getVelocity() - d1);
            if (bulletdata1.isPowerGuessed() && d2 < d) {
                bulletdata = bulletdata1;
                d = d2;
            }
            if (!(Math.abs(bulletdata1.getPower() - bullet.getPower()) < 0.1) || !(d2 < 2.0 * bullet.getVelocity() + 1.0) && !(d2 < 0.18 * d1)) continue;
            return bulletdata1;
        }
        if (bulletdata != null) {
            bulletdata.adapt(bullet.getPower());
        }
        return bulletdata;
    }

    public void updateEnergyChange(long l) {
        this.lastEnergyChange = l;
    }

    @Override
    public void update(ScannedRobotEvent e, AdvancedRobot robot) {
        this.owner = this;
        super.update(e, robot);
        double absBearingDeg = robot.getHeading() + e.getBearing();
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        this.x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * e.getDistance();
        this.y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * e.getDistance();
        this.lastUpdated = e.getTime();
        this.maxBulletTime = (long)Math.ceil(Math.sqrt(this.owner.getBattleFieldWidth() * this.owner.getBattleFieldWidth() + this.owner.getBattleFieldHeight() * this.owner.getBattleFieldHeight()) / 11.0);
        this.oldAcceleration = Math.abs(this.owner.getVelocity()) < Math.abs(this.getVelocity()) ? 1 : (Math.abs(this.owner.getVelocity()) > Math.abs(this.getVelocity()) ? -1 : 0);
    }

    public BulletData nearestBullet() {
        if (this.bullets.isEmpty()) {
            return null;
        }
        Iterator iterator = this.bullets.iterator();
        BulletData bulletdata = null;
        int i = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int j;
            BulletData bulletdata1 = (BulletData)iterator.next();
            if (!bulletdata1.isActive()) continue;
            if ((double)(this.owner.getTime() - bulletdata1.getTime()) > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            double d = Util.distance(this.owner.getX(), this.owner.getY(), bulletdata1.getOriginX(), bulletdata1.getOriginY());
            if (!(bulletdata1.getSpeed() * (double)(this.owner.getTime() - bulletdata1.getTime()) <= d) || (j = (int)Math.floor(d / bulletdata1.getSpeed() - (double)(this.owner.getTime() - bulletdata1.getTime() + 1L))) >= i) continue;
            i = j;
            bulletdata = bulletdata1;
        }
        return bulletdata;
    }
}

