/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.AdvancedEnemyBot;
import deo.virtual.CircularTargetingGun;
import deo.virtual.Gun;
import deo.virtual.HeadOnTargetingGun;
import deo.virtual.PatternMatcherGun;
import deo.virtual.PredictiveTargetingGun;
import deo.virtual.ReallyBadGun;
import deo.virtual.SGFTGun;
import deo.virtual.Util;
import deo.virtual.VBulletWave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class RainbowBot
extends AdvancedRobot {
    Rectangle2D.Double field;
    AdvancedEnemyBot enemy;
    static AdvancedRobot shooter;
    static ArrayList<Gun> guns;
    static ArrayList virtualBullets;
    Gun defaultGun;
    Gun bestGun;
    private static final double MAX_DISTANCE = 1000.0;
    List waves = new ArrayList();
    int[][][][] guessfactors = new int[5][5][5][31];
    static final double A_LITTLE_LESS_THAN_HALF_PI = 1.25;
    int direction = 1;
    final double BULLET_POWER = 1.9;
    int distanceIndex;
    int velocityIndex;
    int lastVelocityIndex;
    String enemyName;
    int tickNum = 0;
    double lastVelocityReal = 0.0;
    public static int BINS;
    public static double[][][][] _surfStats;
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    double[] currentWaves;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public static double _oppEnergy;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;

    static {
        virtualBullets = new ArrayList();
        _oppEnergy = 100.0;
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        WALL_STICK = 160.0;
        BINS = 47;
        _surfStats = new double[5][5][5][BINS];
    }

    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.enemy = new AdvancedEnemyBot();
        if (guns == null) {
            guns = new ArrayList();
            guns.add(new CircularTargetingGun());
            guns.add(new SGFTGun());
            guns.add(new HeadOnTargetingGun());
            guns.add(new PatternMatcherGun());
            guns.add(new ReallyBadGun());
            guns.add(new PredictiveTargetingGun());
            this.defaultGun = guns.get(5);
        }
        virtualBullets.clear();
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setSegmentations(e.getDistance(), e.getVelocity(), this.lastVelocityReal);
        this.currentWaves = _surfStats[this.distanceIndex][this.velocityIndex][this.lastVelocityIndex];
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(0, new Integer(lateralVelocity < 0.0 ? -1 : 1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = RainbowBot.bulletVelocity(bulletPower);
            ew.distanceTraveled = RainbowBot.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = RainbowBot.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        ++this.tickNum;
        this.enemyName = e.getName();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians()));
        double arcToScan = Math.min(Math.atan(36.0 / e.getDistance()), 0.7853981633974483);
        this.setTurnRadarRightRadians(radarTurn += radarTurn >= 0.0 ? arcToScan : -arcToScan);
        this.enemy.update(e, this);
        this.doGun();
    }

    public void doGun() {
        long bestScore = -1L;
        for (Gun gun : guns) {
            if (gun.hits <= bestScore) continue;
            bestScore = gun.hits;
            this.bestGun = gun;
        }
        double bulletPower = 1.9;
        this.setTurnGunRightRadians(Util.normalizeBearing(this.bestGun.getFireAngle(this, this.enemy, bulletPower) - this.getGunHeadingRadians()));
        Bullet b = this.setFireBullet(bulletPower);
        this.setColors(this.bestGun.getColor(), this.bestGun.getColor(), this.bestGun.getColor(), this.bestGun.getColor(), this.bestGun.getColor());
        if (b != null) {
            for (Gun gun : guns) {
                VBulletWave newVirtualBullet = new VBulletWave();
                newVirtualBullet.currentLocation = newVirtualBullet.firedLocation = new Point2D.Double(this.getX(), this.getY());
                newVirtualBullet.bearing = gun.getFireAngle(this, this.enemy, b.getPower());
                newVirtualBullet.velocity = 14.3;
                newVirtualBullet.gunUsed = gun;
                newVirtualBullet.shooter = this;
                virtualBullets.add(newVirtualBullet);
                this.addCustomEvent(newVirtualBullet);
                ++gun.fired;
            }
        }
    }

    public void onPaint(Graphics2D g) {
        for (VBulletWave virtualBullet : virtualBullets) {
            g.setColor(virtualBullet.gunUsed.getColor());
            double bulletSize = (virtualBullet.velocity - 20.0) / -3.0;
            g.fillOval((int)(virtualBullet.currentLocation.x - bulletSize), (int)(virtualBullet.currentLocation.y - bulletSize), (int)(bulletSize * 2.0), (int)(bulletSize * 2.0));
        }
        int numberOfGuns = guns.size();
        int j = 0;
        while (j < numberOfGuns) {
            Gun gun = guns.get(j);
            g.setColor(Color.WHITE);
            String percent = String.valueOf(gun.fired == 0L ? 0L : Math.round((double)gun.hits / (double)gun.fired * 100.0)) + "%";
            g.drawString(String.valueOf(gun.getName()) + ": " + percent, 20, 5 + j * 15);
            g.setColor(gun.getColor());
            g.fillOval(5, 5 + j * 15, 10, 10);
            ++j;
        }
    }

    public void endRound() {
        this.out.println();
        this.out.println("Virtual bullet statistics");
        this.out.println("--------------------------");
        this.out.println("Current Gun: " + this.bestGun.getName());
        for (Gun gun : guns) {
            String percent = String.valueOf(gun.fired == 0L ? 0.0 : (double)gun.hits / (double)gun.fired * 100.0) + "%";
            this.out.println(String.valueOf(gun.getName()) + ": " + percent);
        }
    }

    public void onWin(WinEvent e) {
        this.endRound();
    }

    public void onDeath(DeathEvent e) {
        this.endRound();
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = RainbowBot.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / RainbowBot.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)RainbowBot.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = RainbowBot.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            this.currentWaves[n] = this.currentWaves[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (!(Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) >= 50.0) && Math.round(RainbowBot.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, RainbowBot.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.25, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + RainbowBot.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir >= 0.0 ? moveDir : 2.0 * moveDir;
            predictedVelocity = RainbowBot.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = RainbowBot.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = RainbowBot.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return this.currentWaves[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = RainbowBot.absoluteBearing(surfWave.fireLocation, this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        RainbowBot.setBackAsFront(this, goAngle);
    }

    public double absbearing(double bearingRadians) {
        return this.getHeadingRadians() + bearingRadians;
    }

    public double getEnemyX(double x, double absbearing, double distance) {
        return x + Math.sin(absbearing) * distance;
    }

    public double getEnemyY(double y, double absbearing, double distance) {
        return y + Math.cos(absbearing) * distance;
    }

    public void setSegmentations(double distance, double velocity, double lastVelocity) {
        this.distanceIndex = (int)(distance / 200.0);
        this.velocityIndex = (int)Math.abs(velocity / 2.0);
        this.lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(RainbowBot.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
        final RainbowBot this$0;

        public EnemyWave() {
            this.this$0 = RainbowBot.this;
        }
    }
}

