/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.radar;

import gf.Centaur.Data;
import gf.Centaur.abstracts.Module;
import gf.Centaur.radar.GunHeatLock;
import gf.Centaur.radar.NarrowLock;
import gf.Centaur.radar.RadarControll;
import robocode.AdvancedRobot;
import robocode.CustomEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Radar
extends Module {
    private AdvancedRobot robot;
    private Data data;
    private RadarControll radar;

    public void setOther(Data data, AdvancedRobot robot) {
        this.robot = robot;
        this.data = data;
        this.radar = robot.getOthers() > 1 ? new GunHeatLock(data, robot, false) : new NarrowLock(data, robot, false);
    }

    @Override
    public void start() {
        this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.radar.onScannedRobot(e);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        this.radar.onRobotDeath(e);
        if (this.robot.getOthers() == 1) {
            this.radar = new NarrowLock(this.data, this.robot);
        }
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        this.radar.onCustomEvent(e);
    }
}

