/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollingHistory<T>
implements Iterable<T> {
    private LinkedList<T> history = new LinkedList();
    private int size;

    public RollingHistory(int size) {
        this.size = size;
    }

    public T newIteration(T newElement) {
        this.history.add(newElement);
        if (this.history.size() > this.size) {
            return this.history.removeFirst();
        }
        return null;
    }

    public T current() {
        return this.history.getLast();
    }

    public T previous() {
        return this.history.get(Math.max(this.history.size() - 2, 0));
    }

    @Override
    public Iterator<T> iterator() {
        return this.history.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (T t : this) {
            buf.append(t.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public int size() {
        return this.history.size();
    }

    public T getHist(int i) {
        return this.history.get(i);
    }

    public ListIterator<T> getLastNItems(int lookback) {
        return this.history.listIterator(Math.max(this.history.size() - lookback, 0));
    }

    public int indexOf(T t) {
        return this.history.indexOf(t);
    }

    public ListIterator<T> getItemsBeginningAt(int index) {
        return this.history.listIterator(index);
    }
}

