/*
 * Decompiled with CFR 0.152.
 */
package deith;

import java.util.Enumeration;
import java.util.Vector;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enemy {
    private boolean rambot = false;
    private ScannedRobotEvent now = null;
    private ScannedRobotEvent last = null;
    private double xNow;
    private double yNow;
    private double xLast;
    private double yLast;
    private double avgVelocity = 0.0;
    private double avgVelocityMinus = 0.0;
    private long time = 0L;
    private long lastTime = 0L;
    private double energy;
    boolean alive = true;
    private Vector vdist = new Vector();
    private Vector vvel = new Vector();
    private Vector vang = new Vector();

    public void nextRound() {
        this.setAlive(true);
        this.setEnergy(100.0);
        if (this.getVvel().size() > 0) {
            this.getVvel().removeElementAt(this.getVvel().size() - 1);
        }
    }

    public void clear() {
        this.vdist = new Vector();
        this.vvel = new Vector();
        this.vang = new Vector();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean a) {
        this.alive = a;
    }

    public boolean isScaned() {
        return this.last != null && this.now != null;
    }

    public void setNow(ScannedRobotEvent e) {
        this.lastTime = this.time;
        this.time = e.getTime();
        this.last = this.now;
        this.now = e;
        int size = 7000;
        int i = 0;
        while ((long)i < this.getScanTime()) {
            this.getVang().addElement(this.getDifferenceAngle() / (double)this.getScanTime());
            if (this.getVang().size() > size) {
                this.getVang().removeElementAt(0);
            }
            ++i;
        }
        if (this.getVvel().size() > 3) {
            int r = (Integer)this.getVvel().elementAt(this.getVvel().size() - 1);
            int i2 = 0;
            while ((long)i2 < this.getScanTime() - 1L) {
                int rr = 0;
                rr = (double)r < e.getVelocity() ? r + (i2 + 1) : ((double)r > e.getVelocity() ? r - (i2 + 1) : r);
                if (rr > 8) {
                    rr = 8;
                }
                if (rr < -8) {
                    rr = -8;
                }
                this.getVvel().add(Math.round(rr));
                if (this.getVvel().size() > size) {
                    this.getVvel().removeElementAt(0);
                }
                ++i2;
            }
            this.getVvel().add((int)Math.round(e.getVelocity()));
            if (this.getVvel().size() > size) {
                this.getVvel().removeElementAt(0);
            }
        } else {
            i = 0;
            while ((long)i < this.getScanTime()) {
                this.getVvel().add((int)Math.round(e.getVelocity()));
                if (this.getVvel().size() > size) {
                    this.getVvel().removeElementAt(0);
                }
                ++i;
            }
        }
        if (this.last != null) {
            if (this.vdist.size() > 30) {
                this.vdist.removeElementAt(0);
            }
            this.getEnemyCord(e.getHeadingRadians());
            this.getEnemyLastCord(e.getHeadingRadians());
            double x = this.getXNow();
            double y = this.getYNow();
            double d = Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5);
            x = this.getXLast();
            y = this.getYLast();
            d = Math.abs(d - Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5));
            this.vdist.add(d);
        }
        this.avgVelocity = (this.getAvgVelocity() + Math.abs(e.getVelocity())) / 2.0;
        this.setAvgVelocityMinus((this.getAvgVelocityMinus() + e.getVelocity()) / 2.0);
    }

    public int getPrevPos(int turns, int ch) {
        try {
            int check = ch;
            boolean ok = false;
            if (turns + check + 5 < this.getVvel().size()) {
                int i;
                for (i = this.getVvel().size() - turns - check - 5; i >= 0 && !ok; --i) {
                    try {
                        if (this.getVvel().size() - 1 - i <= check) continue;
                        ok = true;
                        for (int j = 0; j < check - 1 && ok; ++j) {
                            if (((Integer)this.getVvel().elementAt(this.getVvel().size() - (check - j)) == (Integer)this.getVvel().elementAt(i + j) || (Integer)this.getVvel().elementAt(this.getVvel().size() - (check - j)) + 1 == (Integer)this.getVvel().elementAt(i + j) || (Integer)this.getVvel().elementAt(this.getVvel().size() - (check - j)) - 1 == (Integer)this.getVvel().elementAt(i + j)) && Math.abs((Double)this.getVang().elementAt(this.getVvel().size() - (check - j))) - Math.abs((Double)this.getVang().elementAt(i + j)) < Math.toRadians(1.0)) continue;
                            ok = false;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (ok) {
                    return i + check;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public double getAvgVectorDist() {
        Enumeration e = this.vdist.elements();
        double elem = 0.0;
        while (e.hasMoreElements()) {
            elem += ((Double)e.nextElement()).doubleValue();
        }
        return elem / (double)this.vdist.size();
    }

    public ScannedRobotEvent getNow() {
        return this.now;
    }

    public ScannedRobotEvent getLast() {
        return this.last;
    }

    public long getScanTime() {
        return this.time - this.lastTime;
    }

    public double getNextVelocity(double vel, int act) {
        double newVel = vel;
        if (act == 0) {
            return newVel;
        }
        if (newVel == 0.0) {
            return 0.0;
        }
        if (newVel > 0.0) {
            if (act == -1) {
                if (newVel - 2.0 <= 0.0) {
                    return 0.0;
                }
                return newVel - 2.0;
            }
            if (newVel < 8.0) {
                return newVel + 1.0;
            }
            return 8.0;
        }
        if (act == -1) {
            if (newVel + 2.0 >= 0.0) {
                return 0.0;
            }
            return newVel + 2.0;
        }
        if (newVel > -8.0) {
            return newVel - 1.0;
        }
        return -8.0;
    }

    public int getNextVelocity(int vel, int act) {
        int newVel = vel;
        if (act == 0) {
            return newVel;
        }
        if (newVel == 0) {
            return 0;
        }
        if (newVel > 0) {
            if (act == -1) {
                if (newVel - 2 <= 0) {
                    return 0;
                }
                return newVel - 2;
            }
            if (newVel < 8) {
                return newVel + 1;
            }
            return 8;
        }
        if (act == -1) {
            if (newVel + 2 >= 0) {
                return 0;
            }
            return newVel + 2;
        }
        if (newVel > -8) {
            return newVel - 1;
        }
        return -8;
    }

    public void getEnemyCord(double tankHeading) {
        double angle = Utils.normalAbsoluteAngle((double)(tankHeading + this.getNow().getBearingRadians()));
        double dist = this.getNow().getDistance();
        double y = this.getX(dist, angle);
        this.setXNow(Math.signum(Math.sin(angle)) * (double)Math.abs(Math.round(y * Math.tan(angle))));
        this.setYNow(Math.signum(Math.cos(angle)) * (double)Math.abs(Math.round(y)));
    }

    public void getEnemyLastCord(double tankHeading) {
        double angle = Utils.normalAbsoluteAngle((double)(tankHeading + this.getLast().getBearingRadians()));
        double dist = this.getLast().getDistance();
        double y = this.getX(dist, angle);
        this.setXLast(Math.signum(Math.sin(angle)) * (double)Math.abs(Math.round(y * Math.tan(angle))));
        this.setYLast(Math.signum(Math.cos(angle)) * (double)Math.abs(Math.round(y)));
    }

    private double getX(double dist, double angle) {
        return Math.pow(Math.pow(dist, 2.0) / (Math.pow(Math.tan(angle), 2.0) + 1.0), 0.5);
    }

    public double getXNow() {
        return this.xNow;
    }

    public void setXNow(double xNow) {
        this.xNow = xNow;
    }

    public double getYNow() {
        return this.yNow;
    }

    public void setYNow(double yNow) {
        this.yNow = yNow;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public double getAvgVelocity() {
        return this.avgVelocity;
    }

    public double getXLast() {
        return this.xLast;
    }

    public void setXLast(double xLast) {
        this.xLast = xLast;
    }

    public double getYLast() {
        return this.yLast;
    }

    public void setYLast(double yLast) {
        this.yLast = yLast;
    }

    public double getAvgVelocityMinus() {
        return this.avgVelocityMinus;
    }

    public void setAvgVelocityMinus(double avgVelocityMinus) {
        this.avgVelocityMinus = avgVelocityMinus;
    }

    public Vector getVvel() {
        return this.vvel;
    }

    public void setVvel(Vector vvel) {
        this.vvel = vvel;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public void doDamage(double dam) {
        this.energy -= dam;
    }

    public double getDifferenceAngle() {
        if (this.getNow() != null && this.getLast() != null) {
            return Utils.normalRelativeAngle((double)(this.getNow().getHeadingRadians() - this.getLast().getHeadingRadians()));
        }
        return 0.0;
    }

    public Vector getVang() {
        return this.vang;
    }

    public void setVang(Vector vang) {
        this.vang = vang;
    }

    public boolean isRambot() {
        return this.rambot;
    }

    public void setRambot(boolean rambot) {
        this.rambot = rambot;
    }
}

