/*
 * Decompiled with CFR 0.152.
 */
package rdt199.movement;

import java.util.Vector;
import rdt199.movement.GravityPoint;
import rdt199.movement.MoveMode;
import rdt199.movement.MovementManager;
import rdt199.util.BotFuncs;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotLogger;
import rdt199.util.RobotSnapshot;
import rdt199.util.Storage;

public class GravityMeleeMode
extends MoveMode {
    protected static double ROBOT_GRAVITY = 1.0;
    protected static double INTERSECTION_GRAVITY = 0.1;
    protected static double CENTER_GRAVITY = 10.0;
    protected static double WALL_GRAVITY = 25.0;
    protected static double WALL_RANDOMNESS = 0.3;
    protected static double WALL_POINT_DISTANCE = 50.0;
    protected static double RANDOM_STRENGTH = 0.4;
    protected static double ANGLE_VARIANCE = 20.0;
    protected static double DISTANCE_CUTTOFF = 400.0;
    protected static int EDGE_ACCURACY = 100;
    protected double[] m_dRandomValues;
    protected double m_dXGravity;
    protected double m_dYGravity;
    protected int m_iRandomIndex;
    protected int m_iTSHMF;
    protected Vector m_Angles;
    protected Vector m_WallPoints;
    protected GravityPoint m_Center = new GravityPoint(new Location(BotFuncs.m_AdvancedRobot.getBattleFieldWidth() / 2.0, BotFuncs.m_AdvancedRobot.getBattleFieldHeight() / 2.0), CENTER_GRAVITY);
    protected GravityPoint m_CurrentPosition;

    public GravityMeleeMode(MovementManager manager) {
        super(manager);
        this.m_WallPoints = new Vector();
        new GravityPoint(new Location(0.0, 0.0), 10.0);
        int iCount = 0;
        while ((double)iCount <= BotFuncs.m_AdvancedRobot.getBattleFieldWidth()) {
            this.m_WallPoints.addElement(new GravityPoint(new Location(iCount, BotFuncs.m_AdvancedRobot.getBattleFieldHeight()), WALL_GRAVITY + Math.random() * WALL_RANDOMNESS));
            this.m_WallPoints.addElement(new GravityPoint(new Location(iCount, 0.0), WALL_GRAVITY + Math.random() * WALL_RANDOMNESS));
            iCount = (int)((double)iCount + WALL_POINT_DISTANCE);
        }
        iCount = 0;
        while ((double)iCount <= BotFuncs.m_AdvancedRobot.getBattleFieldHeight()) {
            this.m_WallPoints.addElement(new GravityPoint(new Location(BotFuncs.m_AdvancedRobot.getBattleFieldWidth(), iCount), WALL_GRAVITY + Math.random() * WALL_RANDOMNESS));
            this.m_WallPoints.addElement(new GravityPoint(new Location(0.0, iCount), WALL_GRAVITY + Math.random() * WALL_RANDOMNESS));
            iCount = (int)((double)iCount + WALL_POINT_DISTANCE);
        }
        this.m_iRandomIndex = 0;
        this.m_dRandomValues = new double[1000];
        iCount = 0;
        while (iCount < 1000) {
            this.m_dRandomValues[iCount] = Math.random() * 360.0;
            ++iCount;
        }
        this.m_iTSHMF = 0;
    }

    public double getScore() {
        if (BotFuncs.m_AdvancedRobot.getOthers() > 1) {
            return 1000.0;
        }
        return 0.0;
    }

    public void close() {
    }

    private double getRandomValue() {
        double dReturn = this.m_dRandomValues[this.m_iRandomIndex];
        ++this.m_iRandomIndex;
        if (this.m_iRandomIndex >= 1000) {
            this.m_iRandomIndex = 0;
        }
        return dReturn;
    }

    public void update() {
        this.m_dXGravity = 0.0;
        this.m_dYGravity = 0.0;
        RobotLogger Logger2 = BotFuncs.m_RobotLogger;
        Storage Logs = Logger2.getAllBotStats();
        int iCount = 0;
        while (iCount < Logs.size()) {
            RobotSnapshot Snap;
            RobotLog Log = (RobotLog)Logs.get(iCount);
            if (Log != null && (Snap = Log.get(0)) != null) {
                double dModifier = 0.0;
                GravityPoint GP = new GravityPoint(Snap.m_Location, ROBOT_GRAVITY * dModifier);
                this.calcGravity(GP);
            }
            ++iCount;
        }
        this.calcGravity(this.m_Center);
        iCount = 0;
        while (iCount < this.m_WallPoints.size()) {
            this.calcWallGravity((GravityPoint)this.m_WallPoints.elementAt(iCount));
            ++iCount;
        }
        this.calcIntersects();
        ++this.m_iTSHMF;
        if (this.m_iTSHMF > 10 && BotFuncs.m_AdvancedRobot.getTime() % 20L == 0L) {
            this.putPoint();
        }
        if (this.m_CurrentPosition != null) {
            this.calcGravity(this.m_CurrentPosition);
        }
        this.m_MoveManager.setTarget(null);
        double dAngle = BotFuncs.getAbsBearing(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY(), BotFuncs.m_AdvancedRobot.getX() + this.m_dXGravity, BotFuncs.m_AdvancedRobot.getY() + this.m_dYGravity);
        dAngle = Math.toDegrees(dAngle);
        dAngle = dAngle + Math.random() % 60.0 - 30.0;
        boolean bForwards = this.m_MoveManager.setAbsoluteHeadingDegrees(dAngle);
        if (bForwards) {
            BotFuncs.m_AdvancedRobot.setAhead(100.0);
        } else {
            BotFuncs.m_AdvancedRobot.setAhead(-100.0);
        }
    }

    public void calcIntersects() {
        RobotLogger Logger2 = BotFuncs.m_RobotLogger;
        Storage Logs = Logger2.getAllBotStats();
        int iCount = 0;
        while (iCount < Logs.size()) {
            RobotLog Log = (RobotLog)Logs.get(iCount);
            if (Log != null) {
                int iCountInner = 0;
                while (iCountInner < Logs.size()) {
                    RobotLog LogInner = (RobotLog)Logs.get(iCountInner);
                    if (LogInner != null && !Log.getName().equals(LogInner)) {
                        this.calcIntersect(Log, LogInner);
                    }
                    ++iCountInner;
                }
            }
            ++iCount;
        }
    }

    public void calcIntersect(RobotLog rl, RobotLog rl2) {
        RobotSnapshot Snap1 = rl.get(0);
        if (Snap1 == null) {
            return;
        }
        RobotSnapshot Snap2 = rl2.get(0);
        if (Snap2 == null) {
            return;
        }
        double dDistance = BotFuncs.getDistanceBetween(Snap1.m_Location, Snap2.m_Location);
        double dAngle = BotFuncs.getAbsBearing(Snap2.m_Location, Snap1.m_Location);
        double dX = Math.sin(dAngle) * (dDistance /= 3.0);
        double dY = Math.cos(dAngle) * dDistance;
        double dCurrentX = Snap1.m_Location.getX() + dX;
        double dCurrentY = Snap1.m_Location.getY() + dY;
        int iCount = 0;
        while (iCount < 3) {
            GravityPoint GP = new GravityPoint(new Location(dCurrentX, dCurrentY), INTERSECTION_GRAVITY);
            this.calcGravity(GP);
            dCurrentX += dX;
            dCurrentY += dY;
            ++iCount;
        }
    }

    public void calcWallGravity(GravityPoint gp) {
        Location Loc = gp.calcWallGravity();
        this.m_dXGravity += Loc.getX();
        this.m_dYGravity += Loc.getY();
    }

    public void calcGravity(GravityPoint gp) {
        Location Loc = gp.calcGravity();
        this.m_dXGravity += Loc.getX();
        this.m_dYGravity += Loc.getY();
    }

    public void putPoint() {
        this.calcAngles();
        if (this.m_Angles.size() < 1) {
            this.m_CurrentPosition = this.getGravityPoint(Math.random() * 360.0, 50.0, RANDOM_STRENGTH);
            return;
        }
        boolean bFound = false;
        double dAngle = 0.0;
        int iCount2 = 0;
        while (!bFound && iCount2 < 50) {
            dAngle = this.getRandomValue();
            int iCount = 0;
            while (iCount < this.m_Angles.size()) {
                int iAngle = (Integer)this.m_Angles.elementAt(iCount);
                if (dAngle + ANGLE_VARIANCE > (double)iAngle && dAngle - ANGLE_VARIANCE < (double)iAngle) {
                    bFound = false;
                    break;
                }
                bFound = true;
                ++iCount;
            }
            System.out.println("Guess: " + dAngle);
            ++iCount2;
        }
        this.m_CurrentPosition = this.getGravityPoint(dAngle, 50.0, RANDOM_STRENGTH);
    }

    public void calcAngles() {
        this.m_Angles = new Vector();
        RobotLogger Logger2 = BotFuncs.m_RobotLogger;
        Storage Logs = Logger2.getAllBotStats();
        int iCount = 0;
        while (iCount < Logs.size()) {
            double dDistance;
            RobotSnapshot Snap;
            RobotLog Log = (RobotLog)Logs.get(iCount);
            if (Log != null && (Snap = Log.get(0)) != null && (dDistance = BotFuncs.getDistanceBetween(new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), Snap.m_Location)) < DISTANCE_CUTTOFF) {
                int iAngle = (int)Math.toDegrees(BotFuncs.getAbsBearing(new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), Snap.m_Location));
                Integer Angle1 = new Integer((iAngle + 180) % 360);
                this.m_Angles.addElement(Angle1);
                if (dDistance > 40.0) {
                    Angle1 = new Integer(iAngle);
                    this.m_Angles.addElement(Angle1);
                }
            }
            ++iCount;
        }
    }

    public GravityPoint getGravityPoint(double angle, double distance, double strength) {
        double dX = Math.sin(angle) * distance;
        double dY = Math.cos(angle) * distance;
        return new GravityPoint(new Location(BotFuncs.m_AdvancedRobot.getX() + dX, BotFuncs.m_AdvancedRobot.getY() + dY), strength);
    }
}

