/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class LightningMover {
    private AdvancedRobot _robot;
    private static double[][][][] _surfStats = new double[2][3][5][47];
    private static Point2D.Double _myLocation;
    private static Point2D.Double _enemyLocation;
    private static LinkedList _enemyWaves;
    private static double _oppEnergy;
    private static EnemyWave _surfWave;
    private static double _lastDistance;
    private static double _surfDistance;
    private static int _lastLastOrientation;
    private static double _lastLatVel;
    private static double _lastLastAbsBearingRadians;
    private static double _lastAbsBearingRadians;
    private static double _lastPredictedDistance;
    private static double _goAngle;
    private static Rectangle2D.Double _fieldRect;
    static double A_LITTLE_LESS_THAN_HALF_PI;
    static final double WALL_STICK = 140.0;
    static final int SURF_MIDDLE_BIN = 23;

    static {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        A_LITTLE_LESS_THAN_HALF_PI = 1.45;
    }

    public LightningMover(AdvancedRobot robot) {
        this._robot = robot;
        _enemyWaves = new LinkedList();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double enemyAbsoluteBearing = this._robot.getHeadingRadians() + e.getBearingRadians();
        double bulletPower = _oppEnergy - e.getEnergy();
        if (d <= 3.0 && bulletPower > 0.0) {
            EnemyWave ew = new EnemyWave();
            this._robot.addCustomEvent((Condition)ew);
            ew.bulletVelocity = LightningMover.bulletVelocity(bulletPower);
            ew.directAngle = _lastLastAbsBearingRadians;
            ew.sourceLocation = _enemyLocation;
            ew.orientation = _lastLastOrientation;
            ew.waveGuessFactors = _surfStats[_fieldRect.contains(LightningMover.project(_enemyLocation, _lastLastAbsBearingRadians + (double)_lastLastOrientation * LightningMover.maxEscapeAngle(ew.bulletVelocity) / 2.0, _lastDistance)) ? 0 : 1][(int)Math.min(_lastDistance / 250.0, 2.0)][(int)(Math.abs(_lastLatVel) / 2.0)];
            _enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        _myLocation = new Point2D.Double(this._robot.getX(), this._robot.getY());
        _lastDistance = e.getDistance();
        _enemyLocation = LightningMover.project(_myLocation, enemyAbsoluteBearing, _lastDistance);
        int direction = _lastLastOrientation = LightningMover.sign(_lastLatVel);
        if (!_enemyWaves.isEmpty()) {
            _surfWave = (EnemyWave)((Object)_enemyWaves.getFirst());
            double angleFromWaveSource = LightningMover.absoluteBearing(LightningMover._surfWave.sourceLocation, _myLocation);
            direction = LightningMover.sign(this.checkDanger(-1) - this.checkDanger(1));
            _goAngle = angleFromWaveSource + this.directedGoAngle(direction);
        }
        this.moveWithBackAsFront(this.wallSmoothing(_myLocation, _goAngle, direction));
        _lastLatVel = this._robot.getVelocity() * Math.sin(e.getBearingRadians());
        _lastLastAbsBearingRadians = _lastAbsBearingRadians;
        _goAngle = _lastAbsBearingRadians = enemyAbsoluteBearing + Math.PI;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!_enemyWaves.isEmpty() && _surfDistance < 100.0) {
            this.logHit(_surfWave, _myLocation, 2);
        }
    }

    public void logHit(Wave w, Point2D.Double targetLocation, int rollingDepth) {
        int x = 46;
        while (x >= 0) {
            w.waveGuessFactors[x] = (w.waveGuessFactors[x] * (double)rollingDepth + (double)(1 + w.weight) / (Math.pow(x - LightningMover.getFactorIndex(w, targetLocation), 2.0) + 1.0)) / (double)(rollingDepth + 1 + w.weight);
            --x;
        }
    }

    private static int getFactorIndex(Wave w, Point2D.Double botLocation) {
        return (int)LightningMover.limit(0.0, Utils.normalRelativeAngle((double)(LightningMover.absoluteBearing(w.sourceLocation, botLocation) - w.directAngle)) * (double)w.orientation / LightningMover.maxEscapeAngle(w.bulletVelocity) * 23.0 + 23.0, 46.0);
    }

    private double checkDanger(int direction) {
        int index = LightningMover.getFactorIndex(_surfWave, this.predictPosition(direction));
        return (LightningMover._surfWave.waveGuessFactors[index] + 0.01 / (double)(Math.abs(index - 23) + 1)) * Math.pow(_lastDistance / _lastPredictedDistance, 4.0);
    }

    private double directedGoAngle(int direction) {
        return (double)direction * A_LITTLE_LESS_THAN_HALF_PI;
    }

    private Point2D.Double predictPosition(int direction) {
        double d;
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = this._robot.getVelocity();
        double predictedHeading = this._robot.getHeadingRadians();
        int counter = 2;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, LightningMover.absoluteBearing(LightningMover._surfWave.sourceLocation, predictedPosition) + (double)direction * A_LITTLE_LESS_THAN_HALF_PI, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + LightningMover.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity = LightningMover.limit(-8.0, predictedVelocity + (predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir), 8.0);
            predictedPosition = LightningMover.project(predictedPosition, predictedHeading, predictedVelocity);
            _lastPredictedDistance = predictedPosition.distance(LightningMover._surfWave.sourceLocation);
        } while (!(d - 15.0 < LightningMover._surfWave.distance + (double)(++counter) * LightningMover._surfWave.bulletVelocity));
        return predictedPosition;
    }

    private static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    private static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    private static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    private static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    static int sign(double d) {
        return d >= 0.0 ? 1 : -1;
    }

    void moveWithBackAsFront(double bearing) {
        double angle = Utils.normalRelativeAngle((double)(bearing - this._robot.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this._robot.setTurnRightRadians(turnAngle);
        this._robot.setAhead((double)(angle == turnAngle ? 100 : -100));
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(LightningMover.project(botLocation, angle, 140.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    class EnemyWave
    extends Wave {
        EnemyWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (_myLocation.distance(this.sourceLocation) <= d + 2.0 * this.bulletVelocity) {
                _enemyWaves.removeFirst();
                LightningMover.this._robot.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }

    abstract class Wave
    extends Condition {
        Point2D.Double sourceLocation;
        double[] waveGuessFactors;
        double bulletVelocity;
        double directAngle;
        double distance;
        int orientation;
        int weight;

        Wave() {
        }
    }
}

