/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Graphics;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.BulletHitEvent;
import wcsv.mega.GFWave;
import wcsv.mega.Gun;
import wcsv.mega.MyInfo;
import wcsv.mega.ScanInfo;
import wcsv.mega.ScanManager;
import wcsv.mega.SegAxis;
import wcsv.mega.Utils;

public class PHGFGun
extends Gun {
    private LinkedList waves;
    private static final double[] gfs = new double[]{-1.05, -1.0, -0.95, -0.9, -0.85, -0.8, -0.75, -0.7, -0.65, -0.6, -0.55, -0.5, -0.45, -0.4, -0.35, -0.3, -0.25, -0.2, -0.15, -0.1, -0.05, 0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0, 1.05};
    private static final int BINS = gfs.length;
    private static final int MID_BIN = (int)((double)BINS / 2.0);
    private static final SegAxis bftSegs = new SegAxis(15.0, 55.0, 3);
    private static final SegAxis bftSegsFast = new SegAxis(20.0, 40.0, 1);
    private static final SegAxis velocitySegs = new SegAxis(0.0, 6.4, 4);
    private static final SegAxis velocitySegsFast = new SegAxis(2.0, 6.0, 1);
    private static final SegAxis wallSegs = new SegAxis(Math.toRadians(5.0), Math.toRadians(45.0), 4);
    private static final SegAxis wallSegsFast = new SegAxis(Math.toRadians(10.0), Math.toRadians(30.0), 2);
    private static final SegAxis wallSegsRev = new SegAxis(-Math.toRadians(10.0), -Math.toRadians(30.0), 2);
    private static final SegAxis wallSegsRevFast = new SegAxis(-Math.toRadians(15.0), -Math.toRadians(30.0), 1);
    private double[][][][][][] hi;
    private double[][][][][][] lo;
    private int num_buffers;
    private int hi_index;
    private double[] hi_buff;
    private int lo_index;
    private double[] lo_buff;

    private void setBuffers(int[][] i) {
        this.hi_buff = this.hi[i[this.hi_index][0]][i[this.hi_index][1]][i[this.hi_index][2]][i[this.hi_index][3]][i[this.hi_index][4]];
        this.lo_buff = this.lo[i[this.lo_index][0]][i[this.lo_index][1]][i[this.lo_index][2]][i[this.lo_index][3]][i[this.lo_index][4]];
    }

    private void update(int[][] indexArr, double bin, double weight) {
        this.setBuffers(indexArr);
        int i = 0;
        while (i < BINS) {
            double val = weight / (1.0 + Utils.sqr(bin - (double)i));
            int n = i;
            this.hi_buff[n] = this.hi_buff[n] + val;
            int n2 = i++;
            this.lo_buff[n2] = this.lo_buff[n2] + val;
        }
        int n = BINS;
        this.hi_buff[n] = this.hi_buff[n] + 1.0;
        int n3 = BINS;
        this.lo_buff[n3] = this.lo_buff[n3] + 1.0;
    }

    private int[][] getSegments(ScanInfo scan, double bulletVel) {
        int[][] segs = new int[this.num_buffers][];
        segs[this.hi_index] = new int[]{bftSegs.getIndex(scan.last().getDistance() / bulletVel), velocitySegs.getIndex(Math.abs(scan.last().getLatVel())), velocitySegs.getIndex(Math.abs(scan.getRollingLatVel())), wallSegs.wallIndex(this.me.getLoc(), scan), wallSegsRev.wallIndex(this.me.getLoc(), scan)};
        segs[this.lo_index] = new int[]{bftSegsFast.getIndex(scan.last().getDistance() / bulletVel), velocitySegsFast.getIndex(Math.abs(scan.last().getLatVel())), velocitySegsFast.getIndex(Math.abs(scan.getRollingLatVel())), wallSegsFast.wallIndex(this.me.getLoc(), scan), wallSegsRevFast.wallIndex(this.me.getLoc(), scan)};
        return segs;
    }

    private double[] getBuffer(int[][] indexArr) {
        this.setBuffers(indexArr);
        double[] buff = new double[BINS];
        double hi_denom = Math.max(this.hi_buff[BINS], 1.0);
        double lo_denom = Math.max(this.lo_buff[BINS], 1.0);
        int i = 0;
        while (i < BINS) {
            int n = i;
            buff[n] = buff[n] + this.hi_buff[i] / hi_denom;
            int n2 = i;
            buff[n2] = buff[n2] + this.lo_buff[i] / lo_denom;
            ++i;
        }
        return buff;
    }

    public PHGFGun(MyInfo me, ScanManager scans) {
        super(me, scans);
        this.hi = new double[PHGFGun.bftSegs.segments + 1][PHGFGun.velocitySegs.segments + 1][PHGFGun.velocitySegs.segments + 1][PHGFGun.wallSegs.segments + 1][PHGFGun.wallSegsRev.segments + 1][BINS + 1];
        this.lo = new double[PHGFGun.bftSegsFast.segments + 1][PHGFGun.velocitySegsFast.segments + 1][PHGFGun.velocitySegsFast.segments + 1][PHGFGun.wallSegsFast.segments + 1][PHGFGun.wallSegsRevFast.segments + 1][BINS + 1];
        this.num_buffers = 2;
        this.hi_index = 0;
        this.lo_index = 1;
        this.waves = new LinkedList();
    }

    public void onScan(ScanInfo scan) {
    }

    public void doGun(ScanInfo target) {
        if (target != null) {
            this.aimAndFire(target);
            ListIterator it = this.waves.listIterator();
            while (it.hasNext()) {
                GFWave wv = (GFWave)it.next();
                double dist = wv.distanceTo(target.last().getLoc(), this.me.getTime());
                if (!(dist <= wv.getVelocity())) continue;
                double gf = wv.getOrbit() * wv.bearingChange(target.last().getLoc()) / Utils.max_escape(wv.getVelocity());
                gf = Utils.getIndex(gf, gfs);
                if (target.last().getEnergy() > 0.0) {
                    this.update(wv.getSegs(), gf, 1.0);
                }
                it.remove();
            }
            int[][] segs = this.getSegments(target, Utils.bulletVel(this.bulletPower));
            this.waves.add(new GFWave(segs, this.me.getLoc(), target.last().getBearing(), Utils.bulletVel(this.bulletPower), this.me.getTime() - 1L, target.last().getOrbit(), this.firedThisTick));
        }
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    protected double getAngle(ScanInfo target) {
        if (target.last().getEnergy() <= 0.0) {
            return target.last().getBearing();
        }
        double bulletVel = Utils.bulletVel(this.bulletPower);
        double[] final_buffer = this.getBuffer(this.getSegments(target, bulletVel));
        int max_index = MID_BIN;
        int i = 0;
        while (i < BINS) {
            if (final_buffer[i] > final_buffer[max_index]) {
                max_index = i;
            }
            ++i;
        }
        return Utils.absAngle(target.last().getBearing() + Utils.max_escape(bulletVel) * gfs[max_index] * target.last().getOrbit());
    }

    protected double getBulletPower(ScanInfo target) {
        double power = Utils.bindRange(600.0 / target.last().getDistance(), 2.0, 3.0);
        power = Utils.bindRange(target.last().getEnergy() / 8.0, 0.3, power);
        return power;
    }

    protected void reset(MyInfo newMe, ScanManager newScans) {
        super.reset(newMe, newScans);
        this.waves.clear();
    }

    public void draw(Graphics g) {
        ListIterator it = this.waves.listIterator();
        while (it.hasNext()) {
            GFWave wv = (GFWave)it.next();
            wv.draw(g, this.me.getTime());
        }
    }
}

