/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.stats;

import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.stats.FiredBullet;
import de.simpleworks.robocode.stats.HitRatio;
import java.util.HashMap;

public class HitRatios {
    public static final String METHOD_NONE = "NONE";
    private static final double CONST_MIN_SUCC_RATE = 50.0;
    private HashMap<String, HitRatio> FRatios = new HashMap();

    public void updateStat(FiredBullet _fb) {
        String aimMethod = _fb.getMethod();
        if (!this.FRatios.containsKey(aimMethod)) {
            this.FRatios.put(aimMethod, new HitRatio());
        }
        this.FRatios.get(aimMethod).addShot(_fb);
    }

    public HitRatio getHitRatio(String _aimMethod) {
        return this.FRatios.get(_aimMethod);
    }

    public int getTotalShots() {
        int iShots = 0;
        for (String key : this.FRatios.keySet()) {
            iShots += this.FRatios.get(key).getShotCount();
        }
        return iShots;
    }

    public int getTotalHits() {
        int iHits = 0;
        for (String key : this.FRatios.keySet()) {
            iHits += this.FRatios.get(key).getHitCount();
        }
        return iHits;
    }

    public int getTotalMisses() {
        int iMisses = 0;
        for (String key : this.FRatios.keySet()) {
            iMisses += this.FRatios.get(key).getMissedCount();
        }
        return iMisses;
    }

    public double getTotalHitRatio() {
        int iHits = 0;
        int iShots = 0;
        for (String key : this.FRatios.keySet()) {
            iShots += this.FRatios.get(key).getShotCount();
            iHits += this.FRatios.get(key).getHitCount();
        }
        return 100 / iShots * iHits;
    }

    public String getPreferredMethod() {
        return this.searchPreferredMethod(false);
    }

    public String getPreferredMethod(int _availMethCnt) {
        return this.searchPreferredMethod(_availMethCnt == this.FRatios.size());
    }

    private String searchPreferredMethod(boolean _knowAnyAvailable) {
        String res = METHOD_NONE;
        double maxHitRatio = 0.0;
        double thisHitRatio = 0.0;
        for (String key : this.FRatios.keySet()) {
            thisHitRatio = this.FRatios.get(key).getHitRatio();
            if (!(thisHitRatio > maxHitRatio)) continue;
            maxHitRatio = thisHitRatio;
            if (!(thisHitRatio >= 50.0) && !_knowAnyAvailable) continue;
            res = key;
        }
        Debug.print(true, "prefFireMethod:" + res);
        return res;
    }
}

