/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.waveGun.formula;

import catcat20.core.bot.Bot;
import catcat20.core.gun.waveGun.GunWave;
import catcat20.core.gun.waveGun.formula.GunFormula;
import catcat20.core.utils.LUtils;
import java.awt.geom.Point2D;

public class MainGunFormula
extends GunFormula {
    public MainGunFormula() {
        super(new double[]{6.0, 4.0, 8.0, 0.0, 0.0, 0.0, 3.0, 1.5, 0.1});
    }

    @Override
    public double[] dataPoint(GunWave w) {
        double latVel = Bot.lateralVelocity(w.myState, w.enState);
        double oldLatVel = Bot.lateralVelocity(w.oldMyState, w.oldEnState);
        double accel = LUtils.accel(latVel, oldLatVel);
        double dist = Point2D.distance(w.myState.x, w.myState.y, w.enState.x, w.enState.y);
        double bft = dist / w.bulletVelocity;
        return new double[]{Math.abs(latVel) / 8.0, (accel + 2.0) / 4.0, bft / 91.0, w.dist8 / 64.0, w.dist30 / 240.0, LUtils.limit(0.0, w.dirChangeTime / 30.0, 1.0), w.meas[0] / w.maxEscapeAngle(), w.meas[1] / w.maxEscapeAngle(), w.enState.shotsFired};
    }
}

