/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vectors;
import org.la4j.decomposition.AbstractDecompositor;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.vector.DenseVector;

public class SingularValueDecompositor
extends AbstractDecompositor
implements MatrixDecompositor {
    public SingularValueDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        int i;
        int k;
        int j;
        Matrix a = this.matrix.copy();
        int n = Math.min(a.rows(), a.columns());
        Matrix u = this.matrix.blankOfShape(a.rows(), n);
        Matrix s = this.matrix.blankOfShape(a.columns(), a.columns());
        Matrix v = this.matrix.blankOfShape(a.columns(), a.columns());
        DenseVector e = DenseVector.zero(a.columns());
        DenseVector work = DenseVector.zero(a.rows());
        int nct = Math.min(a.rows() - 1, a.columns());
        int nrt = Math.max(0, Math.min(a.columns() - 2, a.rows()));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            int i4;
            if (k2 < nct) {
                s.set(k2, k2, 0.0);
                for (i4 = k2; i4 < a.rows(); ++i4) {
                    s.set(k2, k2, this.hypot(s.get(k2, k2), a.get(i4, k2)));
                }
                if (Math.abs(s.get(k2, k2)) > Matrices.EPS) {
                    if (a.get(k2, k2) < 0.0) {
                        s.updateAt(k2, k2, Matrices.INV_FUNCTION);
                    }
                    double skk = s.get(k2, k2);
                    for (i3 = k2; i3 < a.rows(); ++i3) {
                        a.updateAt(i3, k2, Matrices.asDivFunction(skk));
                    }
                    a.updateAt(k2, k2, Matrices.INC_FUNCTION);
                }
                s.updateAt(k2, k2, Matrices.INV_FUNCTION);
            }
            for (j = k2 + 1; j < a.columns(); ++j) {
                if (k2 < nct & Math.abs(s.get(k2, k2)) > Matrices.EPS) {
                    double t = 0.0;
                    for (i2 = k2; i2 < a.rows(); ++i2) {
                        t += a.get(i2, k2) * a.get(i2, j);
                    }
                    t = -t / a.get(k2, k2);
                    for (i2 = k2; i2 < a.rows(); ++i2) {
                        a.updateAt(i2, j, Matrices.asPlusFunction(t * a.get(i2, k2)));
                    }
                }
                e.set(j, a.get(k2, j));
            }
            if (k2 < nct) {
                for (i4 = k2; i4 < a.rows(); ++i4) {
                    u.set(i4, k2, a.get(i4, k2));
                }
            }
            if (k2 >= nrt) continue;
            e.set(k2, 0.0);
            for (i4 = k2 + 1; i4 < a.columns(); ++i4) {
                e.set(k2, this.hypot(e.get(k2), e.get(i4)));
            }
            if (Math.abs(e.get(k2)) > Matrices.EPS) {
                if (e.get(k2 + 1) < 0.0) {
                    e.updateAt(k2, Vectors.INV_FUNCTION);
                }
                double ek = e.get(k2);
                for (i3 = k2 + 1; i3 < a.columns(); ++i3) {
                    e.updateAt(i3, Vectors.asDivFunction(ek));
                }
                e.updateAt(k2 + 1, Vectors.INC_FUNCTION);
            }
            e.updateAt(k2, Vectors.INV_FUNCTION);
            if (k2 + 1 < a.rows() && Math.abs(e.get(k2)) > Matrices.EPS) {
                int j2;
                for (int i5 = k2 + 1; i5 < a.rows(); ++i5) {
                    work.set(i5, 0.0);
                }
                for (j2 = k2 + 1; j2 < a.columns(); ++j2) {
                    for (int i6 = k2 + 1; i6 < a.rows(); ++i6) {
                        work.updateAt(i6, Vectors.asPlusFunction(e.get(j2) * a.get(i6, j2)));
                    }
                }
                for (j2 = k2 + 1; j2 < a.columns(); ++j2) {
                    double t = -e.get(j2) / e.get(k2 + 1);
                    for (i2 = k2 + 1; i2 < a.rows(); ++i2) {
                        a.updateAt(i2, j2, Matrices.asPlusFunction(t * work.get(i2)));
                    }
                }
            }
            for (i4 = k2 + 1; i4 < a.columns(); ++i4) {
                v.set(i4, k2, e.get(i4));
            }
        }
        int p = Math.min(a.columns(), a.rows() + 1);
        if (nct < a.columns()) {
            s.set(nct, nct, a.get(nct, nct));
        }
        if (a.rows() < p) {
            s.set(p - 1, p - 1, 0.0);
        }
        if (nrt + 1 < p) {
            e.set(nrt, a.get(nrt, p - 1));
        }
        e.set(p - 1, 0.0);
        for (j = nct; j < n; ++j) {
            for (int i7 = 0; i7 < a.rows(); ++i7) {
                u.set(i7, j, 0.0);
            }
            u.set(j, j, 1.0);
        }
        for (k = nct - 1; k >= 0; --k) {
            int i8;
            if (Math.abs(s.get(k, k)) > Matrices.EPS) {
                for (int j3 = k + 1; j3 < n; ++j3) {
                    double t = 0.0;
                    for (i = k; i < a.rows(); ++i) {
                        t += u.get(i, k) * u.get(i, j3);
                    }
                    t = -t / u.get(k, k);
                    for (i = k; i < a.rows(); ++i) {
                        u.updateAt(i, j3, Matrices.asPlusFunction(t * u.get(i, k)));
                    }
                }
                for (i8 = k; i8 < a.rows(); ++i8) {
                    u.updateAt(i8, k, Matrices.INV_FUNCTION);
                }
                u.updateAt(k, k, Matrices.INC_FUNCTION);
                for (i8 = 0; i8 < k - 1; ++i8) {
                    u.set(i8, k, 0.0);
                }
                continue;
            }
            for (i8 = 0; i8 < a.rows(); ++i8) {
                u.set(i8, k, 0.0);
            }
            u.set(k, k, 1.0);
        }
        for (k = n - 1; k >= 0; --k) {
            if (k < nrt & Math.abs(e.get(k)) > Matrices.EPS) {
                for (int j4 = k + 1; j4 < n; ++j4) {
                    double t = 0.0;
                    for (i = k + 1; i < a.columns(); ++i) {
                        t += v.get(i, k) * v.get(i, j4);
                    }
                    t = -t / v.get(k + 1, k);
                    for (i = k + 1; i < a.columns(); ++i) {
                        v.updateAt(i, j4, Matrices.asPlusFunction(t * v.get(i, k)));
                    }
                }
            }
            for (int i9 = 0; i9 < a.columns(); ++i9) {
                v.set(i9, k, 0.0);
            }
            v.set(k, k, 1.0);
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e.get(k3)) <= tiny + eps * (Math.abs(s.get(k3, k3)) + Math.abs(s.get(k3 + 1, k3 + 1))))) continue;
                e.set(k3, 0.0);
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t = (ks != p ? Math.abs(e.get(ks)) : 0.0) + (ks != k3 + 1 ? Math.abs(e.get(ks - 1)) : 0.0);
                    if (!(Math.abs(s.get(ks, ks)) <= tiny + eps * t)) continue;
                    s.set(ks, ks, 0.0);
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i10;
                    double sn;
                    double cs;
                    double t;
                    double f = e.get(p - 2);
                    e.set(p - 2, 0.0);
                    for (int j5 = p - 2; j5 >= k3; --j5) {
                        t = this.hypot(s.get(j5, j5), f);
                        cs = s.get(j5, j5) / t;
                        sn = f / t;
                        s.set(j5, j5, t);
                        if (j5 != k3) {
                            f = -sn * e.get(j5 - 1);
                            e.set(j5 - 1, cs * e.get(j5 - 1));
                        }
                        for (i10 = 0; i10 < a.columns(); ++i10) {
                            t = cs * v.get(i10, j5) + sn * v.get(i10, p - 1);
                            v.set(i10, p - 1, -sn * v.get(i10, j5) + cs * v.get(i10, p - 1));
                            v.set(i10, j5, t);
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i10;
                    double sn;
                    double cs;
                    double t;
                    double f = e.get(k3 - 1);
                    e.set(k3 - 1, 0.0);
                    for (int j6 = k3; j6 < p; ++j6) {
                        t = this.hypot(s.get(j6, j6), f);
                        cs = s.get(j6, j6) / t;
                        sn = f / t;
                        s.set(j6, j6, t);
                        f = -sn * e.get(j6);
                        e.set(j6, cs * e.get(j6));
                        for (i10 = 0; i10 < a.rows(); ++i10) {
                            t = cs * u.get(i10, j6) + sn * u.get(i10, k3 - 1);
                            u.set(i10, k3 - 1, -sn * u.get(i10, j6) + cs * u.get(i10, k3 - 1));
                            u.set(i10, j6, t);
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(s.get(p - 1, p - 1)), Math.abs(s.get(p - 2, p - 2))), Math.abs(e.get(p - 2))), Math.abs(s.get(k3, k3))), Math.abs(e.get(k3)));
                    double sp = s.get(p - 1, p - 1) / scale;
                    double spm1 = s.get(p - 2, p - 2) / scale;
                    double epm1 = e.get(p - 2) / scale;
                    double sk = s.get(k3, k3) / scale;
                    double ek = e.get(k3) / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j7 = k3; j7 < p - 1; ++j7) {
                        int i11;
                        double t = this.hypot(f, g);
                        double cs = f / t;
                        double sn = g / t;
                        if (j7 != k3) {
                            e.set(j7 - 1, t);
                        }
                        f = cs * s.get(j7, j7) + sn * e.get(j7);
                        e.set(j7, cs * e.get(j7) - sn * s.get(j7, j7));
                        g = sn * s.get(j7 + 1, j7 + 1);
                        s.set(j7 + 1, j7 + 1, cs * s.get(j7 + 1, j7 + 1));
                        for (i11 = 0; i11 < a.columns(); ++i11) {
                            t = cs * v.get(i11, j7) + sn * v.get(i11, j7 + 1);
                            v.set(i11, j7 + 1, -sn * v.get(i11, j7) + cs * v.get(i11, j7 + 1));
                            v.set(i11, j7, t);
                        }
                        t = this.hypot(f, g);
                        cs = f / t;
                        sn = g / t;
                        s.set(j7, j7, t);
                        f = cs * e.get(j7) + sn * s.get(j7 + 1, j7 + 1);
                        s.set(j7 + 1, j7 + 1, -sn * e.get(j7) + cs * s.get(j7 + 1, j7 + 1));
                        g = sn * e.get(j7 + 1);
                        e.updateAt(j7 + 1, Vectors.asMulFunction(cs));
                        if (j7 >= a.rows() - 1) continue;
                        for (i11 = 0; i11 < a.rows(); ++i11) {
                            t = cs * u.get(i11, j7) + sn * u.get(i11, j7 + 1);
                            u.set(i11, j7 + 1, -sn * u.get(i11, j7) + cs * u.get(i11, j7 + 1));
                            u.set(i11, j7, t);
                        }
                    }
                    e.set(p - 2, f);
                    ++iter;
                    break;
                }
                case 4: {
                    if (s.get(k3, k3) <= 0.0) {
                        s.set(k3, k3, s.get(k3, k3) < 0.0 ? -s.get(k3, k3) : 0.0);
                        for (int i12 = 0; i12 <= pp; ++i12) {
                            v.updateAt(i12, k3, Matrices.INV_FUNCTION);
                        }
                    }
                    while (k3 < pp && !(s.get(k3, k3) >= s.get(k3 + 1, k3 + 1))) {
                        int i13;
                        double t = s.get(k3, k3);
                        s.set(k3, k3, s.get(k3 + 1, k3 + 1));
                        s.set(k3 + 1, k3 + 1, t);
                        if (k3 < a.columns() - 1) {
                            for (i13 = 0; i13 < a.columns(); ++i13) {
                                t = v.get(i13, k3 + 1);
                                v.set(i13, k3 + 1, v.get(i13, k3));
                                v.set(i13, k3, t);
                            }
                        }
                        if (k3 < a.rows() - 1) {
                            for (i13 = 0; i13 < a.rows(); ++i13) {
                                t = u.get(i13, k3 + 1);
                                u.set(i13, k3 + 1, u.get(i13, k3));
                                u.set(i13, k3, t);
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        return new Matrix[]{u, s.copyOfShape(n, a.columns()), v};
    }

    private double hypot(double a, double b) {
        double result;
        if (Math.abs(a) > Math.abs(b)) {
            result = b / a;
            result = Math.abs(a) * Math.sqrt(1.0 + result * result);
        } else if (b != 0.0) {
            result = a / b;
            result = Math.abs(b) * Math.sqrt(1.0 + result * result);
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return true;
    }
}

