/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.utils;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.RobocodeFileOutputStream;
import robocode.util.Utils;

public class RobocodeTools {
    public static void dumpToFile(String fileName, String value) {
    }

    public static double maxTurn(double velocity) {
        return Math.toRadians(10.0 - 0.75 * Math.abs(velocity));
    }

    public static int sign(double val) {
        return val < 0.0 ? -1 : 1;
    }

    public static double closestBorder(double[] slices, double val) {
        int best = 0;
        int i = 1;
        while (i < slices.length) {
            if (Math.abs(slices[best] - val) > Math.abs(slices[i] - val)) {
                best = i;
            }
            ++i;
        }
        return slices[best];
    }

    public static Object restoreObject(File f) {
        Object o = "FNF";
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(f)));
            o = in.readObject();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public static void saveObject(Object o, File f) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(f)));
            out.writeObject(o);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static double rollingAverage(double n, double oldVal, double entry) {
        return (n * oldVal + entry) / (n + 1.0);
    }

    public static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    public static double angleBetween(Point2D origin, Point2D p1, Point2D p2) {
        return Utils.normalRelativeAngle((double)(RobocodeTools.absoluteBearing((Point2D.Double)origin, (Point2D.Double)p1) - RobocodeTools.absoluteBearing((Point2D.Double)origin, (Point2D.Double)p2)));
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double bindToRange(double value, double min, double max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static int toGF(double angle, double[] bin) {
        return Math.min(Math.max((int)Math.round((angle + 1.0) * (double)(bin.length - 1) / 2.0), 1), bin.length - 1);
    }

    public static int index(double[] slices, double v) {
        int i = 0;
        while (i < slices.length) {
            if (v < slices[i]) {
                return i;
            }
            ++i;
        }
        return slices.length;
    }

    public static double entropy(double[] samples) {
        double sum = 0.0;
        int i = 0;
        while (i < samples.length) {
            sum += samples[i];
            ++i;
        }
        double entropy = 0.0;
        int i2 = 0;
        while (i2 < samples.length) {
            if (samples[i2] != 0.0) {
                entropy += -samples[i2] / sum * Math.log(samples[i2] / sum) / Math.log(2.0);
            }
            ++i2;
        }
        return entropy;
    }

    public static double maxEntropy(int possibleValues) {
        return Math.log(possibleValues) / Math.log(2.0);
    }

    public static double normalizedEntropy(double[] samples) {
        return RobocodeTools.entropy(samples) / RobocodeTools.maxEntropy(samples.length);
    }

    public static double informationGain(double[] samples, double[][] segmentedSamples) {
        int totalSamples = 0;
        int i = 0;
        while (i < samples.length) {
            totalSamples = (int)((double)totalSamples + samples[i]);
            ++i;
        }
        double entropyS = RobocodeTools.entropy(samples);
        int i2 = 0;
        while (i2 < segmentedSamples.length) {
            int segmentSamples = 0;
            int j = 0;
            while (j < segmentedSamples[i2].length) {
                segmentSamples = (int)((double)segmentSamples + segmentedSamples[i2][j]);
                ++j;
            }
            entropyS -= (double)segmentSamples / (double)totalSamples * RobocodeTools.entropy(segmentedSamples[i2]);
            ++i2;
        }
        return entropyS;
    }

    public static boolean isConstant(ArrayList list) {
        return list.get(0).equals(list.get(list.size() - 1));
    }

    public static String intArrayToString(int[] array) {
        String res = "";
        int i = 0;
        while (i < array.length) {
            res = String.valueOf(res) + new Integer(array[i]).toString() + "|";
            ++i;
        }
        return res;
    }

    public static String doubleArrayToString(double[] array) {
        String res = "";
        int i = 0;
        while (i < array.length) {
            res = String.valueOf(res) + new Double(array[i]).toString() + "|";
            ++i;
        }
        return res;
    }

    public static void log(String str) {
        System.out.println(str);
    }

    public static double bulletPower(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static void printMem() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        int totalK = (int)((total + 1023L) / 1024L);
        long free = runtime.freeMemory();
        int usageK = (int)((total - free + 1023L) / 1024L);
        System.out.println("Memory alocated by VM:" + Integer.toString(usageK) + " Kb");
        System.out.println("Free memory in VM:" + Integer.toString(totalK) + " Kb");
    }
}

