/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import simonton.core.Bot;
import simonton.dc.Cluster;
import simonton.dc.Distancer;
import simonton.dc.MyTree;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.GFProbability;
import simonton.waves.Wave;

public class DCWave
extends Wave {
    private Filter filter = new Filter(null);
    public double gfOne;
    public double gfNeg;
    public Cluster.Point clusterPoint;
    public double fireDistance;
    public double hitDistanceAdjust;
    public Iterable cluster;
    public double tolerance;
    public double bestGf;
    public double gfHit;

    public DCWave(Bot source, int orientation, double fireSpeed, double gfZero, double gfOne, double gfNeg, double fireDistance) {
        this.origin = new Location(source);
        this.fireTime = (int)source.getTime() + 1;
        this.angle = gfZero;
        this.orientation = orientation;
        this.gfOne = gfOne;
        this.gfNeg = gfNeg;
        this.fireDistance = fireDistance;
        this.setBulletSpeed(fireSpeed);
    }

    public Collection chooseCluster(int size, MyTree population, Distancer distancer) {
        this.filter.setHome(this);
        return population.buildCluster(this.clusterPoint.location, size, distancer, this.filter).getValues();
    }

    public Collection chooseCluster(int size, Iterable population, boolean filterByBounds, Distancer distancer) {
        Cluster.Filter filter = filterByBounds ? this.filter : Cluster.NON_FILTER;
        Cluster cluster = new Cluster(this.clusterPoint.location, size, distancer, filter);
        for (DCWave wave : population) {
            cluster.consider(wave.clusterPoint);
        }
        if (filterByBounds) {
            Iterator it = cluster.iterator();
            while (it.hasNext()) {
                if (((DCWave)((Cluster.Point)it.next()).value).shootsInBoundsFrom(this)) continue;
                it.remove();
            }
        }
        cluster.trimTo(size);
        return cluster.getValues();
    }

    public double getTolerance() {
        return 2.0 * Math.atan2(20.0, this.fireDistance) / (this.gfOne + this.gfNeg);
    }

    public double getDensityIn(Iterable cluster, double tolerance) {
        double density = 0.0;
        for (DCWave otherWave : cluster) {
            double distance;
            if (otherWave == this || !((distance = Math.abs(this.gfHit - otherWave.gfHit)) <= tolerance)) continue;
            density += 1.0;
        }
        return density;
    }

    public boolean shootsInBoundsFrom(DCWave other) {
        double distance = other.fireDistance;
        distance += this.hitDistanceAdjust * (distance / this.fireDistance);
        double angle = other.getAngleForGf(this.gfHit);
        return Util.botBounds.contains(Util.project((Point2D.Double)other.origin, distance, angle));
    }

    public double getAngleForGf(double gf) {
        if (gf >= 0.0) {
            return this.angle + (double)this.orientation * gf * this.gfOne;
        }
        return this.angle + (double)this.orientation * gf * this.gfNeg;
    }

    public void logHit(Point2D.Double enemyP) {
        double bearing = Util.bearing(this.origin, enemyP);
        double hit = (double)this.orientation * FastMath.normalize(bearing - this.angle);
        this.gfHit = hit >= 0.0 ? hit / this.gfOne : hit / this.gfNeg;
        this.hitDistanceAdjust = this.origin.distance(enemyP) - this.fireDistance;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.BLUE);
        int r = (int)(this.speed * (double)(Util.time - this.fireTime));
        int x = (int)this.origin.x - r;
        int y = (int)this.origin.y - r;
        int d = 2 * r;
        int gfOneDeg = (int)Math.rint(Math.toDegrees(this.getAngleForGf(1.0)));
        int gfNegDeg = (int)Math.rint(Math.toDegrees(this.getAngleForGf(-1.0)));
        int counterGfDeg = this.orientation != 1 ? gfOneDeg : gfNegDeg;
        int gfSweep = Math.abs(FastMath.normalize(gfOneDeg - gfNegDeg));
        g.drawArc(x, y, d, d, counterGfDeg - 90, gfSweep);
        this.paintTickmark(g, this.getAngleForGf(1.0));
        double bestGfAng = this.getAngleForGf(this.bestGf);
        if (this.cluster != null) {
            for (DCWave wave : this.cluster) {
                double hit = this.getAngleForGf(wave.gfHit);
                if (Math.abs(FastMath.normalize(bestGfAng - hit)) <= this.tolerance) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.GREEN);
                }
                this.paintTickmark(g, hit);
            }
        }
    }

    public Object clone() {
        return null;
    }

    @Override
    public GFProbability getMaximumProbability(double gfBotwidth) {
        return null;
    }

    @Override
    public double getProbability(double gf, double gfBotwidth) {
        return 0.0;
    }

    @Override
    public GFProbability[] getMinimumProbabilities(int numPoints, double gfBotwidth) {
        return null;
    }

    private static class Filter
    implements Cluster.Filter {
        private DCWave home;

        public void setHome(DCWave home) {
            this.home = home;
        }

        @Override
        public boolean accepts(Cluster.Point point) {
            return ((DCWave)point.value).shootsInBoundsFrom(this.home);
        }

        private Filter() {
        }

        Filter(Filter filter1) {
            this();
        }
    }
}

