/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800.modules;

import fowl3628800.Coordinate;
import fowl3628800.Enemy;
import fowl3628800.EnemyManager;
import fowl3628800.ModularBot;
import fowl3628800.modules.AntiGravityMovementModule;
import fowl3628800.modules.Module;
import java.awt.Graphics2D;
import java.awt.event.MouseWheelEvent;
import java.util.Iterator;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyEvent;
import robocode.MouseEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class CircularInterceptModule
implements Module {
    private static final double ROBOT_RADIUS = 16.0;
    private static final long TIME_LIMIT = 30L;
    public Coordinate impactPoint = new Coordinate(0.0, 0.0);
    public double bulletHeading_deg;
    protected Coordinate bulletStartingPoint = new Coordinate();
    protected Coordinate targetStartingPoint = new Coordinate();
    public double targetHeading;
    public double targetVelocity;
    public double bulletPower;
    public double angleThreshold;
    public double distance;
    ModularBot bot;
    protected double impactTime;
    protected double angularVelocity_rad_per_sec;
    Enemy target;

    public CircularInterceptModule(ModularBot bot) {
        this.bot = bot;
    }

    public void calculate(double xb, double yb, double xt, double yt, double tHeading, double vt, double bPower, double angularVelocity_deg_per_sec) {
        this.angularVelocity_rad_per_sec = Math.toRadians(angularVelocity_deg_per_sec);
        this.bulletStartingPoint.set(xb, yb);
        this.targetStartingPoint.set(xt, yt);
        this.targetHeading = tHeading;
        this.targetVelocity = vt;
        this.bulletPower = bPower;
        double vb = 20.0 - 3.0 * this.bulletPower;
        this.impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.impactPoint = this.getEstimatedPosition(this.impactTime);
        double dX = this.impactPoint.x - this.bulletStartingPoint.x;
        double dY = this.impactPoint.y - this.bulletStartingPoint.y;
        this.distance = Math.sqrt(dX * dX + dY * dY);
        this.bulletHeading_deg = Math.toDegrees(Math.atan2(dX, dY));
        this.angleThreshold = Math.toDegrees(Math.atan(16.0 / this.distance));
    }

    protected Coordinate getEstimatedPosition(double time) {
        if (Math.abs(this.angularVelocity_rad_per_sec) <= Math.toRadians(0.1)) {
            double x = this.targetStartingPoint.x + this.targetVelocity * time * Math.sin(Math.toRadians(this.targetHeading));
            double y = this.targetStartingPoint.y + this.targetVelocity * time * Math.cos(Math.toRadians(this.targetHeading));
            return new Coordinate(x, y);
        }
        double initialTargetHeading = Math.toRadians(this.targetHeading);
        double finalTargetHeading = initialTargetHeading + this.angularVelocity_rad_per_sec * time;
        double x = this.targetStartingPoint.x - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.cos(finalTargetHeading) - Math.cos(initialTargetHeading));
        double y = this.targetStartingPoint.y - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.sin(initialTargetHeading) - Math.sin(finalTargetHeading));
        return new Coordinate(x, y);
    }

    private double f(double time) {
        double vb = 20.0 - 3.0 * this.bulletPower;
        Coordinate targetPosition = this.getEstimatedPosition(time);
        double dX = targetPosition.x - this.bulletStartingPoint.x;
        double dY = targetPosition.y - this.bulletStartingPoint.y;
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    private double getImpactTime(double t0, double t1, double accuracy) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }

    @Override
    public void preRun() {
    }

    @Override
    public void run() {
        if (this.target == null && EnemyManager.getInstance().getMapSize() != 0) {
            Iterator iterator = EnemyManager.getInstance().getMapIterator();
            this.target = (Enemy)iterator.next();
            double targetScore = AntiGravityMovementModule.getRange(this.target.getPosition().x, this.target.getPosition().y, this.bot.getX(), this.bot.getY());
            targetScore *= (double)(this.bot.getTime() - this.target.getTime() + 1L);
            targetScore *= this.target.getDamageDoneByMe() == 0.0 ? this.target.getDamageDoneToMe() + 1.0 : this.target.getDamageDoneToMe() / this.target.getDamageDoneByMe() + 1.0;
            targetScore *= this.target.getEnergy() / 100.0;
            while (iterator.hasNext()) {
                Enemy tmp = (Enemy)iterator.next();
                if (tmp.isDead() || this.bot.getTime() - tmp.getTime() > 30L) continue;
                double tmpScore = AntiGravityMovementModule.getRange(tmp.getPosition().x, tmp.getPosition().y, this.bot.getX(), this.bot.getY());
                tmpScore *= (double)(this.bot.getTime() - tmp.getTime() + 1L);
                tmpScore *= tmp.getDamageDoneByMe() == 0.0 ? tmp.getDamageDoneToMe() + 1.0 : tmp.getDamageDoneToMe() / tmp.getDamageDoneByMe() + 1.0;
                if (!(targetScore > (tmpScore *= tmp.getEnergy() / 100.0))) continue;
                this.target = tmp;
                targetScore = tmpScore;
            }
        }
        if (this.target != null) {
            this.calculate(this.bot.getX(), this.bot.getY(), this.target.getPosition().x, this.target.getPosition().y, this.target.getHeading(), this.target.getVelocity(), Math.min(400.0 / AntiGravityMovementModule.getRange(this.target.getPosition().x, this.target.getPosition().y, this.bot.getX(), this.bot.getY()), 3.0), this.target.getAngularVelocity());
            double turnAngle = Utils.normalRelativeAngleDegrees((double)(this.bulletHeading_deg - this.bot.getGunHeading()));
            this.bot.setTurnGunRight(turnAngle);
            if (Math.abs(turnAngle) <= this.angleThreshold && this.impactPoint.x > 0.0 && this.impactPoint.x < this.bot.getBattleFieldWidth() && this.impactPoint.y > 0.0 && this.impactPoint.y < this.bot.getBattleFieldHeight() && this.bot.getGunHeat() == 0.0) {
                this.bot.setFire(this.bulletPower);
                this.target = null;
            }
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
    }

    @Override
    public void onDeath(DeathEvent e) {
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent event) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent evnt) {
    }

    @Override
    public void onBulletHit(BulletHitEvent evnt) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent evnt) {
    }

    @Override
    public void onBulletMissed(BulletMissedEvent evnt) {
    }

    @Override
    public void onHitRobot(HitRobotEvent evnt) {
    }

    @Override
    public void onKeyPressed(KeyEvent e) {
    }

    @Override
    public void onKeyReleased(KeyEvent e) {
    }

    @Override
    public void onKeyTyped(KeyEvent e) {
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
    }

    @Override
    public void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void onMouseExited(MouseEvent e) {
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
    }

    @Override
    public void onMousePressed(MouseEvent e) {
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
    }

    @Override
    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
    }

    @Override
    public void onStatus(StatusEvent e) {
    }

    @Override
    public void onWin(WinEvent event) {
    }
}

