/*
SabreuseNano v1.1 by Sheldor.  02/28/2024  248 bytes
stop and go/ramming movement with averaged linear targeting
v1.1 -- rename, targeting, energy management, movement, and radar

Sabre is one of the three forms of modern sport fencing,
along with Epee and Foil.  http://en.wikipedia.org/wiki/Sabre_%28fencing%29

Credits:
Thanks go to the authors of the following bots: 
jk.nano.Machete, nz.jdc.NeophyteSRAL, jk.sheldor.nano.Yatagan
Also, a general thanks to all open source bot authors and contributors to the RoboWiki.

SabreuseNano is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1.
see license here:  http://robowiki.net/wiki/RWPCL
*/

package sheldor.nano;

import robocode.*;
import robocode.util.Utils;

public class SabreuseNano extends AdvancedRobot
{
	//constants
	static final int RAMMING = 0;

	//global variables
	static int direction = 48;
	static double enemyEnergy;
	static double averageVelocity;
	static int rollingDepth = 27;
	static int hasDied;
	
	//En garde!
	public void run()
	{
		setAdjustRadarForGunTurn(true);
		
		//Start spinning radar.
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		//local variables
		int distance100;
		double bearing;
		double absoluteBearing;
		double lead;	
		
		//Stay mostly perpendicular to the enemy, while slowly advancing.  inspired by Yatagan
		setTurnRightRadians(Math.cos((bearing = e.getBearingRadians()) - (getVelocity() / 32)));
				
		//linear targeting with averaged velocities in stop and go mode
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing = getHeadingRadians() + bearing) + 
			(lead = Math.asin((averageVelocity = ((averageVelocity * rollingDepth)
			+ (e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing))) / (1 + rollingDepth))
			/ 14)) - getGunHeadingRadians()));
			
		//stop and go movement
		if ((enemyEnergy - (enemyEnergy = e.getEnergy())) > -(distance100 = (100 / (int)e.getDistance())))
		{
			setAhead(direction);
		}			
		
		//energy management based on distance and enemy energy
		setFire(Math.min(enemyEnergy / 4, 2 + distance100));

		//same linear lead used for ramming
		if (rollingDepth == RAMMING)
		{
			setTurnRightRadians(Math.tan(bearing += lead));
			setAhead(Math.cos(bearing) / 0);
		}		
		
		//radar
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	}	

	public void onBulletHit (BulletHitEvent e)
	{		
		//Adjust the enemy energy variable when the bot hits the enemy.
		//This makes a big difference against linear targeting.
		enemyEnergy -= 10;
	}

	public void onDeath(DeathEvent e)
	{
		//If the stop and go movement loses twice in the first four rounds, switch to ramming movement.
		if (getRoundNum() < hasDied)
		{
			rollingDepth = RAMMING;
		}
		hasDied = 4;
	}
	
	public void onHitWall(HitWallEvent e)
	{
		//Reverse movement direction when the bot hits a wall.
		direction = -direction;
	}
}																																																						