package sch;


/**
 * Contains all constants used all-over the Bot
 */

public interface Constants {

	/**
	 * Target bounding-box dimension
	 */
	static final double TARGET_RADIUS = 20;
	
	/**
	 * Greek PI constant: 3.1457...
	 */
	static final double PI = Math.PI;
	
	/**
	 * Maximum distance between two robot<br>Bigger then the bigger distance to be precise
	 */
	static final double MAX_DISTANCE = 10000.0;

	/**
	 * Type of debugging info
	 */
	static final int DEBUG_EVENT_NOTIFICATION = 1;
	static final int DEBUG_BOT_MOVEMENT = 2;
	static final int DEBUG_TARGET_SELECTION = 4;
	static final int DEBUG_STATS = 8;
	static final int DEBUG_OBJECT_CREATION = 16;
	static final int DEBUG_GUN_MOVEMENT = 32;
	static final int DEBUG_RADAR_MOVEMENT = 64;
	static final int DEBUG_FIREING = 128;
	static final int DEBUG_OBJECT_INIT = 256;
	static final int DEBUG_AIMING_CALC = 512;
	static final int DEBUG_BRIEF_STATS = 1024;
	static final int DEBUG_IO = 2048;
	static final int DEBUG_INTECEPT_SELECTION = 4096;
	static final int DEBUG_STRATEGY_SELECTION = 8192;

	/**
	 * Type of debugging is active
	 */
	static final int DEBUG = DEBUG_STRATEGY_SELECTION;

	/**
	 * Max movement amount
	 */
	static final double MAX_MOVEMENT_AMOUNT = 500.0;
	
	/**
	 * Min movement amount
	 */
	static final double MIN_MOVEMENT_AMOUNT = 150.0;
	
	/**
	 * Max movement speed
	 */
	static final double MAX_MOVEMENT_SPEED = 8.0;

	/**
	 * Min movement speed
	 */
	static final double MIN_MOVEMENT_SPEED = 5.0;

	/**
	 * Max movement time
	 */
	static final double MAX_TIME_INTERVAL = 30.0;

	/**
	 * Min movement time
	 */
	static final double MIN_TIME_INTERVAL = 5.0;

	/**
	 * Left alignment for text
	 */
	static final int ALIGN_LEFT = 1;

	/**
	 * Center alignment for text
	 */	
	static final int ALIGN_CENTER = 2;

	/**
	 * Right alignment for text
	 */
	static final int ALIGN_RIGHT = 3;

	/**
	 * Max time for a movement to be circolar
	 */
	 static final double ANG_SPEED_SENSIBLE_TIME = 15;

	/**
	 * Accuracy for iterative intercept algoritm  
	 */
	 static final double INTERCEPT_ACCURACY = 0.1;

	 /**
	  * Max number of iteration for intercept algoritm
	  */
	 static final int INTERCEPT_ITERATIONS = 10;

	 /**
	  * Bot Stats file version
	  */
	 static final int BOT_STATS_FILE_VERSION = 2;

	 /**
	  * Limit for using circular targeting instead of linear one
	  */
	 static double ANG_SPEED_LIMIT = 0.0001;

	 /**
	  * Firepower constant
	  */	 
	 static double FIRING_DISTANCE_CONST = 400;

	 /**
	  * Number of intercept methods
	  */
	static int INTERCEPT_NUM=4;
	 
	 /**
	  * Min number of shots in order to have a sample of shots
	  */	 
	static int MIN_SAMPLING_SHOTS=20;
	
	
	static double ENEMY_GRAVITY_FACTOR=-1000.0;
	
	static double TARGET_GRAVITY_FACTOR=-200.0;
	
	static double RANDOM_POINT_CHANGE_INTERVAL=10.0;
	
	static double RANDOM_POINT_MIN_POWER=-1000.0;
	
	static double RANDOM_POINT_MAX_POWER=1000.0;
	
	static int RANDOM_POINT_NUM=4;
	
	static double BOT_GRAV_POINT=2.0;
	
	static double RANDOM_GRAV_POINT=1.5;
	
	static double WALL_PROXIMITY=80.0;
	
	static double CENTER_GRAV_POINT=3;
	
	static double CENTER_DENSITY_GRAVITY_FACTOR=300000;
}