package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.SpareParts;
import kawigi.spare.util.*;
import java.util.Vector;
/**
 * GunSelector - selects guns for one opponent
 */
public class GunSelector extends PartSelector
{
	private Gun[] guns;
	private Averager[][] vbulletAveragers;
	private int index;
	private int shotcount;
	private boolean alltested;
	private Vector vbullets;
	private AdvancedRobot robot;
	private TargetSelector targetter;
	private boolean noshoot;
	
	public GunSelector(AdvancedRobot robot, TargetSelector targetter, EnemyManager enemies)
	{
		this.robot = robot;
		noshoot = false;
		guns = new Gun[7];
		guns[0] = new IterativePatternMatcherGun(robot, enemies);
		guns[1] = new IterativeCircularPredictingGun(robot);
		guns[2] = new DirectAimGun(robot);
		guns[3] = new LinearPredictingGun(robot);
		guns[4] = new RandomRangeGun(robot);
		guns[5] = new ProbablisticGun(robot, enemies);
		guns[6] = new ShortSightedCircularPredictingGun(robot);
		vbulletAveragers = new Averager[robot.getOthers()][guns.length];
		for (int i=0; i<vbulletAveragers.length; i++)
			for (int j=0; j<vbulletAveragers[i].length; j++)
				vbulletAveragers[i][j] = new Averager(50);
		alltested = false;
		vbullets = new Vector();
		this.targetter = targetter;
		targetter.giveGunSelector(this);
	}
	
	public void onEvent(Event e)
	{
		for (int i=0; i<guns.length; i++)
			guns[i].onEvent(e);
	}
	
	public void setAction()
	{
		EnemyManager enemies = SpareParts.enemies;
		long ctime = robot.getTime();
		for (int i=0; i<vbullets.size(); i++)
		{
			ChooserBullet b = (ChooserBullet)vbullets.elementAt(i);
			EnemyState enemy = enemies.getEnemy(b.getName());
			if (enemy == null)
			{
				vbullets.removeElementAt(i);
				i--;
				continue;
			}
			int hitresult = b.hit(enemy.getX(), enemy.getY(), ctime);
			if (hitresult == ChooserBullet.HIT)
				logVirtualHit(b.getSource(), b.getPower(), b.getName());
			else if (hitresult == ChooserBullet.MISS)
				logVirtualMiss(b.getSource(), b.getPower(), b.getName());
			else
				continue;
			vbullets.removeElementAt(i);
			i--;
		}
		for (int i=0; i < enemies.countEnemies(); i++)
		{
			EnemyState enemy = enemies.getEnemyAt(i);
			if (enemy == null || enemy.isDead() || enemy.getTimeElapsed(ctime) > 20)
				continue;
			for (int j=0; j < guns.length; j++)
			{
				ChooserBullet bullet = guns[j].getVirtualBullet(enemy);
				vbullets.add(bullet);
			}
		}
		selectGun();
		if (noshoot)
			return;
		ChooserBullet realBullet = guns[index].getVirtualBullet(((TargetChooser)targetter.getSelectedPart()).chooseTarget());
		if (realBullet != null)
		{
			realBullet.aim(robot, ((TargetChooser)targetter.getSelectedPart()).chooseTarget());
			if (robot.getGunHeat() == 0)
			{
				robot.waitFor(new GunTurnCompleteCondition(robot));
				robot.setFire(realBullet.getPower());
			}
		}
	}
	
	private void selectGun()
	{
		index = 0;
		EnemyState target = ((TargetChooser)targetter.getSelectedPart()).chooseTarget();
		if (target != null)
			noshoot = (target.getEnergy() < 2 && robot.getOthers() == 1);
		int i2 = SpareParts.enemies.indexOf(target);
		if (i2 >= 0)
			for (int i=1; i<guns.length; i++)
				if (vbulletAveragers[i2][i].recentAverage() > vbulletAveragers[i2][index].recentAverage())
					index = i;
	}
	
	//returns the name of the robot that has the best gun rating for its best gun
	public String bestGunRating()
	{
		int i1 = 0;
		int i2 = 0;
		for (int i=0; i<vbulletAveragers.length; i++)
			for (int j=0; j<vbulletAveragers[i].length; j++)
				if (vbulletAveragers[i][j].recentAverage() > vbulletAveragers[i1][i2].recentAverage())
				{
					i1 = i;
					i2 = j;
				}
		EnemyState enemy = SpareParts.enemies.getEnemyAt(i1);
		if (enemy == null)
			return null;
		else
			return enemy.getName();
	}
	
	public Part getSelectedPart()
	{
		return guns[index];	
	}
	
	private void logVirtualHit(Gun gun, double power, String name)
	{
		for (int i=0; i<guns.length; i++)
			if (guns[i] == gun)
			{
				for (int j=0; j<SpareParts.enemies.countEnemies(); j++)
					if (SpareParts.enemies.getEnemyAt(j) != null && SpareParts.enemies.getEnemyAt(j).getName().equals(name))
						vbulletAveragers[j][i].addEntry(power*2);
			}
	}
	
	private void logVirtualMiss(Gun gun, double power, String name)
	{
		for (int i=0; i<guns.length; i++)
			if (guns[i] == gun)
			{
				for (int j=0; j<SpareParts.enemies.countEnemies(); j++)
					if (SpareParts.enemies.getEnemyAt(j) != null && SpareParts.enemies.getEnemyAt(j).getName().equals(name))
						vbulletAveragers[j][i].addEntry(-power);
			}
	}
}
