package hamilton;

import robocode.*;

public class MovementManager
{
	AdvancedRobot r;
	TargetManager t;
	FieldManager f;
	
	int FORWARD = 1;
	int REVERSE = -1;
	int DIRECTION = FORWARD;
	
	int count;
	
	public MovementManager(AdvancedRobot someR, TargetManager someT, FieldManager someF)
	{
		r = someR;
		t = someT;
		f = someF;
	}
	
	public void doMelee()
	{
		Coordinate robotCoordinates = new Coordinate(r.getX(), r.getY());
		
		ForceVector force = f.getForceOnRobot(robotCoordinates);
		
		//System.out.println(r.getRoundNum() + ", " + r.getTime() + ": " + force.getMagnitude());
				
		Coordinate goalCoordinates = robotCoordinates.add(new Coordinate(force.getForceX(), force.getForceY()));
		
		moveTo(goalCoordinates);
	}
		
	public void moveTo(Coordinate c)
	{
		Coordinate robotCoordinates = new Coordinate (r.getX(), r.getY());
		double newHeading = robotCoordinates.absoluteBearingTo(c);
		double distance = robotCoordinates.distanceFrom(c);
		
		turnTo(newHeading);
		r.setAhead(distance * DIRECTION * 1000);
	}
	
	public void turnTo(double someHeadingRadians)
	{
		double turnAmount = someHeadingRadians - r.getHeadingRadians();
			
		if ( (Math.abs(turnAmount) > (Math.PI / 2)) )
		{
			someHeadingRadians += Math.PI;
			turnAmount = Calculator.relativeAngle(someHeadingRadians - r.getHeadingRadians());
			DIRECTION = REVERSE;
		}
		
		else DIRECTION = FORWARD;
		
		if (r.getTurnRemainingRadians() > (Math.PI / 8)) r.setMaxVelocity(8);
		else r.setMaxVelocity(8);
		
		r.setTurnRightRadians(turnAmount);
	}
		
}
