package abud;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

import robocode.*;

/**
 * Comments
 */
public class ThirdRobo extends BaseRobo {
	private EnemyInfo near = null;
	/**
	 * 
	 */
	public void run() {
		setColors(Color.GREEN, Color.RED, Color.BLUE);
		while (true) {
			if (enemyMap.isEmpty() || enemyMap.size()>1){
				setTurnRadarRight(360);
			} else {
				Enumeration enum = enemyMap.elements();
				EnemyInfo i = (EnemyInfo)enum.nextElement();
				setRadarHeadingAbsolute(i.getAproxX(getTime(),this),i.getAproxY(getTime(),this));
				waitFor(new RadarTurnCompleteCondition(this));
				setTurnRadarRight(-20);
				waitFor(new RadarTurnCompleteCondition(this));
				setTurnRadarRight(40);
				waitFor(new RadarTurnCompleteCondition(this));
			}
			if (notHitWall(180)) {
				setAhead(2000);
			}
			execute();
			if (!enemyMap.isEmpty()) {
				fireNearestEnemy();
			}
		}
	}
	
	
	private void fireNearestEnemy(){
		Enumeration enum = enemyMap.elements();
		String minEnemy = null;
		double minDist = 10000000;
		
		while (enum.hasMoreElements()) {
			EnemyInfo i = (EnemyInfo)enum.nextElement();
			double dis = i.getDistance(this);
			if (dis < minDist){
				minEnemy = i.getName();
				minDist = dis;
			}
		}
		EnemyInfo near = (EnemyInfo)enemyMap.get(minEnemy);
		if (near.getVelocity()==0) {
			setGunHeadingAbsolute(near.getX(), near.getY());
		} else {
			setGunHeadingAbsolute(near.getAproxX(getTime(),this), near.getAproxY(getTime(),this));
		}
		if (near.getVelocity()==0){
			fire(3);
		} else if (minDist<200) {
			fire(2);
		} else if (minDist<300) {
			fire(1);
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if (isTeammate(e.getName())){
			return;
		} else {
			EnemyInfo enemy = new EnemyInfo(this, e);
			enemyMap.put(e.getName(), enemy);
			try {
				broadcastMessage(enemyMap);
			} catch (Exception ex) {
				out.println(ex);
			}
		}
	}
	
	public void onMessageReceived(MessageEvent e){
		enemyMap = (Hashtable)e.getMessage();
	}	
	
	public void onRobotDeath(RobotDeathEvent e){
		enemyMap.remove(e.getName());
	}
	
	public boolean notHitWall(int jarak){
		boolean atas = false;
		boolean bawah = false;
		boolean kiri = false;
		boolean kanan = false;
		
		if (getY()< jarak)	bawah = true;
		if (getX()< jarak)	kiri = true;
		if (getBattleFieldHeight() - getY() < jarak) atas = true;
		if (getBattleFieldWidth() - getX() < jarak)	kanan = true;
		
		if (atas || kiri || bawah || kanan) {
			boolean kiriatas = false;
			boolean kananatas = false;
			boolean kiribawah = false;
			boolean kananbawah = false;
		
			if (getHeading()<90) kananatas = true;
			if (getHeading()>=90 && getHeading()<180) kananbawah = true;
			if (getHeading()>=180 && getHeading()<270) kiribawah = true;
			if (getHeading()>=270) kiriatas = true;
		
			if (atas && kananatas) setTurnRight(90);
			else if (atas && kiriatas) setTurnLeft(90);
			else if (kanan && kananatas) setTurnLeft(90);
			else if (kanan && kananbawah) setTurnRight(90);
			else if (bawah && kananbawah) setTurnLeft(90);
			else if (bawah && kiribawah) setTurnRight(90);
			else if (kiri && kiriatas) setTurnRight(90);
			else if (kiri && kiribawah) setTurnLeft(90);
			
			if (atas && kananatas || atas && kiriatas || bawah && kananbawah || bawah && kiribawah || kiri && kiriatas || kiri && kiribawah || kanan && kananatas || kanan && kananbawah)
				return false;
			else
				return true;
		} else
			return true;
	}
	
	public void onHitRobot(HitRobotEvent e) {
		setBack(200);
		setTurnLeft(90);
	}
}
