package amk;
import robocode.*;
import java.awt.geom.*;
import java.io.*;
import java.util.zip.*;
import java.awt.Color;
import java.util.Random;

public class ChumbaMini extends AdvancedRobot
{    
    // Movement Variables
    static Point2D robotLocation = new Point2D.Double(100,100);
    static Point2D enemyLocation = new Point2D.Double(400,400);
    static double enemyDistance = 400;
    static double enemyAbsoluteBearing = 180;
    static double movementLateralAngle = 0.2;
    static double timeSinceLastScan = 0;
    static double lastEnemyEnergy = 100;
    
    // Gun Variables
    private static Rectangle2D.Double field;
    private static int statBuffer[][][][][][];
    private static String targetName;
    private static int hits;
    private int direction = 1;
    private int eDirection = 0;
    private double  eDelta, eVelocity, eHeading;
    private boolean flatten = (hits > 2);
    private double eLastShot = 3;
    private static int ticksSinceReverse = 0;
    int lastLatVelIndex = 0;
    boolean targetAcquired = false;
    
    public void run() {
        field = new Rectangle2D.Double(18, 18, getBattleFieldWidth() - 36, getBattleFieldHeight() - 36);
        do { 
            setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            timeSinceLastScan++;
            double radarOffset = Double.POSITIVE_INFINITY;
            if(timeSinceLastScan < 3) {
                radarOffset = robocode.util.Utils.normalRelativeAngle(getRadarHeadingRadians() - enemyAbsoluteBearing);
                radarOffset += (radarOffset > 0 ? 1 : -1) * 0.02;
            }
            setTurnRadarLeftRadians(radarOffset);
            if(targetAcquired)
                fire(3);
            else
                execute();
        } while(true);
    }
    
    static private Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }
    
    static private Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
                                   sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        targetAcquired = true;
        robotLocation = new Point2D.Double(getX(), getY());
        enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
        
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            movementLateralAngle *= -1;
        }
        Point2D robotDestination = null;
        double tries = 0;
        do {
            robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
                                                enemyDistance * (1.1 - tries / 100.0), enemyLocation);
            tries++;
        } while (tries < 100 && !new RoundRectangle2D.Double(30, 30, getBattleFieldWidth() - 60, getBattleFieldHeight() - 60, 75, 75).contains(robotDestination));
        
        double angle = robocode.util.Utils.normalRelativeAngle(absoluteBearing(robotLocation, robotDestination) - getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(robotDestination) * (angle == turnAngle ? 1 : -1));
        // Hit the brake pedal hard if we need to turn sharply
        setMaxVelocity(Math.abs(getTurnRemaining()) > 33 ? 0 : 8);
        
        aim(e);
        
        setTurnRadarLeftRadians(getRadarTurnRemaining());
        
        timeSinceLastScan = 0;
        
        double delta = e.getEnergy() - lastEnemyEnergy;
        if((1 <= delta) & (delta <= 3)) {
            setMaxVelocity(8);
            turnLeft(90 - e.getBearing());
        }
    }
    
    public void onRobotDeath(RobotDeathEvent e) {
        targetAcquired = false;
    }
    
    public void aim(ScannedRobotEvent e) {
        targetName = e.getName();
        eHeading = e.getHeadingRadians();
        if (Math.abs(eVelocity) > Math.abs(eVelocity = e.getVelocity())) {
            ticksSinceReverse = 0;
        }
        double latVel = (eVelocity) * Math.sin(eHeading - enemyAbsoluteBearing);
        
        if (latVel != 0) {
            eDirection = (int)(Math.abs(latVel) / latVel);
        }
        
        int distanceIndex = (int)Math.min(4, enemyDistance / 180D);
        
        if ((eDelta = lastEnemyEnergy - (lastEnemyEnergy = e.getEnergy())) > 0 && eDelta <= 3) {
            eLastShot = eDelta;
        }
        
        double distDelta = 0.02 + Math.PI/2 + (e.getDistance() > 400 ? -.1 : .5);
        double theta = 0.5952*11/enemyDistance;
        if ( (Math.random() > Math.pow(theta, theta)  && flatten)|| distDelta < Math.PI/4 || (distDelta < Math.PI/3 && enemyDistance < 400)){
            if ((Math.random() > Math.pow(theta, theta) && flatten))
                direction = -direction;
        }
        
        if (statBuffer == null) {
            statBuffer = (int[][][][][][]) readObject(targetName);
        }
        
        int stats[] = statBuffer[getOutIndex()][lastLatVelIndex][(lastLatVelIndex = ((int)Math.abs(latVel) / 2))][Math.min(4, ++ticksSinceReverse/10)][distanceIndex];
        
        int bestIndex = (int)((23D -1) / 2);
        for (int i = 0; i < stats.length ; i++) {
            if (stats[i] > stats[bestIndex])
                bestIndex = i;
        }
        
        setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() + ((bestIndex - ((23D -1) / 2)) / ((23D -1) / 2) * Math.asin(8.0 / 11) * eDirection)));
        
        Wave w = new Wave();
        w.guessFactors = stats;
        w.wDirection = eDirection;
        w.bulletVelocity = 11;
        w.distance += w.bulletVelocity;
        w.bulletOrigin = new Point2D.Double(getX(), getY());
        w.startingTargetBearing = enemyAbsoluteBearing;
        w.maxAngle = Math.asin(8.0 / w.bulletVelocity);
        addCustomEvent(w);
    }
    
    private int getOutIndex() {
        int i = 0;
        do {
            
        } while (++i < 4 && field.contains((enemyLocation.getX() + (Math.sin(eHeading)* (45.0 * i) * eDirection)), (enemyLocation.getY() + (Math.cos(eHeading) * (45.0 * i) * eDirection))));
        return (i);
    }
    
    static public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    public void onWin(WinEvent e) {
        saveData();
    }

    public void onDeath(DeathEvent e) {
        saveData();
    }
    
    Object readObject(String fileName) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(fileName))));
            return ois.readObject();
        } catch (Exception e) {
            return new int[5][5][5][5][5][(int)23D];
        }
    }
    
    public void saveData() {
        try {
            ObjectOutputStream  oos = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(targetName))));
            oos.writeObject(statBuffer);
        } catch (IOException ex) {
        }
    }
    
    // Jekyl's implementation of a Wave (mostly)
    public class Wave extends Condition {
        public Point2D.Double bulletOrigin;
        public double bulletVelocity;
        public double distance;
        public double startingTargetBearing;
        public double maxAngle;
        public int[] guessFactors;
        public int wDirection;
        
        public boolean test() {
            if ((distance+=bulletVelocity) >= bulletOrigin.distance(enemyLocation.getX(),enemyLocation.getY()) - 18) {
                double currentBearingFromShotOrigin = Math.atan2(enemyLocation.getX() - bulletOrigin.getX(), enemyLocation.getY() - bulletOrigin.getY());
                guessFactors[(int)Math.max(0, Math.min((23D - 1),(int) Math.round(((((robocode.util.Utils.normalRelativeAngle(currentBearingFromShotOrigin - startingTargetBearing) * wDirection) / maxAngle) * ((23D -1) / 2)) + ((23D -1) / 2)))))]++;
                removeCustomEvent(this);
            }
            return false;
        }
    }  //End Wave
}