package ags.rougedc.painters;

import java.awt.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;

public class GraphPainter {
    
    
    public static void paintEnemyProfile(Graphics2D g, int x, int y, int height, int width, ags.rougedc.gun.FlammeRouge gun) {
        int xoff = x+1;
        int yoff = y+1+10;
        
        width -= xoff + x-1;
        height -= yoff + y-1;
        
        final Polygon poly = gun.getProfileGraph(xoff, yoff, width, height);
        
        g.setColor(Color.RED);
        double nb = width*((-1.0/1.2+1.0)/2.0);
        g.drawLine(xoff+(int)nb, yoff, xoff+(int)nb, yoff+height);
        g.drawString("-1.0", xoff+(int)nb-7, y);
        double pb = width*((1.0/1.2+1.0)/2.0);
        g.drawLine(xoff+(int)pb, yoff, xoff+(int)pb, yoff+height);
        g.drawString("+1.0", xoff+(int)pb-7, y);
        
        if (poly != null) {
            g.setColor(new Color(255, 255, 0, 80));
            g.fillPolygon(poly);
            g.setColor(Color.YELLOW);
            g.drawPolygon(poly);
        }
        
        g.setColor(Color.WHITE);
        g.drawRect(xoff-1, yoff-1, width+2, height+2);
        g.drawString("Enemy Movement Profile", xoff+(int)(width*0.5)-60, y);
        
    }
}
