package bvh.loki;
import robocode.*;
import java.awt.Color;
import java.util.*;

/**
 * Loki - a robot by Bart van Hest
 *
 *    "Loki was the Norse god who personified mischief, deceit,
 *     greed, temptation, malice, and similar notions. He was
 *     one of the Aesir (the principal gods), but the cause of
 *     dissension among the gods, and the slayer of Balder.
 *
 * Wijzigingshistorie v0.5 (04-11-2002):
 *  - Radar van Tyr overgenomen (smaller en verliest doel minder snel uit oog bij 1-vs-1)
 *
 * Wijzigingshistorie v0.4 (25-08-2002):
 *  - hash-tabel verwijderd
 *  - voorkeur voor hoeken toegevoegd.
 *  - inclusief circulaire interpolatie van positie tegenstander obv zijn verschil in heading
 *
 * Wijzigingshistorie v0.3 (11-08-2002):
 *  - toevoeging van hash-tabel voor bijhouden doel-data
 *
 * Wijzigingshistorie v0.2 (08-08-2002):
 *  - lineaire interpolatie van positie tegenstander obv zijn snelheid en heading
 *
 * Wijzigingshistorie v0.1 (03-08-2002):
 *  - alle hoeken omgezet naar radialen
 *  - schattingsmethode toegevoegd voor draaicirkel kanon
 *
 */
public class Loki extends AdvancedRobot implements Constanten {
/**
* run: Loki's hoofdroutine:
*/
   public void run() {       // initialisatie:
      xMax = getBattleFieldWidth();  xM = xMax/2D; // bepaal info over strijdperk
      yMax = getBattleFieldHeight(); yM = yMax/2D;

      mijnDoel = new Doel(); // doel alvast aanmaken en initieren; ik vind er wel een!

      setColors(Color.blue,Color.blue,Color.yellow); // mijn strijdkleuren
      setAdjustGunForRobotTurn(adjustGun);
      setAdjustRadarForGunTurn(adjustRadar);
      resetBot();

      while(true) {     // levensloop:
         navigatie();   // verplaats robot:
         stuurRadar();  // en stuur radar aan:
         stuurKannon(); // en stuur kanon aan:
         vuurKannon();  // en geef vuur:
         execute();
      } // einde levensloop
   } // einde run-method

/**
 * onScannedRobot: What to do when you see another robot
 * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
 */
   public void onScannedRobot(ScannedRobotEvent e) {
      if (mijnDoel.naam == null // selecteer doel indien nog geen ander doel gevonden en in hoek gekropen
      ||  mijnDoel.naam == e.getName()      // update doel indien al eerder gevonden
      || (mijnDoel.afstand > e.getDistance() && mijnDoel.e > e.getEnergy()) // selecteer gunstiger doel
      || e.getEnergy() < 7D) { // selecteer zwak doel

         doelGevonden              = true;     // leg informatie over doel vast:
         mijnDoel.naam             = e.getName();
         mijnDoel.scanTijd_o       = mijnDoel.scanTijd;
         mijnDoel.scanTijd         = getTime();
         mijnDoel.afstand_o        = mijnDoel.afstand;
         mijnDoel.afstand          = e.getDistance();
         mijnDoel.richting_o       = mijnDoel.richting;         // voorgaande waarden opslaan
         mijnDoel.richting         = getHeadingRadians() + e.getBearingRadians();// nieuwe waarden opslaan
         mijnDoel.bewegingsrichting_o    = mijnDoel.bewegingsrichting;
         mijnDoel.bewegingsrichting      = e.getHeadingRadians();
         mijnDoel.deltaBewegingsrichting = mijnDoel.bewegingsrichting - mijnDoel.bewegingsrichting_o
                                           /(mijnDoel.scanTijd - mijnDoel.scanTijd_o);
         mijnDoel.e_o              = mijnDoel.e;
         mijnDoel.e                = e.getEnergy();
         mijnDoel.v_o              = mijnDoel.v;
         mijnDoel.v                = e.getVelocity();
         mijnDoel.vMean            = 0.8 * mijnDoel.vMean + 0.2 * mijnDoel.v; // middelen over voorafgaande snelheden
         mijnDoel.vRotatie         = NormaliseBearing( mijnDoel.bewegingsrichting - mijnDoel.bewegingsrichting_o) / (double)(mijnDoel.scanTijd - mijnDoel.scanTijd_o);
         mijnDoel.x                = mijnDoel.setX( getX() );
         mijnDoel.y                = mijnDoel.setY( getY() );

out.println("doel gevonden:"+mijnDoel.naam);
         if ( doelGevonden && getOthers() < standaardAantalBots)  {
            if (mijnDoel.e > 2D * getEnergy())
               bewegingsToestand = VERDEDIGING;
            else
               bewegingsToestand = AANVAL;
         } else
               bewegingsToestand = ZOEKHOEK;
      }
      return;
   }

/**
* onHitByBullet: What to do when you're hit by a bullet.
*/
   public void onHitByBullet(HitByBulletEvent e) {
/*
      botDraaicirkel = NormaliseBearing(e.getBearingRadians()-Math.PI/2);
      setTurnRightRadians( botDraaicirkel );
*/
   }

/**
* onHitRobot: What to do when you're hit by a robot.
*/
   public void onHitRobot(HitRobotEvent e) {
      setBack(45);
      kanonDraaicircel = NormaliseBearing(getHeadingRadians() + e.getBearingRadians() - getGunHeadingRadians());
      kanonVuurkracht = 10D*standaardVuurkracht;
      turnGunRightRadians(kanonDraaicircel);
      fire(kanonVuurkracht);
   }

/**
* onRobotDeath: Bewegingstoestand resetten wanneer doel is vernietigd.
*/
   public void onRobotDeath(RobotDeathEvent e) {
      if  (e.getName() == mijnDoel.naam ) resetBot();
   }

/**
* onHitWall:  keer richting om bij borsing met muur (botsing kost energie afhankelijk van botsingssnelheid!!!)
*/
   public void onHitWall(HitWallEvent e) {
      if (bewegingsToestand != INHOEK) {
         if (getX()<35) botDraaicirkel = Math.PI/4D - getHeadingRadians() ;
         if (getX()>(xMax-35)) botDraaicirkel = -Math.PI/4D - getHeadingRadians() ;
         if (getY()<35) botDraaicirkel = -Math.PI/2D - getHeadingRadians() ;
         if (getY()>(yMax-35)) botDraaicirkel = Math.PI/2D - getHeadingRadians() ;

         botDraaicirkel = NormaliseBearing(botDraaicirkel);
         botLoopafstand = 100;
      } else {
         voorwaards = -voorwaards;
         ahead(voorwaards * botLoopafstand);
      }
   }

/**
*
*/
   public void navigatie() {
      if ( (getTime()-mijnDoel.scanTijd) > CountReset) resetBot(); // is een reset nodig?

         switch (bewegingsToestand) {
           case ZOEKHOEK:    beweegRandom(); break;//zoekHoek(); break;
           case AANVAL:      valAan();   break;
           case VERDEDIGING: verdedig(); break;
           case ONBEPAALD:   beweegRandom(); break;
           case KLOON:       kloonBeweging();
         }

         voorkomBotsingMetWanden();
         setAhead( voorwaards * botLoopafstand );
         setTurnRightRadians( botDraaicirkel );

System.out.println("Toestand= "+bewegingsToestand +"    ; botRichting= "+(getHeadingRadians()+botDraaicirkel)*180/Math.PI + ", loopAfstand= "+voorwaards*botLoopafstand);

   }

/**
*
*/
   public void zoekHoek() {
      if (bewegingsToestand != ZOEKHOEK) { // bepaal de dichtstbijzijnde hoek
         bewegingsToestand = ZOEKHOEK;
         if (getX() > xM) {
            if (getY() > yM) {
               xD     = xMax-hoekAfstand; // hoek 1: NO
               yD     = yMax-hoekAfstand;
               alphaD = -Math.PI/4;
            } else {
               xD     = xMax-hoekAfstand; // hoek 2: ZO
               yD     = hoekAfstand;
               alphaD = Math.PI/4;
            }
         } else {
            if (getY() < yM) {
               xD     = hoekAfstand;      // hoek 3: ZW
               yD     = hoekAfstand;
               alphaD = -Math.PI/4;
            } else {
               xD     = hoekAfstand;      // hoek 4: NW
               yD     = yMax-hoekAfstand;
               alphaD = Math.PI/4;
            }
         }
      } // einde bepaal de dichtstbijzijnde hoek
      if (bewegingsToestand == ZOEKHOEK) {
         double xB = getX(), yB = getY();
         if ( Math.abs(xD-xB)>delta || Math.abs(yD-yB)>delta ) {
            botDraaicirkel = NormaliseBearing(Math.atan2((xD-xB),(yD-yB)) - getHeadingRadians());
//System.out.println("DraaiRichting="+botDraaicirkel*180/Math.PI );
            botLoopafstand         = Math.sqrt((xD-xB)*(xD-xB) + (yD-yB)*(yD-yB));
            turnRightRadians( botDraaicirkel );
         } else {
            bewegingsToestand = INHOEK;
            botDraaicirkel = NormaliseBearing(alphaD - getHeadingRadians());
            if ( botLoopafstand != standaardLoopafstand ) botLoopafstand = standaardLoopafstand; // vaste stap grootte.
            turnRightRadians( botDraaicirkel );
            setAhead( botLoopafstand );
/*
            if ( Math.abs(getTurnRemaining()) > delta )     botDraaicirkel = alphaD - getHeadingRadians();
            else                                            botDraaicirkel = 0;
*/
            if ( Math.abs(getDistanceRemaining()) < delta ) {
               voorwaards     = -voorwaards;
               botLoopafstand = standaardLoopafstand;
            } else {
               botLoopafstand = getDistanceRemaining();
            }
         }
      }
   } // einde method zoekHoek()

   public void valAan() {
      if ( mijnDoel.afstand <= 1.5D*naderingsAfstand ) {
         botDraaicirkel = Math.acos(Math.sin(mijnDoel.richting)); // draai 90 graden tov tegenstander
         botLoopafstand = standaardLoopafstand;
      } else {

         botDraaicirkel = NormaliseBearing(mijnDoel.richting - getHeadingRadians());
         botLoopafstand = mijnDoel.afstand;
         voorwaards     = 1;
      }
   } // einde method valAan()

   public void verdedig() {
      botDraaicirkel = NormaliseBearing(mijnDoel.richting - getHeadingRadians()-Math.PI);
      botLoopafstand         = standaardLoopafstand;
   } // einde method verdedig()

   public void beweegRandom() {
      double r = Math.random();
      botDraaicirkel = r * (mijnDoel.bewegingsrichting - getHeadingRadians()) ;
      botLoopafstand         = r * mijnDoel.afstand;
   } // einde method beweegRandom();

   public void kloonBeweging() {
      botDraaicirkel = angle_180( mijnDoel.bewegingsrichting - getHeadingRadians() + 90 ) ;
      botLoopafstand         = ( mijnDoel.v + 1 ) * 5;
   } // einde method koonBeweging()

/**
*/
   public void voorkomBotsingMetWanden() {
      // bereken eindpunt beweging en stuur bij:
      double x = botLoopafstand * Math.cos(botDraaicirkel);
      double y = botLoopafstand * Math.sin(botDraaicirkel);
      if (x < 0 ) {
         x = 15;
         botDraaicirkel = Math.acos(x/botLoopafstand);
      }
      if (x > xMax) {
         x = xMax-15;
         botDraaicirkel = Math.acos(x/botLoopafstand);
      }
      if (y < 0 ) {
         y = 15;
         botDraaicirkel = Math.asin(y/botLoopafstand);
      }
      if (y > yMax) {
         y = yMax-15;
         botDraaicirkel = Math.asin(y/botLoopafstand);
      }
   }

/**
* LineaireDoelRichtingVoorspelling: berekend de verwachte Doel bearing op tijd T+deltaT
*    o.b.v. snelheid kogel, (x,y)Robot, (x,y)Doel, Doel bearing, Doel heading
*    en de Robot heading
*    Directe berekening (zie aantekeningen).
*
* v0.1 (27-08-2002)
*/
   public double LineaireDoelRichtingVoorspelling(Doel d, double vKogel) {
      long   kogelVliegTijd = (long)(d.afstand/vKogel) + (getTime() - d.scanTijd) + 1;
      double doelRichting = Math.PI + bepaalRichting(getY(), getX(), d.yt(kogelVliegTijd), d.xt(kogelVliegTijd));
System.out.println("Voorspelde Doelhoek (dir)="+Math.toDegrees(doelRichting) );
      return ( doelRichting - getGunHeadingRadians() );
   }

/**
* CirculaireDoelRichtingVoorspelling:
* (zie aantekeningen).
*
* v0.1 (28-08-2002)
*/
   public double CirculaireDoelRichtingVoorspelling(Doel d, double vKogel) {
      long   kogelVliegTijd = (long)(d.afstand/vKogel) + (getTime() - d.scanTijd) + 1;
      double xSchat, ySchat;
      double radius  = d.v / d.deltaBewegingsrichting;
      double deltaBewegingsrichtingTot = kogelVliegTijd * d.deltaBewegingsrichting;
      xSchat = d.x + (Math.cos(d.bewegingsrichting) * radius)
                   - (Math.cos(d.bewegingsrichting + deltaBewegingsrichtingTot) * radius);
      ySchat = d.y + (Math.sin(d.bewegingsrichting + deltaBewegingsrichtingTot) * radius)
                   - (Math.sin(d.bewegingsrichting) * radius);

      double doelRichting = Math.atan2( xSchat - getX(), ySchat - getY() );
System.out.println("Voorspelde Doelhoek (cir)="+Math.toDegrees(doelRichting) );
      return ( doelRichting- getGunHeadingRadians() );
   }

public double guessPosition(Doel d, double vKogel) {
    /**time is when our scan data was produced.  when is the time
    that we think the bullet will reach the target.  diff is the
    difference between the two **/
    long   kogelVliegTijd = (long)(d.afstand/vKogel) + (getTime() - d.scanTijd) + 1;
    double diff = d.afstand/vKogel;
    double newX, newY;
    /**if there is a significant change in heading, use circular
    path prediction**/
    if (Math.abs(d.deltaBewegingsrichting) > 0.00001) {
        double radius = d.v/d.deltaBewegingsrichting;
        double tothead = diff * d.deltaBewegingsrichting;
        newY = d.y + (Math.sin(d.bewegingsrichting + tothead) * radius) -
                      (Math.sin(d.bewegingsrichting) * radius);
        newX = d.x + (Math.cos(d.bewegingsrichting) * radius) -
                      (Math.cos(d.bewegingsrichting + tothead) * radius);
    }
    /**if the change in heading is insignificant, use linear
    path prediction**/
    else {
        newY = d.y + Math.cos(d.bewegingsrichting) * d.v * diff;
        newX = d.x + Math.sin(d.bewegingsrichting) * d.v * diff;
    }
      double doelRichting = Math.atan2(newX - getX(), newY - getY());
System.out.println("Voorspelde Doelhoek (cir)="+Math.toDegrees(doelRichting) );
      return ( doelRichting- getGunHeadingRadians() );
}

/**
* Vuurkracht afhankelijk van de doelafstand en de (voorspelde) hoek tussen kanon en doel
*
* v0.2 (28-08-2002)
*/
   public void stuurKannon() {
      double deltaHoek;

      // vuurkracht baseren op afstand (=raakkans) van het doel:
      if (mijnDoel.afstand < naderingsAfstand)       kanonVuurkracht = 5*standaardVuurkracht;
      else {
         if (mijnDoel.afstand < 2D*naderingsAfstand) kanonVuurkracht = 2*standaardVuurkracht;
         else                                        kanonVuurkracht = standaardVuurkracht;
      }

      double snelheidKogel     = 20 - 3 * kanonVuurkracht;

//System.out.println("d.deltaBewegingsrichting="+mijnDoel.deltaBewegingsrichting);

// indien verschil in bewegingsrichting doel groter dan vaste waarde,
// dan circulaire positievoorspelling doel.
// Maximum Bot draairichting per tijds eenheid is: 10 - .75 * getVelocity() graden/tijdsstap
// 1 graad = 0.0174 radialen
      if (Math.abs(mijnDoel.deltaBewegingsrichting) > ((10 - .75 * mijnDoel.v)/10000)) {
         deltaHoek = CirculaireDoelRichtingVoorspelling(mijnDoel, snelheidKogel); // voorspelling obv lineaire beweging:
      }
// if the change in heading is insignificant, use linear path prediction
      else {
         deltaHoek = LineaireDoelRichtingVoorspelling(mijnDoel, snelheidKogel); // voorspelling obv lineaire beweging:
      }

//      deltaHoek = guessPosition(mijnDoel, snelheidKogel); // voorspelling obv lineaire beweging:
      kanonDraaicircel = NormaliseBearing( deltaHoek );
      setTurnGunRightRadians(kanonDraaicircel); // draai kanon meteen (kan alleen in eventhandling):
   }

/**
* Kanon wordt afgevuurd indien doel nog bekend is, energie niet te laag en kanon is afgekoeld.
*
* v0.1 (08-08-2002)
*/
   public void vuurKannon() {
      if (doelGevonden
       && getEnergy()  > 3D // alleen schieten als doel gescanned en energie voldoende is (beter te overleven dan schieten en missen!)
       && getGunHeat() == 0) fire(kanonVuurkracht);
   }

/**
* stuurRadar: doel is om tegenstander eerst te vinden, dan te volgen:
*
* v0.1 (30-07-2002)
*/
   public void stuurRadar() {
      if(doelGevonden && getOthers() < standaardAantalBots) {// draaicirkel verkleinen tot richting van doel + bewegings "onscherpte":
         radarDraaicirkel = NormaliseBearing( mijnDoel.richting - getRadarHeadingRadians() );

         if (radarDraaicirkel < 0) radarDraaicirkel -= correctieRadarDraaicirkel;
         else                      radarDraaicirkel += correctieRadarDraaicirkel;
      } else { // indien geen doel gevonden, dan volledige cirkel bestrijken:
         radarDraaicirkel = standaardDraaicirkel/2D;
      }
      setTurnRadarRightRadians( radarDraaicirkel );
   }

   public void resetBot() {
      botDraaicirkel   = 2*standaardDraaicirkel;
      botLoopafstand           = standaardLoopafstand;
      doelGevonden             = false;
      bewegingsToestand        = ONBEPAALD;
      mijnDoel.initialisatie();
//System.out.println("vergeet doel: ");
   }

/**
* Algemene hulpfuncties (gepikt van robocode website)
*/
//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
   public double NormaliseBearing(double ang) {
          if (ang > Math.PI)
                  ang -= 2*Math.PI;
          if (ang < -Math.PI)
                  ang += 2*Math.PI;
          return ang;
   }

//if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
   public double NormaliseHeading(double ang) {
          if (ang > 2*Math.PI)
                  ang -= 2*Math.PI;
          if (ang < 0)
                  ang += 2*Math.PI;
          return ang;
   }

/**
* bepaal richting van bot tot doel-positie
*/
   public static double bepaalRichting(double Xd, double Yd, double Xb, double Yb ) {
      return Math.atan2( (Yd - Yb), (Xd - Xb) );
   }
/**
* bepaal afstand van bot tot doel-positie
*/
   public static double bepaalAfstand(double Xd, double Yd, double Xb, double Yb ) {
      return (Math.sqrt((Xd-Xb)*(Xd-Xb)+(Yd-Yb)*(Yd-Yb)));
   }

   public double angle_180(double ang) {
      return Math.atan2(Math.sin(ang), Math.cos(ang));
   }
/**********************************************************************
** Definitie van variabelen
**********************************************************************/
// variabelen voor strijdperk:
   double  xMax, yMax;

// variabelen voor beweging:
   int     voorwaards             = 1;
   int     bewegingsToestand      = ONBEPAALD;
   double  botDraaicirkel = 2*standaardDraaicirkel;
   double  botLoopafstand         = standaardLoopafstand;
   double  xM, yM, xD, yD, alphaD;

// variabelen voor kanon:
   double  kanonDraaicircel = standaardDraaicirkel;
   double  kanonVuurkracht        = 0.1;
   boolean adjustGun              = true; // kanon draait in tegengestelde richting als bot: blijft daardoor oorspronkelijke richting behouden

// doel variabelen:
   boolean doelGevonden           = false;
   Doel    mijnDoel;

// variabelen voor radar:
   boolean adjustRadar            = true; // radar draait in tegengestelde richting als bot: blijft daardoor oorspronkelijke richting behouden
   double  radarDraaicirkel = standaardDraaicirkel/2D;

// algemene variabelen:

} // einde Loki
/**********************************************************************
** EINDE LOKI
**********************************************************************/

/**
 * Doel - deze class bevat zoveel mogelijk informatie over het doel:
 *
 * Deze class wordt gebruikt om gescande tegenstanders op te slaan en
 * om het huidig doel vast te leggen.
 */
class Doel {
   public String naam = null;
   public double x, y;
   public double v, vMean, vRotatie, e;
   public double bewegingsrichting, deltaBewegingsrichting;    // x-pos, y-pos, snelheid, energie, richting
   public double afstand, richting;    // afstand en hoek tov. mijn botje
   public long   scanTijd, scanTijd_o; // tijd waarop doel is gescanned
   public double x_o, y_o, x_n, y_n;   // historie van doel...en schatting toekomst
   public double v_o, vRotatie_o, e_o;
   public double bewegingsrichting_o;
   public double afstand_o, richting_o;

   public double setX(double xB) {return  (xB + afstand * Math.sin(richting) );}
   public double setY(double yB) {return  (yB + afstand * Math.cos(richting) );}

   public double xt(long t) {return  (x + Math.sin(bewegingsrichting) * v * t);} // relative kogeltijd
   public double yt(long t) {return  (y + Math.cos(bewegingsrichting) * v * t);}

   Doel(){
      initialisatie();
   }

   public void initialisatie(){
      naam                  = null;  // naam uitvegen zodat doel wordt gereset
      scanTijd = scanTijd_o = 10000; // groot zodat Loki niet steeds opnieuw wordt gereset
      afstand= afstand_o    = 0;     // afstand en energie nul ivm bewegingsstrategie
      v = v_o               = 0;     // snelheid
      vMean                 = 0;     // gemiddelde snelheid = 0
      e = e_o               = 0;     // energie
      richting = richting_o = 0;
      bewegingsrichting     = 0;
      bewegingsrichting_o   = 0;
      deltaBewegingsrichting= 0;
   }
} // einde class Doel
/**********************************************************************
** EINDE DOEL
**********************************************************************/

/**********************************************************************
** Constanten zijn apart vastgelegd in interface
**********************************************************************/
interface Constanten {
// bewegingsconstanten
   int    ONBEPAALD            = 0;        // initiele waarde
   int    ZOEKHOEK             = 1;        // op zoek naar hoek
   int    INHOEK               = 2;        // in een hoek
   int    AANVAL               = 5;        // aanval: beweging richting doel
   int    VERDEDIGING          = 6;        // verdediging: beweging van doel weg
   int    KLOON                = 9;        // kloon: kloon beweging van doel
//
   int    CountReset           = 35;       // tijd waarna huidig doel wordt 'vergeten'
   double delta                = 5;       // ingebouwde onnauwkeurigheid
   double standaardLoopafstand = 35;       // kleine stapjes (draaihoek is belangrijker)
   double hoekAfstand          = 120;      // niet te dicht in hoek gaan zitten
   double standaardDraaicirkel = 2*Math.PI;// 360 graden draaien
   double naderingsAfstand     = 130;      // ga op doel af (in gevecht doel proberen te rammen)
   int    standaardAantalBots  = 3;        // oppassen bij groot aantal vijandelijke bots
   double standaardVuurkracht  = 1.0;      // stapjes waarmee vuurkracht wordt vergroot (was 0.4)
   double correctieRadarDraaicirkel = Math.PI/16; // delta in radar draaihoek om te voorkomen dat doel wordt kwijtgeraakt
}
