package dummy.mini;

import robocode.*;
import robocode.util.Utils;
import java.util.HashMap;
import java.util.Collection;
import java.awt.geom.Point2D;
import dummy.mini.EnemyHistory;
import java.awt.Color;

/**
 * Scimitar 1.0 - a Robocode robot by Kwok-Cheung Li
 * A melee robot written to participate in Kawigi's LittleLeague
 * http://robocode.yajags.com
 * Scimitar is a Mini-class Robot (codesize less than 1500)
 * 
 * Features: 
 * - a variant on MajorMarauder's movement
 * - Stores lateral displacements into a lookup-table rather than a 
 *   one-dimensional array. This makes searching for patterns a lot 
 *   faster than going through every pattern in the array. Because I do 
 *   a lot of approximations, the gun is very inaccurate.
 * - Current codesize : 1442
 * 
 * 
 * VERSION HISTORY
 * 
 * (1.01) 07-11-2003
 * - Small bugfix... doesn't seem to affect performance of Scimitar at all ;-)
 * 
 * (1.0) 27-10-2003
 * - Implemented variant of MajorMarauder's movement
 * - Implemented lookup-table patternmatcher
 * 
 *
 * 
 *  CREDITS:
 * - I peeked into Zeb's MajorMarauder's code and stole the idea 
 *   to check certain nearby positions for 'heat' from enemy bots and 
 *   moving to the position with the least heat.
 *   
 */

public class Scimitar extends AdvancedRobot
{
	static HashMap Enemies = new HashMap();
	static Average myVelocity;
	static ScannedRobotEvent target;
	final static double border = 30;

	public double wallheat(double pos, double wall, int os)
	{
		double factor = (getOthers()+2) * (.003 + .03 * (((os + getTime()/40)%3)%2));
		return factor / pos + factor / (wall - pos);
	}

	public void run()
	{
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);

		setColors(new Color(180 * 256 * 256 + 200 * 256 + 255), Color.black, Color.white);


		myVelocity = new Average(8);
		turnRadarRightRadians(7);

		do
		{
			myVelocity.add(getVelocity());
			setTurnRadarRightRadians(1);

			// *** MOVE!! *** //
			if (Math.abs(getDistanceRemaining()) < 1)
			{
				double myX = getX(), myY = getY();
				double posX = myX, posY = myY, testX, testY;
				double minheat = Double.POSITIVE_INFINITY;
				Object positions[] = (Enemies.values().toArray());
				for (int i=1; i<=4; i++)
				{
					for (int j = 0; (j < 12); j++)
					{
						double heat = 0;
						double offset = i*(Math.PI/12);
						double distance = 60 * i;
						testX = myX + distance * Math.sin(j * (Math.PI/6) + offset);
						testY = myY + distance * Math.cos(j * (Math.PI/6) + offset);
						if ((testX > border) && (testY > border) && (testX + border < getBattleFieldWidth()) && (testY + border < getBattleFieldHeight()))
						{
							heat += wallheat(testX, getBattleFieldWidth(), 0);
							heat += wallheat(testY, getBattleFieldHeight(), 1);
							for (int k = 0; k < positions.length; k++)
							{
								EnemyHistory pos = (EnemyHistory)positions[k];
								if (pos.live)
								{
									heat += 1 / Point2D.distance(testX, testY, pos.X, pos.Y);
								}
		
							}
							if (heat < minheat)
							{
								minheat = heat;
								posX = testX;
								posY = testY;
							}
						}
					}
				}
				double turn = Utils.normalRelativeAngle(Math.atan2(posX - myX, posY - myY) - getHeadingRadians());
				double forward = Point2D.distance(myX, myY, posX, posY);
				double t = Math.atan(Math.tan(turn));
				if (Math.abs(turn - t) > 1)
					forward = -forward;
				setAhead(forward);
				setTurnRightRadians(t);
			}
			// *** // *** //

			// *** FIRE!! ***//
			if (target != null && getGunHeat() < 3)
			{
				EnemyHistory enemy = (EnemyHistory) (Enemies.get(target.getName()));
				double bp = Math.min(Math.min((target.getEnergy() / 4), 3), getEnergy() / 10);

				double bv = 20 - 3 * bp;
				double aim = Math.atan(enemy.aim(enemy.e.getDistance(), bv) / enemy.e.getDistance());
				double bearing = Math.atan2((enemy.X - getX()), (enemy.Y - getY()));
				setTurnGunRightRadians(Utils.normalRelativeAngle(bearing + aim - getGunHeadingRadians()));
				setFire(bp);
			}
			// *** // *** //

			execute();
		}
		while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		double time = getTime();
		double absbearing = e.getBearingRadians() + getHeadingRadians();

		String name = e.getName();
		if (target == null)
		{
			target = e;
		}
		else
		{
			if (target.getName().equals(name) || e.getDistance() < target.getDistance() -120)
				target = e;
		}

		double x = getX() + e.getDistance() * Math.sin(absbearing);
		double y = getY() + e.getDistance() * Math.cos(absbearing);

		if (!Enemies.containsKey(name))
		{
			Enemies.put(name, new EnemyHistory());
		}

		EnemyHistory lastScan = (EnemyHistory) Enemies.get(name);
		lastScan.e = e;
		lastScan.X = x;
		lastScan.Y = y;
		lastScan.live = true;
		if (Math.abs(getTime() - lastScan.time) > 4)
		{
			// *** I'm comparing getBearingRadians() to the previous getBearingRadians() *** //
			// *** to calculate a lateral displacement since the last scan. Because I'm  *** //
			// *** not standing still myself, I will need to compensate for my own dis-  *** //
			// *** placement and rotation. This is perhaps not the best way, but it'll   *** //
			// *** do for now. :-)                                                       *** //
			double myRotation = getHeadingRadians() - lastScan.myHeading;
			double dAng = Utils.normalRelativeAngle(e.getBearingRadians() - lastScan.e.getBearingRadians() + myRotation);
			double displacement = (.125 * .5) * (lastScan.e.getDistance() + e.getDistance()) * Math.atan(dAng);
			double averageBearing = .5 * (e.getBearingRadians() + lastScan.e.getBearingRadians());
			displacement -= Math.sin(averageBearing) * myVelocity.getAverage();
			// *** // *** //

			lastScan.addDisplacement((int) Math.round(displacement));
			lastScan.time = getTime();
			lastScan.myHeading = getHeadingRadians();

		}
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		EnemyHistory deadbot = (EnemyHistory) Enemies.get(e.getName());
		deadbot.live = false;
		if (target != null)
		{
			if (e.getName().equals(target.getName()))
			{
				target = null;
			}
		}
	}
}
