package vishius;

import java.awt.Color;
import java.awt.geom.Rectangle2D;

import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Orbiter extends AdvancedRobot {
	
	private boolean centering;
	private int direction = 1;

	@Override
	public void run() {
		setColors(Color.BLACK, Color.BLUE, Color.WHITE);
	}
	
	public void onStatus(StatusEvent e) {
	    setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	@Override
    public void onScannedRobot(ScannedRobotEvent e) {		
		
		// We are out of bounds. Move towards center if we are on collision course
		Rectangle2D innerField;
		double absoluteBearing, eBearing;
		centering = (innerField = new Rectangle2D.Double(72, 72, getBattleFieldWidth()-144, getBattleFieldHeight()-144)).contains(getX(),getY()) ? false : centering;
		
		if (!innerField.contains(getX(), getY()) && !centering) {
			direction = -direction;
			centering = true;
		}
		
		
		setTurnRightRadians(Utils.normalRelativeAngle((eBearing = e.getBearingRadians() )- Math.PI/2));
		setAhead(e.getBearingRadians() * e.getDistance() * direction);
		setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(getHeadingRadians() + eBearing - getRadarHeadingRadians()));			

		// Linear Targeting
		
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing = getHeadingRadians() + eBearing)- getGunHeadingRadians() 
				+ (e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / 17)));
		setFire(1.35);	
	}
	
	@Override
	public void onHitWall(HitWallEvent event) {
		direction = -direction;
	}
        	     
}

