package gh.ghutils;

import robocode.*;
import robocode.util.Utils;
import robocode.Rules;
import java.util.ArrayList;
import java.awt.geom.Point2D;

/**
 * GunBullets
 *
 * This class represents the list of fired bullets.
 * The one and only purpose is to have the data to calculate bullet shadows
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class GunBullets {
    private static ArrayList<Bullet> bullets;
	private static boolean newbullet;

	// reset: Clear all bullets
	public static void reset() {
        newbullet = false;
		if (bullets == null) {
            bullets = new ArrayList<Bullet>();
        } else {
            bullets.clear();
        }
    }
    // addBullet: Fill the list with active bullets
    public static void addBullet( Bullet b) {
        bullets.add(0, b);
		newbullet = true;
	}

	// checkActiveBullets: Check the status of the bullets, if necessary delete them.
	public static boolean checkActiveBullets() {
		for (int i = bullets.size() - 1; i >=0; i--) {
			if (!bullets.get(i).isActive()) {
				bullets.remove(i);
			}
		}
		return newbullet;
	}

	// addShadows: add shadow for newest bullet and EnemyWave
	public static void addShadows( EnemyWave ew) {
		if (bullets.size() > 0) {
			calcShadow( ew, bullets.get(0));
		}
		newbullet = false;
	}

	// addNewWave: the opponent fired a new wave
	public static void addNewWave( EnemyWave ew) {
		for (int i = bullets.size() - 1; i >= 0; i--) {
			if (i == 0 && newbullet == true) { continue; }
			calcShadow( ew, bullets.get(i));
		}
	}

	// calcShadow: calc the shadowbin between EnemyWave and bullet
	private static void calcShadow( EnemyWave ew, Bullet b) {
		// Note that the calculation is done per tick, that means that
		// both bullet and wave are moved, then checked for 'collision'
		Point2D.Double bulletstart = new Point2D.Double();
		Point2D.Double bullettip   = new Point2D.Double();
//		Point2D.Double bulletmiddle = new Point2D.Double();
		Point2D.Double bullettail  = new Point2D.Double();
		double distfireloc;
		boolean intercepted = false;
		long t = 0;
	
		bulletstart.setLocation(b.getX(), b.getY());
		distfireloc = TickState.getMyPos().distance(ew.fireLocation) - GHUtils.HALFBOTWIDTH;
		if (TickState.getMyPos().distance(bulletstart) > distfireloc) {
// 			System.out.println("skipping bullet, as it has passed the firelocation");
			return;
		}
		if ( ew.getWaveDistance(TickState.currTime) > distfireloc) {
//			System.out.println("skipping wave, as it has passed my location");
			return;
		}

		do {
			t = t + 1;
			bullettip = GHUtils.doProjectPos( bulletstart, b.getHeadingRadians(), t * b.getVelocity() );
			if (t >= 100) {
				System.out.println("Never ever hit the bullet the wave . . .");
				intercepted = true;
			}
			else if (ew.fireLocation.distance(bullettip) < ew.getWaveDistance(TickState.currTime + t)) {
				intercepted = true;
			}
			else if (TickState.getMyPos().distance(bullettip) > distfireloc) {
//				System.out.println("Skipping because bullet way of course "+t);
				t = 100;
				intercepted = true;
			}
		} while (!intercepted);

		if (t < 100) {
//System.out.println("Bullet touched wave at t  "+t);
			bullettail  = GHUtils.doProjectPos( bulletstart, b.getHeadingRadians(), (t-1) * b.getVelocity() );
			int hitbin1 = ew.getHittedBin( bullettip);
			int hitbin2 = ew.getHittedBin( bullettail);
//System.out.println("Shadow on "+(Math.abs(hitbin1-hitbin2)+1)+" bins "+hitbin1+" till "+hitbin2);
			for (int i = Math.min(hitbin1, hitbin2); i <= Math.max(hitbin1, hitbin2); i++) {
				if ((i >= 0) && (i < GHUtils.MBINS)) {
					ew.binshadow[i] = 1;
				}
//				else {
//					System.out.println("Skipping because out of range: "+i);
//				}
			}
		}
	}
}
