package lucasslf;

import java.awt.Color;
import java.awt.Graphics2D;

import lucasslf.development.Gun2;
import lucasslf.radar.BasicRadar;
import lucasslf.wavesurfing.BasicWaveSurfer;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

//THE THIRD!
public class Wiggins extends LucasslfBot {

	private Gun2 gun;
	
	public Wiggins(){
		super();
		setMovement(new BasicWaveSurfer(this));
		setRadar(new BasicRadar(this));
		gun = new Gun2(this);
	}
	public void run() {
		// Initialization of the robot should be put here

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.BLUE, Color.red, Color.WHITE); // body,gun,radar
		setBulletColor(Color.CYAN);
		
		// Robot main loop
		// Loop forever
		do {

			getRadar().doRun();
		} while (true);
		
	}
	@Override
	public void onBulletHit(BulletHitEvent event) {
		super.onBulletHit(event);
		gun.onBulletHit(event);
	}	
	@Override
	public void onBulletMissed(BulletMissedEvent event) {
		gun.onBulletMissed(event);
	}
	@Override
	public void onHitByBullet(HitByBulletEvent event) {		
		super.onHitByBullet(event);
		gun.onHitByBullet(event);
	}
	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		gun.onScannedRobot(e);
		super.onScannedRobot(e);
	}
	
	@Override
	public void onPaint(Graphics2D g) {
		super.onPaint(g);
	}
	
}
