package fire219;
import robocode.*;
//import java.awt.Color;

/**
 * CatBot - a robot by Matthew Petry (fire219)
 * A tracker-type bot
 */
public class CatBot extends AdvancedRobot
{

	String target;
	String potenttarget; 
	int targettimer = 0; //timer for target abandonment
	double turnval = 0; // used for turn direction decision
	double prevtbear = 0; // Previous Target Bearing -- for target velocity correction
	int globescan = 0; // activate 360 degree scan mode (for when target is lost)
	
	public void run() {

		target = null;
	//	setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		while(true) {
			execute();			
			while (target == null){
				setTurnRadarRight(30);
				execute();
			}
			targettimer = targettimer + 1;
			out.println(targettimer);
		//	while (prevtbear == turnval) {
			//	setTurnRadarLeft(20);
			//	setAhead(20);
		//	}	
			if (targettimer > 10) {
				globescan = 1;
			}	
			if (targettimer > 30){
				target = null;
				out.println("Target abandoned");
				targettimer = 0;
			}	
			if (globescan == 1) {
			 setTurnRadarRight(45);				
			}	
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		prevtbear = turnval;
		globescan = 0;
		targettimer = 0;
		turnval = e.getBearing();
		out.println(turnval + " is target bearing");	
		if (turnval > 0) {
			setTurnRight((e.getBearing()) + 10);
		}	
		if (turnval < 0) {
			setTurnRight((e.getBearing()) - 10);
		}			
		setTurnRadarRight(getHeading() - getRadarHeading());
		setAhead(10);
		targettimer = targettimer + 1;
		out.println(targettimer);

		fire(3);


		if (e.getDistance() < 200) {
			setBack(10);
		}
	}	
	public void onHitRobot(HitRobotEvent e) {
		turnRight(e.getBearing());			
		setBack(30);
	}	
		


	public void onHitByBullet(HitByBulletEvent e) {
		potenttarget = e.getName();
		if (potenttarget != target) {
			target = e.getName();
			out.println(target + " is our target");
			setTurnRight(e.getBearing());
		}	
	}	

	public void onHitWall(HitWallEvent e) {
		back(20);
		turnRight(180);
	}	
} 
