package axeBots.silversurfer;
import robocode.*;

import java.awt.Shape;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import axeBots.data.BotData;
import axeBots.data.SegmentedGFs;
import axeBots.data.StaticDataCenter;

import axeBots.AxeBot;
import axeBots.SilverSurfer;
//import axeBots.gunner.AntiMirrorGun;
//import axeBots.gunner.VectorPMGun;
import axeBots.util.*;
import axeBots.pilot.*;
import axeBots.pilot.waves.EnemyWave;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
/**
 * @author Marcos
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeTarget implements Cloneable {
	private double heat;
	public static final int MIRROR_LIST_MAX_SIZE = 60;
	private double[] mirrorList = new double[MIRROR_LIST_MAX_SIZE];
	private int mirrorQt;
	private double lastBulletPow;
	private Shape botShape = null;
	private Stratego stratego = null; //new Stratego();
	private String name;
	private String alvo = null;
	private double bearing;
	private double absbearing_rad;
	private int hitsOnARow = 0;
	private double x, y;
	private double distance;
	private boolean disabled;
	private double phasis = 0;
	private double lastStop = 0;
	private double timeToHit;
	private double headsDelta;
	private long timesDelta;
	private double velsDelta;
	private double lifesDelta;
private Point2D.Double botPos=new Point2D.Double();
	private double head;
	private long time;
	private double vel;
	private double life;

	private double headsSum;
	private double velsSum;
	private ArrayList pos = new ArrayList();
	private int amostras = 0;
	private boolean isAlive = true;
	private int hitMe = 0;
	private int damage = 0;
	private PrintStream log = null;
	private double attackAngle;
	private int historyMatch = 50;
	private double expectedLifeDiff = 0;
	private int maxHistMatch = 200;

	private int mgun2lim = 2;

	private int mgun2pos = 0;
	private int mgun2dir = 1;

	private int mgun1lim = 1;

	private int mgun1pos = 0;
	private int mgun1dir = 1;

	private double canHitMe = Double.NaN;
	private BulletTracker lastHit = null;

	private BotData botData = null;
	private long lastAccTime;
	private long lastDeaccTime;
	
	private long lastInversionTime;
	private int velDir = 1;
	
	private boolean ramming;
	private boolean headOn;
	private double lastVel;

	private static double scans = 0;
	private static long longRammCounter = 0;
	private int shortRammCounter = 0;
	
	private AxeVector myHeading = new AxeVector ();
	private AxeVector meToHim = new AxeVector ();
	private double myAttackAngle;
	private long lastVelChangedTime;
	
	

	public void fired() {

		if (Math.abs(mgun1pos) >= mgun1lim)
			mgun1dir *= -1;
		mgun1pos += mgun1dir;

		if (mgun2dir < 0) {
			if (mgun2pos <= mgun2lim * mgun2dir)
				mgun2dir *= -1;
			else
				mgun2pos += mgun2dir;
		} else if (mgun2dir > 0) {
			if (mgun2pos >= mgun2lim * mgun2dir)
				mgun2dir *= -1;
			else
				mgun2pos += mgun2dir;
		}

	}

	//private AdvancedRobot pai= null;
	public void setDuel(boolean d) {
		this.setAlvo(AxeBot.getIt().getName());
		stratego.setDuel(d);
	}

	public void hitMe(double dam) {

		AxeBot me = AxeBot.getIt();
		hitMe++;
		damage += dam;
		this.setAlvo(me.getName());
		stratego.setEnemyHitedMe(me.getMoveStrat(), dam);
	}

	public int getHitMe() {
		return damage;
	}

	public void loose() {
		this.isAlive = false;
		new EnemyWave(lastBulletPow, AxeBot.getIt().getTime(), this);
	}

	public void win() {
		//this.isAlive= false;
	}

	public void terminate() {
		log.println("  Data size:" + this.botData.getSamplesSize());
		heat = 0;
		log.println(this.stratego.getPowerStats());

		if (isAlive) {
			stratego.setScore((AxeBot.getIt()).getTotBots());
			botData.getScorer().win();
		}

		log.println(botData.getScorer().toString());
		if (AxeBot.getIt().getRoundNum() == (AxeBot.getIt().getNumRounds() - 1)) {
			if (AxeBot.SAVE_PMGUN_DATA) {
				AxeFiles.cleanBotsFiles(name);
				stratego.saveData();
			}
			if (AxeBot.SAVE_WS_DATA) {
				long quota = AxeBot.getIt().getDataQuotaAvailable();

				if (quota > AxeFiles.QUOTA_LIMIT) {
					botData.getGfHistory().save(this.getName());
				}

			}
			
			
		}

	}

	public double getAttackAngle() {
		return attackAngle;
	}

	public double getDistance() {
		return distance;
	}

	public Shape getBotShape() {

		return botShape;

	}

	private void setBotShape() {

		AxeBot me = AxeBot.getIt();

		double dx = me.getWidth();
		double dy = me.getHeight();

		Rectangle2D.Double botRect = new Rectangle2D.Double(this.pos().x
				- (dx / 2), this.pos().y - (dy / 2), dx, dy);

		botShape = botRect;

		// Create a rotation transform of 30degrees CCW around
		// the the corner of the rectangle.
		AffineTransform atx = AffineTransform.getRotateInstance(Math
				.toRadians(this.getHeading()), pos().x, pos().y);
		// Take the shape object and create a rotated version
		botShape = atx.createTransformedShape(botShape);

	}

	/**
	 * Return the bearing (0 means our robot heading) in radians Between 0-2PI.
	 */
	public double getBearing() {
		return bearing;
	}

	public double getHeading() {
		return head;
	}

	public double getHeadToMe() {
		double ret = Math.toDegrees(this.getHeading());
		ret = RoboMath.normalRelativeAngle((this.getVelocity() < 0)
				? ret - 180
				: ret);
		ret = RoboMath.normalRelativeAngle(ret
				- RoboMath.getang(this.pos(), AxeBot.getIt().pos()));
		return ret;
	}

	public double getHeadsDelta() {
		return this.headsDelta;
	}

	public double getAcceleration() {
		return this.velsDelta;
	}

	public double getAvgVel() {
		return this.velsSum / amostras;
	}

	public double getAvgHeads() {
		return this.headsDelta / amostras;
	}

	/**
	 * Return the absolute bearing (0 means Y axis) in radians Between 0-2PI.
	 */
	public double getAbsBearing() {
		return absbearing_rad;
	}

	public double getTimeToHit() {
		return timeToHit;
	}

	public boolean isAlive() {
		return isAlive;
	}

	public boolean isIn(Shape s) {
		if (s.contains(this.getX(), this.getY())) {
			return true;
		} else {
			return false;
		}
	}

	public void dead(int pts) {

		stratego.setScore(pts);
		botData.getScorer().died();
		//log.println(this.getName()+" dead "+pts);
		isAlive = false;
	}

	public void setTimeToHit(double novo) {
		timeToHit = novo;
	}

	public void hit(BulletTracker bt) {
		this.lastHit = bt;

		this.incHitsOnARow();
		if (isAlive())
			stratego.hit(bt);
	}

	public void missed(BulletTracker bt) {

		this.decHitsOnARow();
		if (isAlive()) {
			stratego.missed(bt);
		}
	}

	public Point2D.Double pos() {
		return (Point2D.Double)botPos.clone();
	}

	public Point2D.Double getPos(int atTime) {
		return botData.getPos(atTime);
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public String getName() {
		return name;
	}

	public double getLife() {
		return life;
	}

	public double getVelocity() {
		return vel;
	}

	public double getScanTime() {
		return time;
	}

	public Vector getAllPos() {
		return (Vector) pos.clone();
	}

	public AxeTarget(String nome, PrintStream inlog) {
		super();
		this.name = nome;
		log = inlog;
		stratego = new Stratego(nome, log);
	}

	public AxeTarget(String nome) {

		this(nome, null);

	}

	public AxeTarget(ScannedRobotEvent e, AdvancedRobot ft, PrintStream inlog) {
		this(e.getName(), inlog);
		botData = StaticDataCenter.logIn(name);
		stratego = new Stratego(name, log, this);
		if (ft != null) {

			if (e != null)
				setScanned(e, ft);
		}

	}

	public double getLastLifeDiff() {
		if (amostras < 2)
			return 0;

		double sum = 0;

		if ((lastHit != null) && (Double.isNaN(lastHit.getImpactTime()))
				&& (lastHit.getImpactTime() == time)) {
			sum = RoboMath.getBulletDamage(lastHit.getBullet().getPower());
		}

		return this.lifesDelta + sum;
	}

	public double getMoveAngle() {
		if (pos.size() < 2)
			return Double.NaN;
		AxeVector going = null;
		AxeVector now = (AxeVector) pos.get(pos.size() - 1);
		AxeVector test = null;
		double moveAngle = Double.NaN;
		double mod = 0;
		int cont = pos.size() - 1;
		while ((mod == 0) && (cont > 0)) {
			test = (AxeVector) pos.get(--cont);
			going = now.minus(test);
			mod = going.getRelativeModule();
		}

		if (mod != 0) {
			moveAngle = RoboMath.normalRelativeAngle(going.getRelativeTheta());
		}

		return moveAngle;
	}

	public void setScanned(ScannedRobotEvent e, AdvancedRobot ft) {
		//        log.println("scanned " + e.getName() + "at:" + e.getTime());
		// shifta amostras
		//ALTERADO: NAO SEI SE PRECISA DESTA PROTECAO
		if (!this.isAlive()) {
			return;
		}

		scans++;

		if (e.getEnergy() <= 0.1) {
			this.setDisabled(true);
		} else {
			this.setDisabled(false);
		}

		if (SegmentedGFs.getHeadOn() > 0.75) {
			headOn = true;
		} else {
			headOn = false;
		}

		amostras++;

		timesDelta = e.getTime() - time;
		headsDelta = RoboMath.NormaliseBearing(e.getHeadingRadians() - head);
		//		double diff=vel-lastVel;
		//expectedVelDelta =(vel<0diff)
		velsDelta = (e.getVelocity() - vel);
		lifesDelta = (e.getEnergy() - life);
		int absVelsDelta = (int) (Math.abs(e.getVelocity()) - Math.abs(vel));
		if (absVelsDelta > 0) {
			lastAccTime = e.getTime();
		} else if (absVelsDelta < 0) {
			lastDeaccTime = e.getTime();
		}
		
		

		life = e.getEnergy();
		head = e.getHeadingRadians();
		time = e.getTime(); //sera'ft.getTime??? pensar.
		lastVel = vel;
		vel = e.getVelocity();

		headsSum += head;
		velsSum += Math.abs(vel);
		/////////////

		//////last inversion
		if((vel * velDir)<0){//mudou de direccao, e vel != 0!
		    lastInversionTime= e.getTime();
		    velDir = (vel<0)?-1:1;
		}
		
//////	last vel Changed
		if(vel != lastVel){
		    lastVelChangedTime= e.getTime();
		}
		
		if ((velsDelta < 0) && (vel == 0)) {
			phasis = time - lastStop;
			lastStop = time;
			this.historyMatch = (int) phasis;
			if (historyMatch > maxHistMatch)
				historyMatch = maxHistMatch;
		}

		absbearing_rad = (ft.getHeadingRadians() + e.getBearingRadians())
				% (2 * RoboMath.PI);
		
		

		x = ft.getX() + Math.sin(absbearing_rad) * e.getDistance();
		//works out the x coordinate of where the target is
		y = ft.getY() + Math.cos(absbearing_rad) * e.getDistance();
		//works out the y coordinate of where the target is
		
		botPos.setLocation(x,y );

		double tbear = RoboMath.normalRelativeAngle(RoboMath
				.normalRelativeAngle(e.getBearing())
				+ RoboMath.normalRelativeAngle(ft.getHeading()) - 180);

		attackAngle = RoboMath.normalRelativeAngle(RoboMath
				.normalRelativeAngle(e.getHeading())
				- tbear - ((vel < 0) ? 180 : 0));
		
		

		bearing = e.getBearingRadians();

		distance = e.getDistance();

		
//		ALTERADO: INCLUSAO DE ARRAY DE HEADS (SEGMENTATION)
		Point2D.Double hisPos = this.pos();
//		System.out.println("@"+time+" targetPos:"+hisPos);
		Point2D.Double myPos = AxeBot.getIt().pos();
		double head = RoboMath.normalAbsoluteAngle( AxeBot.getIt().getHeading()-(vel<0?180:0));
		myHeading.set(myPos,head,10 );
		meToHim.set(myPos ,hisPos  );
		//ALTERADO: MYATTACK ANGLE SEM MODULO AGORA
		myAttackAngle = RoboMath.normalRelativeAngle(meToHim.getDiffTheta(myHeading ));
//		System.out.println("vel:"+AxeBot.getIt().getVelocity()+" myAttackAngle:"+myAttackAngle+" @"+time);
		botData.add(x, y, time, timesDelta, distance,
				getAttackAngle(), myAttackAngle,
				(time - lastAccTime), (time - lastDeaccTime),(time - AxeBot.getIt().getLastFireTime() ));

		setBotShape();
		
		

		//ALTERADO: NOVO DETECTOR DE COLISOES COM MURO.
		if (this.getLastLifeDiff() < 0) {
			this.setExpectedLifeDiff(Math.min(this.getLastLifeDiff() * -1, this
					.getWallsDamage()));
		}

		double lifeDiff = this.getLastLifeDiff() - this.getExpectedLifeDiff();
//		System.out.println(this.getName() + " lifeDiff:" + lifeDiff
//				+ " wallsDmg:" + getWallsDamage() + " getLastLifeDiff:"
//				+ this.getLastLifeDiff() + " getExpectedLifeDiff:"
//				+ getExpectedLifeDiff() + " @" + AxeBot.getIt().getTime());
		expectedLifeDiff = 0;

		if ((lifeDiff < 0)
				&& (((lifeDiff > -3.0001) && (lifeDiff < -0.0999)) || ((lifeDiff > -0.1) && (e
						.getEnergy() == 0.0)))) {

			//enemy fired bullet!!
			heat = 0.2 * (e.getEnergy() - lifeDiff - 0.1) + 0.92;

			AxeBot me = AxeBot.getIt();
			double bullPow = Math.abs(lifeDiff);

//			System.out.println(" fired:" + bullPow);

			double bullVel = RoboMath.getBulletVelocity(bullPow);
			double dist = RoboMath.getrange(this.getX(), this.getY(),
					me.getX(), me.getY());
			double timeToHit = me.getTime() + (dist / bullVel);

			this.lastBulletPow = bullPow;

			if ((Double.isNaN(canHitMe)) || (timeToHit < canHitMe)) {
				setCanHitMe(timeToHit);
			}

			stratego.setEnemyFired(me.getMoveStrat());
			if (((SilverSurfer) me).getMyPilot() != null) {

				((SilverSurfer) me).getMyPilot().enemyFired();
			}

			EnemyWave ew = new EnemyWave(bullPow, me.getTime(), this);
			//			System.out.println("Enemy fired:" + ew);
		} else if ((this.getLastLifeDiff() >= -3.0)
				&& (this.getLastLifeDiff() < 0.0)) {
			System.out.println("DESPREZANDO, GUN HEAT:" + heat);
		}

		double aa = Math.abs(getAttackAngle());

		//		HISTORY v.2.42: 2004/09/19 NEW RAMMER DETECTION
		if (((aa < 30) && (distance < 80))
				|| ((getDistance() < 450) && (aa < 30) && (Math.abs(vel) > 4))) {
			shortRammCounter++;
			longRammCounter++;
			if ((shortRammCounter > 15) || ((longRammCounter / scans) > 0.2)){
				ramming = true;
			}
		} else if ((longRammCounter / scans) > 0.5){
			shortRammCounter=0;
			ramming = true;
		}else
		{
			shortRammCounter=0;
			ramming = false;
		}

		//		ramming = ((getDistance() < 450) && (aa < 25) ) ? true : false;

		this.doMirror();

	}

	private double getWallsDamage() {
		Point2D.Double pos = this.pos();
		double dmg = 0;
		if (vel == 0 && (RoboMath.minFromWalls(pos) < 20)) {
			dmg = Math.max(Math.abs(lastVel) * 0.5D - 1.0D, 0.0D);
		}
		return dmg;
	}

	private void doMirror() {
		double val = AntiMirrorPilot.getOpposite(this);
		mirrorList[mirrorQt % MIRROR_LIST_MAX_SIZE] = val;
		mirrorQt++;
	}

	public double getMirrorAvg() {
		return (mirrorQt < MIRROR_LIST_MAX_SIZE) ? Double.NaN : RoboMath
				.getSum(mirrorList)
				/ ((mirrorQt < MIRROR_LIST_MAX_SIZE)
						? mirrorQt
						: MIRROR_LIST_MAX_SIZE);
		// (mirrorQt<40)?Double.NaN :mirrorAmt/mirrorQt;
	}

	/**
	 * @return
	 */
	public String getAlvo() {
		return alvo;
	}

	/**
	 * Calcula o angulo referente ao heading do alvo em relao ao meu (0 graus
	 *  o vetor ligando o alvo  mim).
	 * 
	 * @return o angulo (180 - (-180)).
	 */
	public double getAngle() {
		AxeBot me = AxeBot.getIt();
		AxeVector av = new AxeVector(this.pos(), me.pos());
		//        return RoboMath.normalRelativeAngle(
		//            av.getRelativeTheta() - this.getHeading());

		double refAng = this.getMoveAngle();
		refAng = (Double.isNaN(refAng)) ? this.getHeading() : refAng;

		double ang = RoboMath.normalRelativeAngle(av.getRelativeTheta()
				- refAng);

		//        log.println("getAngle:" + ang);

		return ang;
	}

	/**
	 * @param string
	 */
	public void setAlvo(String string) {
		alvo = string;
	}

	/**
	 * @return
	 */
	public double getCanHitMe() {
		return canHitMe;
	}

	/**
	 * @param d
	 */
	public void setCanHitMe(double d) {
		canHitMe = d;
	}

	public Stratego getStratego() {
		return stratego;
	}

	/**
	 * @return
	 */
	public int getHitsOnARow() {
		return hitsOnARow;
	}

	/**
	 * @param i
	 */
	public void resetHitsOnARow() {
		hitsOnARow = 0;
	}

	public void incHitsOnARow() {
		hitsOnARow++;
	}

	public void decHitsOnARow() {
		hitsOnARow--;
	}

	/**
	 * @return
	 */

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return this.getName() + " life:" + this.getLife() + " alive:"
				+ this.isAlive() + " disabled:" + this.isDisabled()
				+ " isRamming:" + this.isRamming() + " isHeadOn:"
				+ this.isHeadOn() + " dist:" + this.getDistance() +" myAttackAngle:"+botData.getMyAttackAngle(AxeBot.getIt().getTime()) + " at:"
				+ this.pos();
	}

	/**
	 * @return
	 */
	public boolean isDisabled() {
		return disabled;
	}

	/**
	 * @param b
	 */
	public void setDisabled(boolean b) {
		disabled = b;
	}

	/**
	 * @return
	 */
	public double getLastBulletPow() {
		return lastBulletPow;
	}

	/**
	 * @return
	 */
	public BotData getBotData() {
		return botData;
	}

	/**
	 * @return
	 */
	public double getExpectedLifeDiff() {
		return expectedLifeDiff;
	}

	/**
	 * @param i
	 */
	public void setExpectedLifeDiff(double i) {
		//		ALTERADO: setExpectedLifeDiff ADICIONA...
		expectedLifeDiff += i;
	}

	public long getLastAccTime() {
		return lastAccTime;
	}
	public long getLastDeaccTime() {
		return lastDeaccTime;
	}
	public boolean isRamming() {
		return ramming;
	}
	public boolean isHeadOn() {
		return headOn;
	}
	public double getMyAttackAngle() {
		return myAttackAngle;
	}
    public long getLastInversionTime() {
        return lastInversionTime;
    }

	
	public long getLastVelChangedTime() {
		
		return lastVelChangedTime;
	}
}