package ahr.ice.Math;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.math.*;

public class math {

	private static final double DOUBLE_PI = (Math.PI * 2);
	private static final double PI = (Math.PI);
	private static final double HALF_PI = (Math.PI / 2);
	
	public static double getRange( double x1,double y1, double x2,double y2 )
		{
			double xo = x2-x1;
			double yo = y2-y1;
			double h = Math.sqrt( xo*xo + yo*yo );
			return h;	
		}

public static double calculateBearingToXYRadians(double sourceX, double sourceY,
    double sourceHeading, double targetX, double targetY) {
        return normalizeRelativeAngleRadians(
           Math.atan2((targetX - sourceX), (targetY - sourceY)) -
               sourceHeading);
    }

	public static double absbearing( double x1,double y1, double x2,double y2 ){
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getRange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 ){
			return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 ){
			return Math.PI - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 ){
			return Math.PI + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 ){
			return 2.0*Math.PI - Math.asin( -xo / h );
		}
		else{
		return 0;}
	}
	
	double normalisebearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return ang;}	
public static double normalizeAbsoluteAngleRadians(double angle) {
   if (angle < 0) {
        return (DOUBLE_PI + (angle % DOUBLE_PI));
    } else {
        return (angle % DOUBLE_PI);
    }
}

public static double normalizeRelativeAngleRadians(double angle) {
    double trimmedAngle = (angle % DOUBLE_PI);
    if (trimmedAngle > Math.PI) {
        return -(Math.PI - (trimmedAngle % Math.PI));
    } else if (trimmedAngle < -Math.PI) {
        return (Math.PI + (trimmedAngle % Math.PI));
    } else {
        return trimmedAngle;
    }
}	
public static double normaliseBearing(double ang) {
    if (ang > Math.PI)
        ang -= 2*PI;
    if (ang < -Math.PI)
        ang += 2*Math.PI;
    return ang;
}

public static double getrange(double x1,double y1, double x2,double y2) {
    double x = x2-x1;
    double y = y2-y1;
    double h = Math.sqrt( x*x + y*y );
    return h;	
}
	public static Point2D.Double project(Point2D.Double origin, double angle, double distance){
		return new Point2D.Double(origin.x + distance * Math.sin(angle), origin.y + distance * Math.cos(angle));
	}
	
	public static double angle(Point2D.Double origin, Point2D.Double destination){
		return Utils.normalAbsoluteAngle(Math.atan2(destination.x - origin.x, destination.y - origin.y));
	}
public static double limit(double value, double min, double max) {
    return Math.min(max, Math.max(min, value));
}


		public static double getBulletSpeed()
	{
		return 20 - 3 * 3;
	}
public static double normalizeRelativeAngle(double angle){
		while(angle <= -Math.PI){
			angle += 2.0 * Math.PI;
		}
		while(angle > Math.PI){
			angle -= 2.0 * Math.PI;
		}
		return angle;
	}
}				