package simonton.movements;

import java.awt.Graphics2D;

import robocode.ScannedRobotEvent;
import simonton.core.Wave;
import simonton.guns.Gun;
import simonton.utils.Util;

public class EnemyGunWaveMachine extends WaveMachine {
	private Gun gun;
	private boolean adjustForRobotTurn;
	private double lastH;
	private double dh;

	public EnemyGunWaveMachine(Gun enemyGun, double weight,
			boolean adjustForRobotTurn) {
		super(weight);
		this.adjustForRobotTurn = adjustForRobotTurn;
		gun = enemyGun;
	}

	@Override
	public void run() {
		gun.run();
	}

	@Override
	public double[] getDangers(Wave wave, int bins, int binPadding) {
		//assert wave.fireTime == Util.time - 1; // not good for skipped turns

		if (gun instanceof GfGun) {
			return ((GfGun) gun).getDangers(bins, binPadding);
		}

		int gfZero = (bins - 1) / 2;
		double[] dangers = new double[bins + 2 * binPadding];
		double gunH = gun.getGunHeadingRadians();
		if (!adjustForRobotTurn) {
			gunH += dh;
		}
		int factor = wave.getFactorIndex(gunH, gfZero,
				binPadding);
		int diff;
		for (int i = 0; i < bins; ++i) {
			int paddedPos = i + binPadding;
			diff = paddedPos - factor;
			dangers[paddedPos] = weight / (diff * diff + 1);
		}
		return dangers;
	}

	//
	// @Override
	// public void onBulletHit(BulletHitEvent e) {
	// gun.onBulletHit(e);
	// }
	//
	// @Override
	// public void onBulletHitBullet(BulletHitBulletEvent e) {
	// gun.onBulletHitBullet(e);
	// }
	//
	// @Override
	// public void onBulletMissed(BulletMissedEvent e) {
	// gun.onBulletMissed(e);
	// }
	//
	// @Override
	// public void onDeath(DeathEvent e) {
	// onDeath(e);
	// }
	//
	// @Override
	// public void onHitByBullet(HitByBulletEvent e) {
	// gun.onHitByBullet(e);
	// }
	//
	// @Override
	// public void onHitRobot(HitRobotEvent e) {
	// gun.onHitRobot(e);
	// }
	//
	// @Override
	// public void onHitWall(HitWallEvent e) {
	// gun.onHitWall(e);
	// }

	@Override
	public void onPaint(Graphics2D g) {
		gun.onPaint(g);
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		double h = e.getHeadingRadians();
		dh = Util.normalize(h - lastH);
		lastH = h;
		double gunH = Util.cannonize(gun.getGunHeadingRadians()
				+ gun.getGunTurnRemainingRadians());
		gun.setGunHeadingRadians(gunH);
		gun.setGunTurnRemainingRadians(0);
		gun.setX(Util.enemyP.x);
		gun.setY(Util.enemyP.y);
		gun.setTime(Util.time);
		gun.setEnergy(e.getEnergy());
		if (Util.addedEnemyWave == null) {
			gun.setGunHeat(1);
		} else {
			gun.setNextBulletPower(Util.addedEnemyWave.firePower);
			gun.setGunHeat(0);
		}

		gun.onScannedRobot(flipScan(e));
		
	}

	//
	// @Override
	// public void onWin(WinEvent e) {
	// gun.onWin(e);
	// }

	private ScannedRobotEvent flipScan(ScannedRobotEvent e) {
		double flipBearing = getHeadingRadians() + e.getBearingRadians()
				+ Math.PI - gun.getHeadingRadians();
		ScannedRobotEvent flipScan = new ScannedRobotEvent(getName(),
				getEnergy(), Util.cannonize(flipBearing), e.getDistance(),
				getHeadingRadians(), getVelocity());
		return flipScan;
	}
}
