package alpha;

import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.util.Utils;
import java.awt.Color;
//import java.awt.color.ColorSpace;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

// javac -deprecation -g -classpath /usr/share/java/robocode.jar:robots /home/alpha/.robocode/robots/alpha/RainingFire.java
// java -cp compilers/ecj.jar org.eclipse.jdt.internal.compiler.batch.Main -deprecation -g -source 1.6 -encoding UTF-8 -classpath "C:\Program Files\Java\jre7/lib/rt.jar";libs\robocode.jar;C:\robocode\robots M:\robocode\robots\alpha\RainingFire.java

/**
 * RainingFire - a robot by Alpha
 */
public class RainingFire extends AdvancedRobot
{
    static private Vector<Bot> enemyBots;
    static public double battleFieldWidth;
    static public double battleFieldHeight;
    static public int others;
    private Vector<Wave> bulletWaves;
    public static Bot m_me;
    private boolean catAndMouse; // play with the enemy :)
    private int m_skippedTurns;
    private int m_depthLimit;
    private Coord m_rollingPos;
    private Coord m_avoidPos;

    /**
     * run: RainingFire's default behaviour
     */
    public void run()
    {
        setColors(new Color(0.8f, 0.1f, 0.0f), new Color(0.4f, 0.01f, 0.0f), Color.BLACK);

        // all move independently
        setAdjustRadarForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        battleFieldWidth = getBattleFieldWidth();
        battleFieldHeight = getBattleFieldHeight();
        bulletWaves = new Vector<Wave>();
        catAndMouse = false;
        m_skippedTurns = 0;
        m_depthLimit = 0;
        others = 0;

        setTurnRadarRightRadians(Math.PI / 4);

        for (Bot bot : enemyBots)
        {
            bot.time = -12;
            bot.reduceStats();
            /*if (bot.history.size() > 2900)
            {
                bot.history.subList(0, bot.history.size() - 2900).clear();
            }*/
        }
    }

    /**
     * onStatus: called every turn
     */
    public void onStatus(StatusEvent e)
    {
        if (m_me == null)
        {
            m_me = new Bot("", new BotTurn(getHeadingRadians(), getVelocity(), e.getTime(), new Coord(getX(), getY())), getEnergy());
            m_me.needTree = false;
        }
        else
            m_me.pushTurn(new BotTurn(getHeadingRadians(), getVelocity(), e.getTime(), new Coord(getX(), getY())), getEnergy());
        m_me.averageVelocity = m_me.averageVelocity * 3.0 / 4.0 + m_me.velocity / 4.0;
        if (m_rollingPos == null)
            m_rollingPos = new Coord(m_me.x, m_me.y);
        if (m_avoidPos == null)
        {
            m_avoidPos = new Coord();
            m_avoidPos.value = e.getTime();
        }
        m_rollingPos.x = m_rollingPos.x * 24.0 / 25.0 + m_me.x /25.0;
        m_rollingPos.y = m_rollingPos.y * 24.0 / 25.0 + m_me.y /25.0;
        if (m_avoidPos.value + 60 < e.getTime())
        {
            m_avoidPos.x = m_rollingPos.x;
            m_avoidPos.y = m_rollingPos.y;
            m_avoidPos.value = e.getTime();
        }


        if (enemyBots == null)
            enemyBots = new Vector<Bot>();
        //else
        //    enemyBotsLast = new Vector<Bot>(enemyBots);
        Vector<ScannedRobotEvent> scannedBots = getScannedRobotEvents();
        for (ScannedRobotEvent b : scannedBots)
        {
            boolean knownBot = false;
            double absoluteBearing = getHeadingRadians() + b.getBearingRadians();
            double botX = getX() + b.getDistance() * FastMath.sin(absoluteBearing);
            double botY = getY() + b.getDistance() * FastMath.cos(absoluteBearing);
            //Bot bot = new Bot(b.getName(), b.getEnergy(), botX, botY, b.getHeadingRadians(), b.getVelocity(), b.getTime());
            BotTurn turn = new BotTurn(b.getHeadingRadians(), b.getVelocity(), b.getTime(),
                                       new Coord(botX, botY, b.getDistance()));//, getOthers() < 3);
            for (Bot bot : enemyBots)
            {
                if (bot.name.equals(b.getName()))
                {
                    if (others < 3 && (bot.energy - b.getEnergy()) > 0 && (bot.energy - b.getEnergy()) <= 3)
                    {
                        bulletWaves.add(new Wave(bot, bot.energy - b.getEnergy(), e.getTime(), m_me));
                    }

                    bot.pushTurn(turn, b.getEnergy());
                    knownBot = true;
                    break;
                }
            }
            /*for (int i = 0; i < enemyBots.size(); i++)
            {
                if (enemyBots.get(i).name.equals(bot.name))
                {
                    enemyBots.set(i, bot);
                    knownBot = true;
                    break;
                }
            }*/
            if (!knownBot)
            {
                enemyBots.add(new Bot(b.getName(), turn, b.getEnergy()));
            }
        }
        Vector<HitRobotEvent> hitBots = getHitRobotEvents();
        for (HitRobotEvent hitBot : hitBots)
        {
            for (Bot bot : enemyBots)
            {
                if (bot.name.equals(hitBot.getName()))
                {
                    double absoluteBearing = getHeadingRadians() + hitBot.getBearingRadians();
                    bot.x = getX() + getWidth() * FastMath.sin(absoluteBearing);
                    bot.y = getY() + getHeight() * FastMath.cos(absoluteBearing);
                    bot.energy = hitBot.getEnergy();
                    if (bot.energy > 0)
                    {
                        bot.isAlive = true;
                    }
                    break;
                }
            }
        }
        Vector<RobotDeathEvent> killedBots = getRobotDeathEvents();
        for (Bot bot : enemyBots)
        {
            for (RobotDeathEvent died : killedBots)
            {
                if (died.getName().equals(bot.name))
                {
                    bot.isAlive = false;
                    break;
                }
            }

            bot.averageVelocity = bot.averageVelocity * 4.0 / 5.0 + bot.velocity / 5.0;

            if (bot.time == e.getTime() || !bot.isAlive)
                continue;
            // not scanned -> interpolate
            double headingChange = 0.0;
            bot.velocity = bot.averageVelocity;
            if (bot.history != null && bot.history.size() > 1)
            {
                headingChange = bot.heading - bot.history.get(bot.history.size() - 2).heading; //enemyBotsLast.get(enemyBots.indexOf(bot)).heading;
            }
            bot.x += FastMath.sin(bot.heading) * bot.velocity;
            bot.y += FastMath.cos(bot.heading) * bot.velocity;
            bot.heading += headingChange;
            bot.pushTurn();
        }


        // init wave
        //Coord me = new Coord(getX(), getY());
        /*for (Bot bot : enemyBots)
        {
            if (!bot.isAlive)
                continue;
            bulletWaves.add(new Wave(me, 2, e.getTime(), bot));
        }*/

        if (bulletWaves != null && !bulletWaves.isEmpty())
        for (int i = bulletWaves.size() - 1; i >= 0; i--)
        {
            Wave wave = bulletWaves.get(i);
//            if (!bot.isAlive)
//            {
//                bulletWaves.remove(i);
//                continue;
//            }
            double dist = Math.sqrt(Math.pow(wave.origin.x - wave.target.x, 2) + Math.pow(wave.origin.y - wave.target.y, 2));
            if (dist + 18 < wave.getRadius(e.getTime()))
            {
                //double offset = Utils.normalRelativeAngle(Math.atan2(wave.target.x - wave.origin.x, wave.target.y - wave.origin.y) - wave.angles[0]);
                //offset /= wave.angles[1];
                //wave.from.pushStat(offset, wave.distance);
                bulletWaves.remove(i);
            }
        }


        others = getOthers();

        if (others == 1 && m_me.energy > 55)
        {
            for (Bot bot : enemyBots)
            {
                if (bot.isAlive)
                {
                    catAndMouse = (bot.energy < 15);
                    break;
                }
            }
        }
        else
            catAndMouse = false;

        doDraw();
        doTarget();
        doScan(e.getTime());
        doThrottle();

        if (e.getTime() % (others == 1 ? 7 : 8) != 1)
            return;
        Vector<Coord> destinations = new Vector<Coord>();
        Vector<Coord> bullets = new Vector<Coord>();
        for (Wave wave : bulletWaves)
        {
            double dist = Math.sqrt(Math.pow(wave.origin.x - wave.target.x, 2) + Math.pow(wave.origin.y - wave.target.y, 2));
            if (wave.getRadius(e.getTime() + 16) > dist)
            {
                int delta = 0;//(others == 1 ? 11 : 0);
                bullets.add(new Coord(wave.origin.x + (dist + delta) * FastMath.sin(wave.getAngle()), wave.origin.y + (dist + delta) * FastMath.cos(wave.getAngle())));
//                if (others == 1)
//                    bullets.add(new Coord(wave.origin.x + (dist - delta) * Math.sin(wave.getAngle()), wave.origin.y + (dist - delta) * Math.cos(wave.getAngle())));
            }
        }

        Coord safePos = new Coord(-1, -1, 10);
        if (others == 1 && !bulletWaves.isEmpty())
        {
            Wave wave = bulletWaves.get(0);
            double dist = Math.sqrt(Math.pow(wave.origin.x - wave.target.x, 2) + Math.pow(wave.origin.y - wave.target.y, 2));
            safePos = new Coord(wave.origin.x + dist * FastMath.sin(wave.getSafeAngle()), wave.origin.y + dist * FastMath.cos(wave.getSafeAngle()));
        }

        /*Vector<Coord> edges = new Vector<Coord>();
        int edgeFactor = 190;
        if (others > 3 && e.getTime() % (8 * 4) == 1)
            edgeFactor = 0;
        edges.add(new Coord(getX(), -edgeFactor));
        edges.add(new Coord(getX(), battleFieldHeight + edgeFactor));
        edges.add(new Coord(-edgeFactor, getY()));
        edges.add(new Coord(battleFieldWidth + edgeFactor, getY()));*/
        int edgeFactor = 140;
        if (others > 3 && e.getTime() % (8 * 4) == 1)
            edgeFactor = 0;
        else if (others == 1 && catAndMouse)
        {
            for (Bot bot : enemyBots)
            {
                if (!bot.isAlive)
                    continue;
                if (bot.energy < 4)
                    edgeFactor = 1000;
                break;
            }
        }

        double nextX = getX() + FastMath.sin(m_me.heading) * m_me.velocity * 2.2;
        double nextY = getY() + FastMath.cos(m_me.heading) * m_me.velocity * 2.2;

        double otherAng = 0;
        if (others == 1)
        {
            for (Bot bot : enemyBots)
            {
                if (!bot.isAlive)
                    continue;
                otherAng = FastMath.atan2(bot.x - nextX, bot.y - nextY);
                break;
            }
        }

        Coord meanPos = new Coord();
        for (Bot bot : enemyBots)
        {
            if (!bot.isAlive)
                continue;
            meanPos.x += bot.x / others;
            meanPos.y += bot.y / others;
        }

        boolean wallBounded = false;

        for (double ang = Math.PI * 2; ang > 0; ang -= (Math.PI / 18))
        {
            if (   others == 1
                && !bulletWaves.isEmpty()
                && (   Math.abs(Utils.normalRelativeAngle(ang - otherAng)) < 1
                    || Math.abs(Utils.normalRelativeAngle(ang - otherAng - Math.PI)) < 0.8 ) )
            {
                continue;
            }
            double xPos = FastMath.sin(ang) * 96.0 + nextX;
            double yPos = FastMath.cos(ang) * 96.0 + nextY;
            double buffer = 0.5;
            if (   xPos < getWidth() * buffer
                || xPos > battleFieldWidth - getWidth() * buffer
                || yPos < getHeight() * buffer
                || yPos > battleFieldHeight - getHeight() * buffer )
            {
                wallBounded = true;
                continue;
            }
            Coord pos = new Coord(xPos, yPos);
            for (Bot bot : enemyBots)
            {
                if (!bot.isAlive)
                {
                    continue;
                }
                double distSq = /*Math.sqrt(*/Math.pow(xPos - bot.x, 2) + Math.pow(yPos - bot.y, 2)/*)*/;
                if (bot.energy <= 0.3 || (catAndMouse && bot.energy < 1.6))
                    distSq = -distSq; // ram weak bots
                pos.value += 1.0 / distSq;
            }
            for (Coord bullet : bullets)
            {
                double distSq = /*Math.sqrt(*/Math.pow(xPos - bullet.x, 2) + Math.pow(yPos - bullet.y, 2)/*)*/;
                pos.value += 1.0 / distSq;
            }

            Vector<Coord> edges = new Vector<Coord>();
            edges.add(new Coord(pos.x, -edgeFactor));
            edges.add(new Coord(pos.x, battleFieldHeight + edgeFactor));
            edges.add(new Coord(-edgeFactor, pos.y));
            edges.add(new Coord(battleFieldWidth + edgeFactor, pos.y));

            for (Coord edge : edges)
            {
                double distSq = Math.pow(xPos - edge.x, 2) + Math.pow(yPos - edge.y, 2);
                pos.value += 1.0 / distSq;
            }

            // avoid crossfire
            if (others > 2)
            {
                //double distSq = Math.pow(xPos - battleFieldWidth / 2, 2) + Math.pow(yPos - battleFieldHeight / 2, 2);
                meanPos.x = meanPos.x * 4.0 / 5.0 + (battleFieldWidth / 2) / 5.0;
                meanPos.y = meanPos.y * 4.0 / 5.0 + (battleFieldHeight / 2) / 5.0;
                double distSq = Math.pow(xPos - meanPos.x, 2) + Math.pow(yPos - meanPos.y, 2);
                pos.value += 1.0 / distSq;
                distSq = Math.pow(xPos - m_avoidPos.x, 2) + Math.pow(yPos - m_avoidPos.y, 2);
                pos.value += 1.0 / distSq;
            }
            else if (others == 2)
            {
                double distSq = Math.pow(xPos - meanPos.x, 2) + Math.pow(yPos - meanPos.y, 2);
                pos.value += 1.0 / distSq;
            }
            // better surfing
            else if (safePos.value < 1)
            {
                double distSq = Math.pow(xPos - safePos.x, 2) + Math.pow(yPos - safePos.y, 2);
                pos.value -= 0.9 / Math.max(distSq, 35);
            }

            if (others == 1 && !catAndMouse)
            {
                // avoid corners
                double factor = 90;
                pos.value +=   1.0 / (Math.pow(xPos + factor, 2) + Math.pow(yPos + factor, 2))
                             + 1.0 / (Math.pow(xPos + factor, 2) + Math.pow(yPos - factor - battleFieldHeight, 2))
                             + 1.0 / (Math.pow(xPos - factor - battleFieldWidth, 2) + Math.pow(yPos + factor, 2))
                             + 1.0 / (Math.pow(xPos - factor - battleFieldWidth, 2) + Math.pow(yPos - factor - battleFieldHeight, 2));
            }
            destinations.add(pos);
        }


        if (others == 1 && wallBounded) // allowed to move less
        {
            for (double ang = Math.PI * 2; ang > 0; ang -= (Math.PI / 8))
            {
                if (   others == 1
                    && !bulletWaves.isEmpty()
                    && (   Math.abs(Utils.normalRelativeAngle(ang - otherAng)) < 1
                        || Math.abs(Utils.normalRelativeAngle(ang - otherAng - Math.PI)) < 0.8 ) )
                {
                    continue;
                }
                double xPos = FastMath.sin(ang) * 37.0 + nextX;
                double yPos = FastMath.cos(ang) * 37.0 + nextY;
                double buffer = 0.5;
                if (   xPos < getWidth() * buffer
                    || xPos > battleFieldWidth - getWidth() * buffer
                    || yPos < getHeight() * buffer
                    || yPos > battleFieldHeight - getHeight() * buffer )
                {
                    continue;
                }
                Coord pos = new Coord(xPos, yPos);
                for (Bot bot : enemyBots)
                {
                    if (!bot.isAlive)
                    {
                        continue;
                    }
                    double distSq = /*Math.sqrt(*/Math.pow(xPos - bot.x, 2) + Math.pow(yPos - bot.y, 2)/*)*/;
                    if (bot.energy <= 0.3 || (catAndMouse && bot.energy < 1.6))
                        distSq = -distSq; // ram weak bots
                    pos.value += 1.0 / distSq;
                }
                for (Coord bullet : bullets)
                {
                    double distSq = /*Math.sqrt(*/Math.pow(xPos - bullet.x, 2) + Math.pow(yPos - bullet.y, 2)/*)*/;
                    pos.value += 1.0 / distSq;
                }

                Vector<Coord> edges = new Vector<Coord>();
                edges.add(new Coord(pos.x, -edgeFactor));
                edges.add(new Coord(pos.x, battleFieldHeight + edgeFactor));
                edges.add(new Coord(-edgeFactor, pos.y));
                edges.add(new Coord(battleFieldWidth + edgeFactor, pos.y));

                for (Coord edge : edges)
                {
                    double distSq = Math.pow(xPos - edge.x, 2) + Math.pow(yPos - edge.y, 2);
                    pos.value += 1.0 / distSq;
                }

                // better surfing
                if (safePos.value < 1)
                {
                    double distSq = Math.pow(xPos - safePos.x, 2) + Math.pow(yPos - safePos.y, 2);
                    pos.value -= 0.9 / Math.max(distSq, 35);
                }
                destinations.add(pos);
            }
        }

        if (destinations.isEmpty())
        {
            System.out.printf("No destinations (%d, %d)?!\n", m_me.x, m_me.y);
            return;
        }

        Coord destination = destinations.get(0);
        Graphics2D g = getGraphics();
        if (safePos.value < 1)
        {
            g.setColor(Color.GREEN);
            g.drawRect((int)safePos.x - 5, (int)safePos.y - 5, 10, 10);
        }
        double eqVal = destination.value;
        for (Coord pos : destinations)
        {
            if (pos.value < destination.value)
            {
                destination = pos;
            }
            //System.out.println(destination.value);
            //g.setColor(new Color(1.0f, (float)(0.5 * pos.value / eqVal), 1.0f));
            //g.drawOval((int)pos.x - 5, (int)pos.y - 5, 10, 10);
            if (pos.value > eqVal)
                eqVal = pos.value;
        }
        eqVal -= destination.value;
        for (Coord pos : destinations)
        {
            g.setColor(Color.getHSBColor((float)(0.66 * (pos.value - destination.value) / eqVal + 0.33), 1.0f, 1.0f));
            g.drawOval((int)pos.x - 5, (int)pos.y - 5, 10, 10);
        }
        moveTo(destination.x, destination.y);
        doThrottle();

        int botCount = 0;
        for (Bot bot : enemyBots)
        {
            if (bot.isAlive)
                botCount++;
        }
        if (botCount > others)
        {
            for (Bot bot : enemyBots)
            {
                bot.isAlive = false; // kill zombies
            }
            System.out.println("Zombie?!");
        }
    }

    /**
     * onHitByBullet: What to do when you're hit by a bullet
     */
    public void onHitByBullet(HitByBulletEvent e)
    {
        for (Wave wave : bulletWaves)
        {
            if (!e.getName().equals(wave.from.name))
                continue;
            double dist = Math.sqrt(Math.pow(wave.origin.x - wave.target.x, 2) + Math.pow(wave.origin.y - wave.target.y, 2));
            if (Math.abs(wave.getRadius(e.getTime()) - dist) < 18.8)
            {
                double offset = Utils.normalRelativeAngle(FastMath.atan2(wave.target.x - wave.origin.x, wave.target.y - wave.origin.y) - wave.angles[0]);
                offset /= wave.angles[1];
                wave.from.pushStat(offset, wave.dirChanged(), wave.avTargVelocity, wave.targCirc.power < -0.5);
                break;
            }
        }
    }

    /**
     * onBulletHitBullet: What to do when bullets hit each other
     */
    public void onBulletHitBullet(BulletHitBulletEvent e)
    {
        if (others != 1 || bulletWaves == null || bulletWaves.isEmpty())
            return;
        for (int i = bulletWaves.size() - 1; i >= 0; i--)
        {
            Wave wave = bulletWaves.get(i);
            if (!wave.from.name.equals(e.getHitBullet().getName()))
                continue;
            double dist = Math.sqrt(Math.pow(wave.origin.x - e.getHitBullet().getX(), 2) + Math.pow(wave.origin.y - e.getHitBullet().getY(), 2));
            if (Math.abs(wave.getRadius(e.getTime()) - dist) < 15)
            {
                double offset = Utils.normalRelativeAngle(FastMath.atan2(e.getHitBullet().getX() - wave.origin.x, e.getHitBullet().getY() - wave.origin.y) - wave.angles[0]);
                offset /= wave.angles[1];
                wave.from.pushStat(offset, wave.dirChanged(), wave.avTargVelocity, wave.targCirc.power < -0.5);
                bulletWaves.remove(i);
                break;
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e)
    {
        /*for (Bot bot : enemyBots)
        {
            if (bot.history.size() > 2000)
                bot.history.subList(0, bot.history.size() - 2000).clear();
        }*/
        m_skippedTurns++;
        if (m_skippedTurns > 2)
            m_depthLimit++;
    }

    public void doTarget()
    {
        /*Vector<Coord> sectors = new Vector<Coord>();
        for (Bot targ : enemyBots)
        {
            if (!targ.isAlive)
            {
                continue;
            }
            Coord pos = new Coord(targ.x, targ.y);
            pos.value = 1.0 / (Math.pow(targ.x - getX(), 2) + Math.pow(targ.y - getY(), 2));
            for (Bot bot : enemyBots)
            {
                if (!bot.isAlive || bot == targ)
                {
                    continue;
                }
                double distSq = Math.pow(targ.x - bot.x, 2) + Math.pow(targ.y - bot.y, 2);
                pos.value += 1.0 / distSq;
            }
            sectors.add(pos);
        }
        if (sectors.isEmpty())
            return;
        Coord targetSector = sectors.get(0);
        for (Coord sector : sectors)
        {
            if (sector.value > targetSector.value)
            {
                targetSector = sector;
            }
        }
        Bot target = enemyBots.get(0);
        double distSq = Math.pow(targetSector.x - target.x, 2) + Math.pow(targetSector.y - target.y, 2);
        for (Bot bot : enemyBots)
        {
            if (!bot.isAlive)
            {
                continue;
            }
            double botDistSq = Math.pow(targetSector.x - bot.x, 2) + Math.pow(targetSector.y - bot.y, 2);
            if (!target.isAlive || botDistSq < distSq)
            {
                target = bot;
                distSq = botDistSq;
            }
        }*/

        Vector<Coord> targets = new Vector<Coord>();
        for (Bot bot : enemyBots)
        {
            if (!bot.isAlive)
                continue;
            double distSq = Math.pow(bot.x - getX(), 2) + Math.pow(bot.y - getY(), 2);
            double power = (others > 3 ? 3 : Math.min(others == 1 ? bot.energy / 4 : bot.energy / 2, distSq < 40000 ? 3 : 2));
            if (power > 2 && m_me.energy < 28)
                power = 2;
            if (m_me.energy < 8)
                power = Math.min(0.3, power);
            else if (m_me.energy < 18)
                power = Math.min(1, power);
            if (catAndMouse)
            {
                if (bot.energy < 1.5)
                {
                    setTurnGunRightRadians(Math.PI);
                    return;
                }
                else if (bot.energy < 4)
                    power = 0.1;
                else
                    power = 0.3;
            }
            //Coord pos = targetPattern(bot, power);
            Vector<Coord> positions = targetKNN(bot, power);
            for (Coord pos : positions)
            {
                pos.value = bot.energy; //1.0 / (Math.pow(pos.x - getX(), 2) + Math.pow(pos.y - getY(), 2));
                pos.power = power;
                targets.add(pos);
            }
        }

        if (targets.isEmpty()) // ??
        {
            //if (others != 0)
                //System.out.println("No targets?!");
            return;
        }

        /*Coord target = targets.get(0);
        for (Coord targ : targets)
        {
            for (Coord pos : targets)
            {
                if (pos == targ)
                    continue;
                double ratio = 1.0 / (Math.pow(pos.x - targ.x, 2) + Math.pow(pos.y - targ.y, 2));
                // limit influence
                targ.value += (ratio > 0.12 ? 0.12 : ratio);
            }
            if (targ.value > target.value)
                target = targ;
        }*/

        //Coord target = targets.get(0);
        double[] angles = new double[others > 10 ? 400 : others > 6 ? 550 : 710];

        double nextX = getX() + FastMath.sin(m_me.heading) * m_me.velocity * 0.3;
        double nextY = getY() + FastMath.cos(m_me.heading) * m_me.velocity * 0.3;
        //double angle = Utils.normalAbsoluteAngle(Math.atan2(target.x - nextX, target.y - nextY));

        Graphics2D g = getGraphics();
        for (Coord targ : targets)
        {
            double dist = Math.sqrt(Math.pow(targ.x - nextX, 2) + Math.pow(targ.y - nextY, 2));
            double delta = FastMath.atan2(120, dist);
            double angle = Utils.normalAbsoluteAngle(FastMath.atan2(targ.x - nextX, targ.y - nextY));
            double factor = angles.length / (2 * Math.PI);
            //double multiplier = Math.max(battleFieldWidth, battleFieldHeight) - 0.2 * dist;
            //double multiplier = Math.min(150.0 / dist + 1, 5.0);
            double multiplier = (others == 1 ? 0 : 220.0 / dist) + 1;
            int min = (int)((angle - delta) * factor);
            int max = (int)((angle + delta) * factor);
            //double intercept = Math.pow(max - min, 2);
            //multiplier /= intercept - 2 * Math.pow((max - min) / 2.0, 2); // max
            double sDev = delta * factor / 2.6;
            if (targ.value < 26) // weak bot
            {
                multiplier *= 1.5;
                if (targ.value < 21)
                {
                    multiplier *= 1.6;
                    if (targ.value < 14)
                        multiplier *= 3.1;
                }
            }
            //int minSq = min * min;
            //int maxSq = max * max;
            for (int i = min; i < max; i++)
            {
                //angles[(i + angles.length) % angles.length] += multiplier * (intercept - Math.pow(min - i, 2) - Math.pow(max - i, 2));
                angles[(i + angles.length) % angles.length] += multiplier * Math.pow(Math.E, -0.5 * Math.pow((i - angle * factor) / sDev, 2)) / sDev;
                //angles[(i + angles.length) % angles.length] += multiplier * (intercept - minSq - maxSq + 2 * i * (min + max - i));
            }
            //angles[(int)(angle * factor) % angles.length] += 0.2 * multiplier;
            /*for (Coord pos : targets)
            {
                if (pos == targ)
                    continue;
                double ratio = 1.0 / (Math.pow(pos.x - targ.x, 2) + Math.pow(pos.y - targ.y, 2));
                // limit influence
                targ.value += (ratio > 0.12 ? 0.12 : ratio);
            }
            if (targ.value > target.value)
                target = targ;*/
            g.setColor(new Color(255, 0, 0, 90)); // red
            g.fillRect((int)targ.x - 5, (int)targ.y - 5, 10, 10);
        }

        Vector<Coord> heatMap = new Vector<Coord>();
        double minHeat = Double.POSITIVE_INFINITY;
        double maxHeat = Double.NEGATIVE_INFINITY;
        for (double ang = Math.PI * 2; ang > 0; ang -= (Math.PI / 20))
        {
            double xPos = FastMath.sin(ang) * 110.0 + m_me.x;
            double yPos = FastMath.cos(ang) * 110.0 + m_me.y;
            double buffer = 10;
            if (   xPos < buffer
                || xPos > battleFieldWidth - buffer
                || yPos < buffer
                || yPos > battleFieldHeight - buffer )
            {
                continue;
            }
            Coord pos = new Coord(xPos, yPos);
            int i = (int)(ang * angles.length / (2 * Math.PI));
            //System.out.println((i - 6 + angles.length) % angles.length);
            pos.value  =   angles[(i - 6 + angles.length) % angles.length] * 0.01
                         + angles[(i - 5 + angles.length) % angles.length] * 0.03
                         + angles[(i - 4 + angles.length) % angles.length] * 0.09
                         + angles[(i - 3 + angles.length) % angles.length] * 0.2
                         + angles[(i - 2 + angles.length) % angles.length] * 0.6
                         + angles[(i - 1 + angles.length) % angles.length] * 0.7
                         + angles[i % angles.length]
                         + angles[(i + 1) % angles.length] * 0.7
                         + angles[(i + 2) % angles.length] * 0.6
                         + angles[(i + 3) % angles.length] * 0.2
                         + angles[(i + 4) % angles.length] * 0.09
                         + angles[(i + 5) % angles.length] * 0.03
                         + angles[(i + 6) % angles.length] * 0.01;
            heatMap.add(pos);
            if (pos.value < minHeat)
                minHeat = pos.value;
            if (pos.value > maxHeat)
                maxHeat = pos.value;
        }
        maxHeat -= minHeat;

        for (Coord pos : heatMap)
        {
            Color solid = Color.getHSBColor((float)(0.66 * (pos.value - minHeat) / maxHeat + 0.33), 1.0f, 1.0f);
            g.setColor(new Color(solid.getRed(), solid.getBlue(), solid.getGreen(), 80));
            g.fillRect((int)pos.x - 5, (int)pos.y - 5, 10, 10);
        }


        int index = 0;
        double value = 0;
        for (int i = 0; i < angles.length; i++)
        {
            double val =   angles[(i - 6 + angles.length) % angles.length] * 0.01
                         + angles[(i - 5 + angles.length) % angles.length] * 0.03
                         + angles[(i - 4 + angles.length) % angles.length] * 0.09
                         + angles[(i - 3 + angles.length) % angles.length] * 0.2
                         + angles[(i - 2 + angles.length) % angles.length] * 0.6
                         + angles[(i - 1 + angles.length) % angles.length] * 0.7
                         + angles[i]
                         + angles[(i + 1) % angles.length] * 0.7
                         + angles[(i + 2) % angles.length] * 0.6
                         + angles[(i + 3) % angles.length] * 0.2
                         + angles[(i + 4) % angles.length] * 0.09
                         + angles[(i + 5) % angles.length] * 0.03
                         + angles[(i + 6) % angles.length] * 0.01;
            if (val > value)
            {
                index = i;
                value = val;
            }
        }

        /*int angle = 0;
        for (int i = 1; i < angles.length; i++)
        {
            if (angles[i] > angles[angle])
                angle = i;
        }*/


        //Graphics2D g = getGraphics();
        //g.setColor(Color.RED);
        //g.drawRect((int)target.x - 5, (int)target.y - 5, 10, 10);

        //double nextX = getX() + Math.sin(m_me.heading) * m_me.velocity * 0.3;
        //double nextY = getY() + Math.cos(m_me.heading) * m_me.velocity * 0.3;
        //double angle = Utils.normalAbsoluteAngle(Math.atan2(target.x - nextX, target.y - nextY));
        //setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));

        double angle = index * 2.0 * Math.PI / angles.length;
        //Graphics2D g = getGraphics();
        g.setColor(new Color(255, 0, 0, 90));
        g.drawLine((int)(m_me.x), (int)(m_me.y), (int)(m_me.x + 1000 * FastMath.sin(angle)), (int)(m_me.y + 1000 * FastMath.cos(angle)));

        setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));
        if(getGunHeat() == 0 && getEnergy() > 3 && Math.abs(getGunTurnRemaining()) < 12)
        {
            setFire(targets.get(0).power);//target.power);
        }

        /*Graphics2D g = getGraphics();
        g.setColor(Color.RED);
        g.drawRect((int)target.x - 5, (int)target.y - 5, 10, 10);

        double power = (others > 3 ? 3 : Math.min(target.energy / 4, 2));

        Coord pos = targetPattern(target, power);//(getGunHeat() == 0 ? targetPattern(target, power) : targetCircular(target, power));

        double angle = Utils.normalAbsoluteAngle(Math.atan2(pos.x - getX(), pos.y - getY()));
        setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));
        if(getGunHeat() == 0 && getEnergy() > 3)
        {
            setFire(power);
        }*/
    }

    public static Coord targetCircular(Bot bot, double power, Bot from)
    {
        double time = 0;

        Coord pred = new Coord(bot.x, bot.y);

        double botHeading = bot.heading;
        double botHeadingChange = 0.0;
        if (bot.history != null && bot.history.size() > 1)
        {
            botHeadingChange = bot.heading - bot.history.get(bot.history.size() - 2).heading; //enemyBotsLast.get(enemyBots.indexOf(bot)).heading;
        }

        while( (++time) * (20.0 - 3.0 * power) <
               Math.sqrt(Math.pow(from.x - pred.x, 2) + Math.pow(from.y - pred.y, 2)) )
        {
            pred.x += FastMath.sin(botHeading) * bot.averageVelocity;
            pred.y += FastMath.cos(botHeading) * bot.averageVelocity;
            botHeading += botHeadingChange;
            if(   pred.x < 17.0 || pred.y < 17.0
               || pred.x > battleFieldWidth - 17.0 || pred.y > battleFieldHeight - 17.0 )
            {
                pred.x = Math.min(Math.max(17.0, pred.x), battleFieldWidth - 17.0);
                pred.y = Math.min(Math.max(17.0, pred.y), battleFieldHeight - 17.0);
                pred.power = -1;
                break; // bots can't escape the field!
            }
        }

        return pred;
    }

    public Coord targetPattern(Bot bot, double power)
    {
        if (bot.history.size() < 30)
        {
            return targetCircular(bot, power, m_me);
        }
        for (int i = (others == 1 ? 34 : others < 4 ? 28 : others < 6 ? 20 : others < 9 ? 15 : 10); i > 4; i -= 7)
        //for (int i = (others == 1 ? 34 : others < 3 ? 29 : others < 5 ? 23 : others < 9 ? 17 : 11); i > 4; i -= 6)
        {
            Coord pred = doTargetPattern(bot, power, i);
            if (pred.x > 0)
            {
                return pred;
            }
        }
        return targetCircular(bot, power, m_me);
    }

    public Coord doTargetPattern(Bot bot, double power, int matchLength)
    {
        //double myX = getX();
        //double myY = getY();
        matchLength -= m_depthLimit;

        for (int i = bot.history.size() - 30; i > matchLength + 1; i--)
        {
            boolean matches = true;
            for (int j = 0; j < matchLength; j++)
            {
                double headingChangeA =   bot.history.get(bot.history.size() - j - 1).heading
                                        - bot.history.get(bot.history.size() - j - 2).heading;
                double headingChangeB =   bot.history.get(i - j).heading
                                        - bot.history.get(i - j - 1).heading;
                if (   !doubleEquals(headingChangeA, headingChangeB)
                    || !doubleEquals(bot.history.get(bot.history.size() - j - 1).velocity,
                                     bot.history.get(i - j).velocity) )
                {
                    matches = false;
                    break;
                }
            }
            if (matches)
            {
                /*Coord pred = new Coord(bot.x, bot.y);
                int time = 0;
                double botHeading = bot.heading;
                while( (++time) * (20.0 - 3.0 * power) <
                       Math.sqrt(Math.pow(myX - pred.x, 2) + Math.pow(myY - pred.y, 2)) )
                {
                    botHeading += bot.history.get(i + time + 1).heading - bot.history.get(i + time).heading;
                    pred.x += Math.sin(botHeading) * bot.history.get(i + time).velocity;
                    pred.y += Math.cos(botHeading) * bot.history.get(i + time).velocity;


                    Graphics2D g = getGraphics();
                    g.setColor(Color.BLUE);
                    g.drawRect((int)pred.x - 3, (int)pred.y - 3, 6, 6);


                    if(   pred.x < 17.0 || pred.y < 17.0
                       || pred.x > battleFieldWidth - 17.0 || pred.y > battleFieldHeight - 17.0
                       || i + time + 2 == bot.history.size() )
                    {
                        pred.x = Math.min(Math.max(17.0, pred.x), battleFieldWidth - 17.0);
                        pred.y = Math.min(Math.max(17.0, pred.y), battleFieldHeight - 17.0);
                        break; // bots can't escape the field!
                    }
                }
                return pred;*/
                return doTargetInterpolate(bot, power, i);
            }
        }
        return new Coord(-1, -1);
    }

    public Vector<Coord> targetKNN(Bot bot, double power)
    {
        double point[] = bot.getPoint(/*bot.history.size() - 1*/);
        NearestNeighborIterator<Integer> it = bot.tree.getNearestNeighborIterator(point, others == 1 ? 28 : others > 8 ? 8 : 15, new SquareEuclideanDistanceFunction());

        Vector<Coord> targets = new Vector<Coord>();
        while (it.hasNext())
        {
            int index = it.next();
            if (index + 30 < bot.history.size())
            {
                targets.add(doTargetInterpolate(bot, power, index));
                if (bot.history.size() < 80)
                {
                    if (targets.size() > 0)
                        break;
                }
                else if (others > 5)
                {
                    if (targets.size() > 5)
                        break;
                }
                else if (others > 2)
                {
                    if (targets.size() > 7)
                        break;
                }
                else if (others == 2)
                {
                    if (targets.size() > 10)
                        break;
                }
            }
        }

        if (targets.isEmpty() || bot.history.size() < 100)
            targets.add(targetCircular(bot, power, m_me));

        return targets;
    }

    public Coord doTargetInterpolate(Bot bot, double power, int index)
    {
        Coord pred = new Coord(bot.x, bot.y);
        int time = 0;
        double botHeading = bot.heading;
        Graphics2D g = getGraphics();
        while( (++time) * (20.0 - 3.0 * power) <
               Math.sqrt(Math.pow(m_me.x - pred.x, 2) + Math.pow(m_me.y - pred.y, 2)) )
        {
            botHeading += bot.history.get(index + time + 1).heading - bot.history.get(index + time).heading;
            pred.x += FastMath.sin(botHeading) * bot.history.get(index + time).velocity;
            pred.y += FastMath.cos(botHeading) * bot.history.get(index + time).velocity;


            //g.setColor(Color.BLUE);
            g.setColor(new Color(0, 0, 255, 30)); // blue
            g.drawRect((int)pred.x - 3, (int)pred.y - 3, 6, 6);


            if(   /*pred.x < 17.0 || pred.y < 17.0
               || pred.x > battleFieldWidth - 17.0 || pred.y > battleFieldHeight - 17.0
               ||*/ index + time + 2 == bot.history.size() )
            {
                //pred.x = Math.min(Math.max(17.0, pred.x), battleFieldWidth - 17.0);
                //pred.y = Math.min(Math.max(17.0, pred.y), battleFieldHeight - 17.0);
                break; // bots can't escape the field!
            }
        }

        if(   pred.x < 17.0 || pred.y < 17.0
           || pred.x > battleFieldWidth - 17.0 || pred.y > battleFieldHeight - 17.0 )
        {
            pred.x = Math.min(Math.max(17.0, pred.x), battleFieldWidth - 17.0);
            pred.y = Math.min(Math.max(17.0, pred.y), battleFieldHeight - 17.0);
            // bots can't escape the field!
        }

        return pred;
    }

    public boolean doubleEquals(double a, double b)
    {
        double matchAccuracy = (others > 2 ? 0.2 : 0.1);
        return (Math.abs(a - b) < matchAccuracy);
    }

    /*public Coord targetCluster(Bot bot, double power)
    {
        return new Coord(-1, -1);
    }*/

    /**
     * doScan: smart scan for greatest coverage
     */
    public void doScan(long time)
    {
        for (Bot bot : enemyBots)
        {
            if (bot.isAlive && time - bot.time > 12)
            {
                setTurnRadarRightRadians(Math.PI / 4);
                return;
            }
        }
        switch (others)
        {
            case 1:
                int index = -1;
                for (int i = 0; i < enemyBots.size(); i++)
                {
                    if (enemyBots.get(i).isAlive)
                    {
                        index = i;
                        break;
                    }
                }
                if (index == -1)
                {
                    setTurnRadarRightRadians(Math.PI / 4);
                }
                else
                {
                    Bot bot = enemyBots.get(index);
                    double bearingFromRadar = Utils.normalRelativeAngle(FastMath.atan2(bot.x - getX(), bot.y - getY()) - getRadarHeadingRadians());
                    setTurnRadarRightRadians(bearingFromRadar * 1.1);
                }
                break;

            case 2:
            {
                if (enemyBots.isEmpty())
                {
                    setTurnRadarRightRadians(Math.PI / 4);
                    break;
                }
                int countOthers = 0;
                Bot bot1 = enemyBots.get(0);
                Bot bot2 = enemyBots.get(0);
                for (Bot bot : enemyBots)
                {
                    if (bot.isAlive)
                    {
                        countOthers++;
                        if (bot1.isAlive)
                        {
                            bot2 = bot;
                        }
                        else
                        {
                            bot1 = bot;
                        }
                    }
                }
                if (others == countOthers)
                {
                    double bearingFromRadar1 = 1.05 * Utils.normalRelativeAngle(FastMath.atan2(bot1.x - getX(), bot1.y - getY()) - getRadarHeadingRadians());
                    double bearingFromRadar2 = 1.05 * Utils.normalRelativeAngle(FastMath.atan2(bot2.x - getX(), bot2.y - getY()) - getRadarHeadingRadians());
                    if (bot1.time == bot2.time)
                    {
                        if (Math.abs(bearingFromRadar1) > Math.abs(bearingFromRadar2))
                        {
                            setTurnRadarRightRadians(bearingFromRadar1);
                        }
                        else
                        {
                            setTurnRadarRightRadians(bearingFromRadar1);
                        }
                    }
                    else if (bot1.time < bot2.time)
                    {
                        setTurnRadarRightRadians(bearingFromRadar1);
                    }
                    else
                    {
                        setTurnRadarRightRadians(bearingFromRadar2);
                    }
                }
                else
                {
                    setTurnRadarRightRadians(Math.PI / 4);
                }
                break;
            }

            default:
                int countOthers = 0;
                for (Bot bot : enemyBots)
                {
                    if (bot.isAlive)
                    {
                        countOthers++;
                    }
                }
                if (others == countOthers)
                {
                    double xDelta = (getX() + battleFieldWidth / 2)  % battleFieldWidth  - battleFieldWidth / 2;
                    double yDelta = (getY() + battleFieldHeight / 2) % battleFieldHeight - battleFieldHeight / 2;
                    Coord wall;
                    if (Math.abs(xDelta) < Math.abs(yDelta))
                    {
                        wall = new Coord(xDelta < 0 ? battleFieldWidth + xDelta : xDelta,
                                         yDelta < 0 ? battleFieldHeight : 0);
                    }
                    else
                    {
                        wall = new Coord(xDelta < 0 ? battleFieldWidth : 0,
                                         yDelta < 0 ? battleFieldHeight + yDelta: yDelta);
                    }
                    double wallAng = FastMath.atan2(wall.x - getX(), wall.y - getY());
                    double posAng  = 2 * Math.PI;
                    double negAng  = -2 * Math.PI;
                    for (Bot bot : enemyBots)
                    {
                        if (!bot.isAlive)
                        {
                            continue;
                        }
                        double angP = Utils.normalAbsoluteAngle(FastMath.atan2(bot.x - getX(), bot.y - getY()) - wallAng);
                        double angN = angP - 2 * Math.PI;
                        if (angP < posAng)
                        {
                            posAng = angP;
                        }
                        if (angN > negAng)
                        {
                            negAng = angN;
                        }
                    }
                    if (posAng - negAng > Math.PI * 1.5)
                    {
                        posAng = Utils.normalAbsoluteAngle(posAng + wallAng);
                        negAng = Utils.normalAbsoluteAngle(negAng + wallAng);
                        double radarBearing = getRadarHeadingRadians();
                        double posBearing = Utils.normalRelativeAngle(posAng - radarBearing) * 1.2;
                        double negBearing = Utils.normalRelativeAngle(negAng - radarBearing) * 1.2;
                        if (radarBearing < negAng && radarBearing > posAng)
                        {
                            if (Math.abs(getRadarTurnRemainingRadians()) < Math.PI / 5)
                            {
                                if (Math.abs(posBearing) > Math.abs(negBearing))
                                {
                                    setTurnRadarRightRadians(posBearing);
                                }
                                else
                                {
                                    setTurnRadarRightRadians(negBearing);
                                }
                            }
                        }
                        else
                        {
                            if (Math.abs(posBearing) > Math.abs(negBearing))
                            {
                                setTurnRadarRightRadians(negBearing);
                            }
                            else
                            {
                                setTurnRadarRightRadians(posBearing);
                            }
                        }
                        break;
                    }
                }
                setTurnRadarRightRadians(Math.PI / 4);
                break;
        }

    }

    public void doDraw()
    {
        Graphics2D g = getGraphics();
        for (Bot bot : enemyBots)
        {
            if (bot.isAlive)
                g.setColor(Color.GREEN);
            else
                g.setColor(Color.RED);
            g.drawRect((int)bot.x - 18, (int)bot.y - 18, 36, 36);
        }
        g.setColor(Color.RED);
        for (Bot bot : enemyBots)
        {
            if (!bot.isAlive)
                continue;
            for (int out = 0; out < 2; out++)
            {
                for (int dir = 0; dir < 2; dir++)
                {
                    for (int set = 0; set < 4; set++)
                    {
                        for (int i = 0; i < 40; i++)
                        {
                            g.drawRect(10 + i * 4 + set * 200, 10 + dir * 50 + out * 100, 4, (int)(bot.stats[out][dir][set][i] * 400));
                        }
                    }
                }
            }
            break;
        }
        if (bulletWaves != null)
        for (Wave wave : bulletWaves)
        {
            double radius = wave.getRadius(getTime());
            g.drawOval((int)(wave.origin.x - radius), (int)(wave.origin.y - radius), (int)(2 * radius), (int)(2 * radius));
            g.drawLine((int)(wave.origin.x), (int)(wave.origin.y), (int)(wave.origin.x + radius * FastMath.sin(wave.getAngle())), (int)(wave.origin.y + radius * FastMath.cos(wave.getAngle())));
        }

        if (m_rollingPos != null)
        {
            g.setColor(new Color(0, 0, 255, 50)); // blue
            g.fillRect((int)m_rollingPos.x - 8, (int)m_rollingPos.y - 8, 16, 16);
            g.setColor(new Color(255, 0, 0, 50)); // red
            g.fillRect((int)m_avoidPos.x - 8, (int)m_avoidPos.y - 8, 16, 16);
        }
    }

    /**
     * moveTo: drive to a certain point (within bounds)
     */
    public void moveTo(double x, double y)
    {
        double buffer = 0.5;
        if (x < getWidth() * buffer)
        {
            x = getWidth() * buffer;
        }
        if (x > battleFieldWidth - getWidth() * buffer)
        {
            x = battleFieldWidth - getWidth() * buffer;
        }
        if (y < getHeight() * buffer)
        {
            y = getHeight() * buffer;
        }
        if (y > battleFieldHeight - getHeight() * buffer)
        {
            y = battleFieldHeight - getHeight() * buffer;
        }
        double targAng = Utils.normalAbsoluteAngle(FastMath.atan2(x - getX(), y - getY()));
        double dist = Math.sqrt(Math.pow(x - getX(), 2) + Math.pow(y - getY(), 2));
        if (Math.abs(Utils.normalRelativeAngle(targAng - getHeadingRadians())) < Math.PI / 2)
        {
            setTurnRightRadians(Utils.normalRelativeAngle(targAng - getHeadingRadians()));
            setAhead(dist);
        }
        else
        {
            setTurnRightRadians(Utils.normalRelativeAngle(targAng - getHeadingRadians() + Math.PI));
            setBack(dist);
        }

        Graphics2D g = getGraphics();
        g.setColor(Color.CYAN);
        g.drawLine((int)x, (int)y, (int)getX(), (int)getY());
    }

    public void doThrottle()
    {
        double velocity = Rules.MAX_VELOCITY;
        boolean right = getDistanceRemaining() > 0 ^ getTurnRemaining() < 0;
        Coord projPos = new Coord(getX() + FastMath.sin(getHeadingRadians()) * getDistanceRemaining(),
                                  getY() + FastMath.cos(getHeadingRadians()) * getDistanceRemaining());

        double buffer = getWidth() * 0.5;
        if (projPos.x < buffer)
        {
            velocity =   Rules.MAX_TURN_RATE_RADIANS * (getX() - buffer)
                       / (1 - FastMath.sin(getHeadingRadians() + Math.PI / (right ? 2 : -2)));
        }
        else if (projPos.y < buffer)
        {
            velocity =   Rules.MAX_TURN_RATE_RADIANS * (getY() - buffer)
                       / (1 - FastMath.cos(getHeadingRadians() + Math.PI / (right ? 2 : -2)));
        }
        else if (projPos.x > battleFieldWidth - buffer)
        {
            velocity =   Rules.MAX_TURN_RATE_RADIANS * (getX() + buffer - battleFieldWidth)
                       / (1 - FastMath.sin(getHeadingRadians() + Math.PI / (right ? 2 : -2)));
        }
        else if (projPos.y > battleFieldHeight - buffer)
        {
            velocity =   Rules.MAX_TURN_RATE_RADIANS * (getY() + buffer - battleFieldHeight)
                       / (1 - FastMath.cos(getHeadingRadians() + Math.PI / (right ? 2 : -2)));
        }
        velocity = Math.min(Math.abs(velocity), Rules.MAX_VELOCITY);
        setMaxVelocity(velocity);

        double radius = velocity / Rules.MAX_TURN_RATE_RADIANS;
        Coord center = new Coord(FastMath.sin(getHeadingRadians() + Math.PI / (right ? 2 : -2)) * radius + getX(),
                                 FastMath.cos(getHeadingRadians() + Math.PI / (right ? 2 : -2)) * radius + getY());
        radius += getWidth() / 2 + .1;

        Graphics2D g = getGraphics();
        g.setColor(Color.BLACK);
        g.drawOval((int)(center.x - radius), (int)(center.y - radius), (int)(radius * 2), (int)(radius * 2));
    }

}


/// Rednaxela's FastTrig

class FastMath {
   public static final double PI        = 3.1415926535897932384626433832795D;
   public static final double TWO_PI    = 6.2831853071795864769252867665590D;
   public static final double HALF_PI   = 1.5707963267948966192313216916398D;
   public static final double QUARTER_PI = 0.7853981633974483096156608458199D;
   public static final double THREE_OVER_TWO_PI = 4.7123889803846898576939650749193D;


   /*public static void main(String[] args){
   //accuracy test
      double maxdiff = 0;
      double sum = 0;
      double dv = 0;
      for(int i = 0; i < 500000; i++){
         double p = (i-250000)*(1.571/250000);
         double diff = Math.abs((Math.atan(p) - atan(p)));
         sum += diff;
         if(diff > maxdiff){
            maxdiff = diff;
            dv = p;
         }
      }
      System.out.println(maxdiff);
      System.out.println(dv);
      System.out.println(sum);
   }*/
   public static final double sin(double d) {
      d += Math.PI;
      double x2 = Math.floor(d*(1/(2*Math.PI)));
      d -= x2*(2*Math.PI);
      d-=Math.PI;

      x2 = d * d;


      return //accurate to 6.82e-8, 3.3x faster than Math.sin,
         //faster than lookup table in real-world conditions due to no cache misses
         //all values from "Fast Polynomial Approximations to Sine and Cosine", Garret, C. K., 2012
         (((((-2.05342856289746600727e-08*x2 + 2.70405218307799040084e-06)*x2
         - 1.98125763417806681909e-04)*x2 + 8.33255814755188010464e-03)*x2
         - 1.66665772196961623983e-01)*x2 + 9.99999707044156546685e-01)*d;
   }


   public static final double cos(double d) {
      d += Math.PI;
      double x2 = Math.floor(d*(1/(2*Math.PI)));
      d -= x2*(2*Math.PI);
      d-=Math.PI;

      d *= d;

      return //max error 5.6e-7, 4x faster than Math.cos,
         //faster than lookup table in real-world conditions due to less cache misses
         //all values from "Fast Polynomial Approximations to Sine and Cosine", Garret, C. K., 2012
         ((((- 2.21941782786353727022e-07*d + 2.42532401381033027481e-05)*d
         - 1.38627507062573673756e-03)*d + 4.16610337354021107429e-02)*d
         - 4.99995582499065048420e-01)*d + 1;
   }

   /*public static final double sinInBounds(double d) {
      double x2 = d * d;

      return //accurate to 6.82e-8, better than 3.3x faster than Math.sin,
         //faster than lookup table in real-world conditions due to less cache misses
         //all values from "Fast Polynomial Approximations to Sine and Cosine", Garret, C. K., 2012
         (((((-2.05342856289746600727e-08*x2 + 2.70405218307799040084e-06)*x2
         - 1.98125763417806681909e-04)*x2 + 8.33255814755188010464e-03)*x2
         - 1.66665772196961623983e-01)*x2 + 9.99999707044156546685e-01)*d;
   }

   public static final double cosInBounds(double d) {

      d *= d;

      return //max error 5.6e-7, better than 4x faster than Math.cos,
         //faster than lookup table in real-world conditions due to less cache misses
         //all values from "Fast Polynomial Approximations to Sine and Cosine", Garret, C. K., 2012
         ((((- 2.21941782786353727022e-07*d + 2.42532401381033027481e-05)*d
         - 1.38627507062573673756e-03)*d + 4.16610337354021107429e-02)*d
         - 4.99995582499065048420e-01)*d + 9.99999443739537210853e-01;
   }*/

//Takes about 1/3 of the time of Math.tan
//chebyshev polynomials calculated with http://metamerist.com/cheby/example38.htm
   public static final double tan(double x) {
      x += HALF_PI;
      double i = Math.floor(x*(1/Math.PI));
      x -= i*(Math.PI) + HALF_PI;

      if(Math.abs(x) > 0.25*Math.PI){
         x = Math.signum(x)*HALF_PI - x;
         i = x*x;
         return  1/(x * ( 1
               + i * ( 0.33555055109755784988404247864565
               + i * ( 0.11611832804825573745353974789374
               + i * ( 0.0939748057591306776926771332915)))));
      }

      i = x*x;
      return
         x * ( 1
               + i * ( 0.33555055109755784988404247864565
               + i * ( 0.11611832804825573745353974789374
               + i * ( 0.0939748057591306776926771332915))));

   }

   /*public static final double floor(double value){
      double d = (long)value;
      if(value > 0)
         return d;
      if(value == d)
         return d;
      return d - 1;
   }*/

   public static final double asin(double value) {
   //return atan(x / Math.sqrt(1 - x*x));
      return HALF_PI - acos(value);
   }

   public static final double acos(double x){
      final double  a = 1.570758334, b = -0.212875075, c = 0.076897503, d = -0.020892330;
      if(x<0)
         return Math.PI-Math.sqrt(1+x)*(a-x*(b-x*(c-x*d)));
      return            Math.sqrt(1-x)*(a+x*(b+x*(c+x*d)));
   }


      //works on range 0 to 1 only!
   private static final double chebyshev_atan(double x) {
   // map x to range [-1, 1]
      final double xn = x * 2  -1;

   // return Chebyshev approximation
      return 0.46364760900080604
         + xn * ( 0.4005785601195767
         + xn * ( -0.07982248463207417
         + xn * ( -0.007789235359791622
         + xn * ( 0.00891247504621044))));
   }

   /*public static final double atan(double r) {
      if (r < 0.0)
         return -atan(-r);
      if (r > 1.0)
         return HALF_PI - chebyshev_atan(1.0 / r);
      return chebyshev_atan(r);
   }*/

   public static final double atan2(final double y, final double x) {
      if (x==0.0) {
         if (y==0.0)
            return 0.0; // should be Double.NaN but Math.atan2 returns 0.0 in this case;
         return (y > 0.0) ? HALF_PI : -HALF_PI;
      }
      double absX = Math.abs(x);
      double absY = Math.abs(y);

      double absAtan;
      if(absY > absX)
         absAtan = HALF_PI - chebyshev_atan(absX/absY);
      else
         absAtan = chebyshev_atan(absY/absX);

      if(x < 0)
         absAtan = PI - absAtan;

      if(y < 0)
         return -absAtan;

      return absAtan;

   }
   /*public static final double sqrt(double x){
      return Math.sqrt(x);
   //return x * (1.5d - 0.5*x* (x = Double.longBitsToDouble(0x5fe6ec85e7de30daL - (Double.doubleToLongBits(x)>>1) )) *x) * x;
   }
   public static final double normalRelativeAngle(double d){
      d += Math.PI;
      double i = Math.floor(d*(1/(2*Math.PI)));
      d -= i*(2*Math.PI);
      return d-Math.PI;
   }
   public static final double normalAbsoluteAngle(double d){
      double i = Math.floor(d*(1/(2*Math.PI)));
      d -= i*(2*Math.PI);
      return d;
   }*/
}


/// Rednaxela's kd-tree

// BinaryHeap.java
abstract class BinaryHeap<T> {
    protected static final int defaultCapacity = 64;
    private final int direction;
    private Object[] data;
    private double[] keys;
    private int capacity;
    private int size;

    protected BinaryHeap(int capacity, int direction) {
        this.direction = direction;
        this.data = new Object[capacity];
        this.keys = new double[capacity];
        this.capacity = capacity;
        this.size = 0;
    }

    public void offer(double key, T value) {
        // If move room is needed, double array size
        if (size >= capacity) {
            capacity *= 2;
            data = Arrays.copyOf(data, capacity);
            keys = Arrays.copyOf(keys, capacity);
        }

        // Insert new value at the end
        data[size] = value;
        keys[size] = key;
        siftUp(size);
        size++;
    }

    protected void removeTip() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        size--;
        data[0] = data[size];
        keys[0] = keys[size];
        data[size] = null;
        siftDown(0);
    }

    protected void replaceTip(double key, T value) {
        if (size == 0) {
            throw new IllegalStateException();
        }

        data[0] = value;
        keys[0] = key;
        siftDown(0);
    }

    @SuppressWarnings("unchecked")
    protected T getTip() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        return (T) data[0];
    }

    protected double getTipKey() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        return keys[0];
    }

    private void siftUp(int c) {
        for (int p = (c - 1) / 2; c != 0 && direction*keys[c] > direction*keys[p]; c = p, p = (c - 1) / 2) {
            Object pData = data[p];
            double pDist = keys[p];
            data[p] = data[c];
            keys[p] = keys[c];
            data[c] = pData;
            keys[c] = pDist;
        }
    }

    private void siftDown(int p) {
        for (int c = p * 2 + 1; c < size; p = c, c = p * 2 + 1) {
            if (c + 1 < size && direction*keys[c] < direction*keys[c + 1]) {
                c++;
            }
            if (direction*keys[p] < direction*keys[c]) {
                // Swap the points
                Object pData = data[p];
                double pDist = keys[p];
                data[p] = data[c];
                keys[p] = keys[c];
                data[c] = pData;
                keys[c] = pDist;
            } else {
                break;
            }
        }
    }

    public int size() {
        return size;
    }

    public int capacity() {
        return capacity;
    }

    public static final class Max<T> extends BinaryHeap<T> implements MaxHeap<T> {
        public Max() {
            super(defaultCapacity, 1);
        }
        public Max(int capacity) {
            super(capacity, 1);
        }
        public void removeMax() {
            removeTip();
        }
        public void replaceMax(double key, T value) {
            replaceTip(key, value);
        }
        public T getMax() {
            return getTip();
        }
        public double getMaxKey() {
            return getTipKey();
        }
    }
    public static final class Min<T> extends BinaryHeap<T> implements MinHeap<T> {
        public Min() {
            super(defaultCapacity, -1);
        }
        public Min(int capacity) {
            super(capacity, -1);
        }
        public void removeMin() {
            removeTip();
        }
        public void replaceMin(double key, T value) {
            replaceTip(key, value);
        }
        public T getMin() {
            return getTip();
        }
        public double getMinKey() {
            return getTipKey();
        }
    }
}


// IntervalHeap.java
class IntervalHeap<T> implements MinHeap<T>, MaxHeap<T> {
    private static final int defaultCapacity = 64;
    private Object[] data;
    private double[] keys;
    private int capacity;
    private int size;

    public IntervalHeap() {
        this(defaultCapacity);
    }

    public IntervalHeap(int capacity) {
        this.data = new Object[capacity];
        this.keys = new double[capacity];
        this.capacity = capacity;
        this.size = 0;
    }

    public void offer(double key, T value) {
        // If move room is needed, double array size
        if (size >= capacity) {
            capacity *= 2;
            data = Arrays.copyOf(data, capacity);
            keys = Arrays.copyOf(keys, capacity);
        }

        // Insert new value at the end
        size++;
        data[size-1] = value;
        keys[size-1] = key;
        siftInsertedValueUp();
    }

    public void removeMin() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        size--;
        data[0] = data[size];
        keys[0] = keys[size];
        data[size] = null;
        siftDownMin(0);
    }

    public void replaceMin(double key, T value) {
        if (size == 0) {
            throw new IllegalStateException();
        }

        data[0] = value;
        keys[0] = key;
        if (size > 1) {
            // Swap with pair if necessary
            if (keys[1] < key) {
                swap(0, 1);
            }
            siftDownMin(0);
        }
    }

    public void removeMax() {
        if (size == 0) {
            throw new IllegalStateException();
        } else if (size == 1) {
            removeMin();
            return;
        }

        size--;
        data[1] = data[size];
        keys[1] = keys[size];
        data[size] = null;
        siftDownMax(1);
    }

    public void replaceMax(double key, T value) {
        if (size == 0) {
            throw new IllegalStateException();
        } else if (size == 1) {
            replaceMin(key, value);
            return;
        }

        data[1] = value;
        keys[1] = key;
        // Swap with pair if necessary
        if (key < keys[0]) {
            swap(0, 1);
        }
        siftDownMax(1);
    }

    @SuppressWarnings("unchecked")
    public T getMin() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        return (T) data[0];
    }

    @SuppressWarnings("unchecked")
    public T getMax() {
        if (size == 0) {
            throw new IllegalStateException();
        } else if (size == 1) {
            return (T) data[0];
        }

        return (T) data[1];
    }

    public double getMinKey() {
        if (size == 0) {
            throw new IllegalStateException();
        }

        return keys[0];
    }

    public double getMaxKey() {
        if (size == 0) {
            throw new IllegalStateException();
        } else if (size == 1) {
            return keys[0];
        }

        return keys[1];
    }

    private int swap(int x, int y) {
        Object yData = data[y];
        double yDist = keys[y];
        data[y] = data[x];
        keys[y] = keys[x];
        data[x] = yData;
        keys[x] = yDist;
        return y;
    }

    /**
     * Min-side (u % 2 == 0):
     * - leftchild:  2u + 2
     * - rightchild: 2u + 4
     * - parent:     (x/2-1)&~1
     *
     * Max-side (u % 2 == 1):
     * - leftchild:  2u + 1
     * - rightchild: 2u + 3
     * - parent:     (x/2-1)|1
     */

    private void siftInsertedValueUp() {
        int u = size-1;
        if (u == 0) {
            // Do nothing if it's the only element!
        }
        else if (u == 1) {
            // If it is the second element, just sort it with it's pair
            if  (keys[u] < keys[u-1]) { // If less than it's pair
                swap(u, u-1); // Swap with it's pair
            }
        }
        else if (u % 2 == 1) {
            // Already paired. Ensure pair is ordered right
            int p = (u/2-1)|1; // The larger value of the parent pair
            if  (keys[u] < keys[u-1]) { // If less than it's pair
                u = swap(u, u-1); // Swap with it's pair
                if (keys[u] < keys[p-1]) { // If smaller than smaller parent pair
                    // Swap into min-heap side
                    u = swap(u, p-1);
                    siftUpMin(u);
                }
            } else {
                if (keys[u] > keys[p]) { // If larger that larger parent pair
                    // Swap into max-heap side
                    u = swap(u, p);
                    siftUpMax(u);
                }
            }
        } else {
            // Inserted in the lower-value slot without a partner
            int p = (u/2-1)|1; // The larger value of the parent pair
            if (keys[u] > keys[p]) { // If larger that larger parent pair
                // Swap into max-heap side
                u = swap(u, p);
                siftUpMax(u);
            } else if (keys[u] < keys[p-1]) { // If smaller than smaller parent pair
                // Swap into min-heap side
                u = swap(u, p-1);
                siftUpMin(u);
            }
        }
    }

    private void siftUpMin(int c) {
        // Min-side parent: (x/2-1)&~1
        for (int p = (c/2-1)&~1; p >= 0 && keys[c] < keys[p]; c = p, p = (c/2-1)&~1) {
            swap(c, p);
        }
    }

    private void siftUpMax(int c) {
        // Max-side parent: (x/2-1)|1
        for (int p = (c/2-1)|1; p >= 0 && keys[c] > keys[p]; c = p, p = (c/2-1)|1) {
            swap(c, p);
        }
    }

    private void siftDownMin(int p) {
        for (int c = p * 2 + 2; c < size; p = c, c = p * 2 + 2) {
            if (c + 2 < size && keys[c + 2] < keys[c]) {
                c += 2;
            }
            if (keys[c] < keys[p]) {
                swap(p, c);
                // Swap with pair if necessary
                if (c+1 < size && keys[c+1] < keys[c]) {
                    swap(c, c+1);
                }
            } else {
                break;
            }
        }
    }

    private void siftDownMax(int p) {
        for (int c = p * 2 + 1; c <= size; p = c, c = p * 2 + 1) {
            if (c == size) {
                // If the left child only has half a pair
                if (keys[c - 1] > keys[p]) {
                    swap(p, c - 1);
                }
                break;
            } else if (c + 2 == size) {
                // If there is only room for a right child lower pair
                if (keys[c + 1] > keys[c]) {
                    if (keys[c + 1] > keys[p]) {
                       swap(p, c + 1);
                    }
                    break;
                }
            } else if (c + 2 < size) {
                // If there is room for a right child upper pair
                if (keys[c + 2] > keys[c]) {
                    c += 2;
                }
            }
            if (keys[c] > keys[p]) {
                swap(p, c);
                // Swap with pair if necessary
                if (keys[c-1] > keys[c]) {
                    swap(c, c-1);
                }
            } else {
                break;
            }
        }
    }

    public int size() {
        return size;
    }

    public int capacity() {
        return capacity;
    }

    @Override
    public String toString() {
        java.text.DecimalFormat twoPlaces = new java.text.DecimalFormat("0.00");
        StringBuffer str = new StringBuffer(IntervalHeap.class.getCanonicalName());
        str.append(", size: ").append(size()).append(" capacity: ").append(capacity());
        int i = 0, p = 2;
        while (i < size()) {
            int x = 0;
            str.append("\t");
            while ((i+x) < size() && x < p) {
                str.append(twoPlaces.format(keys[i + x])).append(", ");
                x++;
            }
            str.append("\n");
            i += x;
            p *= 2;
        }
        return str.toString();
    }

    /*private boolean validateHeap() {
        // Validate left-right
        for (int i = 0; i < size-1; i+= 2) {
            if (keys[i] > keys[i+1]) return false;
        }
        // Validate within parent interval
        for (int i = 2; i < size; i++) {
            double maxParent = keys[(i/2-1)|1];
            double minParent = keys[(i/2-1)&~1];
            if (keys[i] > maxParent || keys[i] < minParent) return false;
        }
        return true;
    }*/
}


// MaxHeap.java
interface MaxHeap<T> {
    public int size();
    public void offer(double key, T value);
    public void replaceMax(double key, T value);
    public void removeMax();
    public T getMax();
    public double getMaxKey();
}


// MinHeap.java
interface MinHeap<T> {
    public int size();
    public void offer(double key, T value);
    public void replaceMin(double key, T value);
    public void removeMin();
    public T getMin();
    public double getMinKey();
}


// Pair.java
final class Pair<T> {
    public final T first, second;

    public Pair(T first, T second) {
        this.first = first;
        this.second = second;
    }
}


// DistanceFunction.java
interface DistanceFunction
{
    public double distance(double[] p1, double[] p2);
    public double distanceToRect(double[] point, double[] min, double[] max);
}


// KdNode.java
class KdNode<T> {
    // All types
    protected int dimensions;
    protected int bucketCapacity;
    protected int size;

    // Leaf only
    protected double[][] points;
    protected Object[] data;

    // Stem only
    protected KdNode<T> left, right;
    protected int splitDimension;
    protected double splitValue;

    // Bounds
    protected double[] minBound, maxBound;
    protected boolean singlePoint;

    protected KdNode(int dimensions, int bucketCapacity) {
        // Init base
        this.dimensions = dimensions;
        this.bucketCapacity = bucketCapacity;
        this.size = 0;
        this.singlePoint = true;

        // Init leaf elements
        this.points = new double[bucketCapacity+1][];
        this.data = new Object[bucketCapacity+1];
    }

    /* -------- SIMPLE GETTERS -------- */

    public int size() {
        return size;
    }

    public boolean isLeaf() {
        return points != null;
    }

    /* -------- OPERATIONS -------- */

    public void addPoint(double[] point, T value) {
        KdNode<T> cursor = this;
        while (!cursor.isLeaf()) {
            cursor.extendBounds(point);
            cursor.size++;
            if (point[cursor.splitDimension] > cursor.splitValue) {
                cursor = cursor.right;
            }
            else {
                cursor = cursor.left;
            }
        }
        cursor.addLeafPoint(point, value);
    }

    /* -------- INTERNAL OPERATIONS -------- */

    public void addLeafPoint(double[] point, T value) {
        // Add the data point
        points[size] = point;
        data[size] = value;
        extendBounds(point);
        size++;

        if (size == points.length - 1) {
            // If the node is getting too large
            if (calculateSplit()) {
                // If the node successfully had it's split value calculated, split node
                splitLeafNode();
            } else {
                // If the node could not be split, enlarge node
                increaseLeafCapacity();
            }
        }
    }

    /*private boolean checkBounds(double[] point) {
        for (int i = 0; i < dimensions; i++) {
            if (point[i] > maxBound[i]) return false;
            if (point[i] < minBound[i]) return false;
        }
        return true;
    }*/

    private void extendBounds(double[] point) {
        if (minBound == null) {
            minBound = Arrays.copyOf(point, dimensions);
            maxBound = Arrays.copyOf(point, dimensions);
            return;
        }

        for (int i = 0; i < dimensions; i++) {
            if (Double.isNaN(point[i])) {
                if (!Double.isNaN(minBound[i]) || !Double.isNaN(maxBound[i])) {
                    singlePoint = false;
                }
                minBound[i] = Double.NaN;
                maxBound[i] = Double.NaN;
            }
            else if (minBound[i] > point[i]) {
                minBound[i] = point[i];
                singlePoint = false;
            }
            else if (maxBound[i] < point[i]) {
                maxBound[i] = point[i];
                singlePoint = false;
            }
        }
    }

    private void increaseLeafCapacity() {
        points = Arrays.copyOf(points, points.length*2);
        data = Arrays.copyOf(data, data.length*2);
    }

    private boolean calculateSplit() {
        if (singlePoint) return false;

        double width = 0;
        for (int i = 0; i < dimensions; i++) {
            double dwidth = (maxBound[i] - minBound[i]);
            if (Double.isNaN(dwidth)) dwidth = 0;
            if (dwidth > width) {
                splitDimension = i;
                width = dwidth;
            }
        }

        if (width == 0) {
            return false;
        }

        // Start the split in the middle of the variance
        splitValue = (minBound[splitDimension] + maxBound[splitDimension]) * 0.5;

        // Never split on infinity or NaN
        if (splitValue == Double.POSITIVE_INFINITY) {
            splitValue = Double.MAX_VALUE;
        }
        else if (splitValue == Double.NEGATIVE_INFINITY) {
            splitValue = -Double.MAX_VALUE;
        }

        // Don't let the split value be the same as the upper value as
        // can happen due to rounding errors!
        if (splitValue == maxBound[splitDimension]) {
            splitValue = minBound[splitDimension];
        }

        // Success
        return true;
    }

    @SuppressWarnings("unchecked")
    private void splitLeafNode() {
        right = new KdNode<T>(dimensions, bucketCapacity);
        left = new KdNode<T>(dimensions, bucketCapacity);

        // Move locations into children
        for (int i = 0; i < size; i++) {
            double[] oldLocation = points[i];
            Object oldData = data[i];
            if (oldLocation[splitDimension] > splitValue) {
                right.addLeafPoint(oldLocation, (T) oldData);
            }
            else {
                left.addLeafPoint(oldLocation, (T) oldData);
            }
        }

        points = null;
        data = null;
    }
}


// KdTree.java
class KdTree<T> extends KdNode<T> {
    public KdTree(int dimensions) {
        this(dimensions, 24);
    }

    public KdTree(int dimensions, int bucketCapacity) {
        super(dimensions, bucketCapacity);
    }

    public NearestNeighborIterator<T> getNearestNeighborIterator(double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        return new NearestNeighborIterator<T>(this, searchPoint, maxPointsReturned, distanceFunction);
    }

    public MaxHeap<T> findNearestNeighbors(double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        BinaryHeap.Min<KdNode<T>> pendingPaths = new BinaryHeap.Min<KdNode<T>>();
        BinaryHeap.Max<T> evaluatedPoints = new BinaryHeap.Max<T>();
        int pointsRemaining = Math.min(maxPointsReturned, size());
        pendingPaths.offer(0, this);

        while (pendingPaths.size() > 0 && (evaluatedPoints.size() < pointsRemaining || (pendingPaths.getMinKey() < evaluatedPoints.getMaxKey()))) {
            nearestNeighborSearchStep(pendingPaths, evaluatedPoints, pointsRemaining, distanceFunction, searchPoint);
        }

        return evaluatedPoints;
    }

    @SuppressWarnings("unchecked")
    protected static <T> void nearestNeighborSearchStep (
            MinHeap<KdNode<T>> pendingPaths, MaxHeap<T> evaluatedPoints, int desiredPoints,
            DistanceFunction distanceFunction, double[] searchPoint) {
        // If there are pending paths possibly closer than the nearest evaluated point, check it out
        KdNode<T> cursor = pendingPaths.getMin();
        pendingPaths.removeMin();

        // Descend the tree, recording paths not taken
        while (!cursor.isLeaf()) {
            KdNode<T> pathNotTaken;
            if (searchPoint[cursor.splitDimension] > cursor.splitValue) {
                pathNotTaken = cursor.left;
                cursor = cursor.right;
            }
            else {
                pathNotTaken = cursor.right;
                cursor = cursor.left;
            }
            double otherDistance = distanceFunction.distanceToRect(searchPoint, pathNotTaken.minBound, pathNotTaken.maxBound);
            // Only add a path if we either need more points or it's closer than furthest point on list so far
            if (evaluatedPoints.size() < desiredPoints || otherDistance <= evaluatedPoints.getMaxKey()) {
                pendingPaths.offer(otherDistance, pathNotTaken);
            }
        }

        if (cursor.singlePoint) {
            double nodeDistance = distanceFunction.distance(cursor.points[0], searchPoint);
            // Only add a point if either need more points or it's closer than furthest on list so far
            if (evaluatedPoints.size() < desiredPoints || nodeDistance <= evaluatedPoints.getMaxKey()) {
                for (int i = 0; i < cursor.size(); i++) {
                    T value = (T) cursor.data[i];

                    // If we don't need any more, replace max
                    if (evaluatedPoints.size() == desiredPoints) {
                        evaluatedPoints.replaceMax(nodeDistance, value);
                    } else {
                        evaluatedPoints.offer(nodeDistance, value);
                    }
                }
            }
        } else {
            // Add the points at the cursor
            for (int i = 0; i < cursor.size(); i++) {
                double[] point = cursor.points[i];
                T value = (T) cursor.data[i];
                double distance = distanceFunction.distance(point, searchPoint);
                // Only add a point if either need more points or it's closer than furthest on list so far
                if (evaluatedPoints.size() < desiredPoints) {
                    evaluatedPoints.offer(distance, value);
                } else if (distance < evaluatedPoints.getMaxKey()) {
                    evaluatedPoints.replaceMax(distance, value);
                }
            }
        }
    }
}


// NearestNeighborIterator.java
class NearestNeighborIterator<T> implements Iterator<T>, Iterable<T> {
    private DistanceFunction distanceFunction;
    private double[] searchPoint;
    private MinHeap<KdNode<T>> pendingPaths;
    private IntervalHeap<T> evaluatedPoints;
    private int pointsRemaining;
    private double lastDistanceReturned;

    protected NearestNeighborIterator(KdNode<T> treeRoot, double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        this.searchPoint = Arrays.copyOf(searchPoint, searchPoint.length);
        this.pointsRemaining = Math.min(maxPointsReturned, treeRoot.size());
        this.distanceFunction = distanceFunction;
        this.pendingPaths = new BinaryHeap.Min<KdNode<T>>();
        this.pendingPaths.offer(0, treeRoot);
        this.evaluatedPoints = new IntervalHeap<T>();
    }

    /* -------- INTERFACE IMPLEMENTATION -------- */

    @Override
    public boolean hasNext() {
        return pointsRemaining > 0;
    }

    @Override
    public T next() {
        if (!hasNext()) {
            throw new IllegalStateException("NearestNeighborIterator has reached end!");
        }

        while (pendingPaths.size() > 0 && (evaluatedPoints.size() == 0 || (pendingPaths.getMinKey() < evaluatedPoints.getMinKey()))) {
            KdTree.nearestNeighborSearchStep(pendingPaths, evaluatedPoints, pointsRemaining, distanceFunction, searchPoint);
        }

        // Return the smallest distance point
        pointsRemaining--;
        lastDistanceReturned = evaluatedPoints.getMinKey();
        T value = evaluatedPoints.getMin();
        evaluatedPoints.removeMin();
        return value;
    }

    public double distance() {
        return lastDistanceReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}


// SquareEuclideanDistanceFunction.java
class SquareEuclideanDistanceFunction implements DistanceFunction {
    @Override
    public double distance(double[] p1, double[] p2) {
        double d = 0;

        for (int i = 0; i < p1.length; i++) {
            double diff = (p1[i] - p2[i]);
            d += diff * diff;
        }

        return d;
    }

    @Override
    public double distanceToRect(double[] point, double[] min, double[] max) {
        double d = 0;

        for (int i = 0; i < point.length; i++) {
            double diff = 0;
            if (point[i] > max[i]) {
                diff = (point[i] - max[i]);
            }
            else if (point[i] < min[i]) {
                diff = (point[i] - min[i]);
            }
            d += diff * diff;
        }

        return d;
    }
}


/// End Rednaxela's kd-tree



class Coord
{
    public double x;
    public double y;
    public double value;
    public double power;

    public Coord()
    {
        this(0.0, 0.0);
    }

    public Coord(double x, double y)
    {
        this(x, y, 0.0);
    }

    public Coord(double x, double y, double value)
    {
        this.x = x;
        this.y = y;
        this.value = value;
        power = 0.0;
    }
}

class BotTurn
{
    public double  heading;
    public double  velocity;
    public long    time;
    public Coord   pos;
    public boolean isAccurate;

    public BotTurn(double heading, double velocity, long time, Coord pos)//, boolean isAccurate)
    {
        this.heading    = heading;
        this.velocity   = velocity;
        this.time       = time;
        this.pos        = pos;
        this.isAccurate = true;//isAccurate;
    }
}

class Bot
{
    public String name;
    public double energy;
    public double x;
    public double y;
    public double heading;
    public double velocity;
    public double averageVelocity;
    public long time;
    public boolean isAlive;
    public Vector<BotTurn> history;
    public KdTree<Integer> tree;
    public double[][][][] stats;
    public boolean needTree;

    public Bot(String name, BotTurn turn, double energy)
    {
        this.name = name;
        history   = new Vector<BotTurn>();
        averageVelocity = 0;
        stats = new double[2][2][4][40];
        for (int out = 0; out < 2; out++)
        {
            for (int dir = 0; dir < 2; dir++)
            {
                stats[out][dir][0][18] = 0.001;
                stats[out][dir][1][13] = 0.001;
                stats[out][dir][2][9]  = 0.001;
                stats[out][dir][3][7]  = 0.001;
            }
        }
        needTree = true;
        tree = new KdTree<Integer>(18);
        pushTurn(turn, energy);
    }

    public void pushTurn()
    {
        BotTurn turn = new BotTurn(heading, velocity, time, new Coord(x, y));
        turn.isAccurate = false;
        history.add(turn);
        doUpdateTree();
    }

    public void pushTurn(BotTurn turn, double energy)
    {
        history.add(turn);
        this.energy = energy;
        x = turn.pos.x;
        y = turn.pos.y;
        heading  = turn.heading;
        velocity = turn.velocity;
        time     = turn.time;
        isAlive  = true;
        doUpdateTree();
    }

    public double[] getPoint()
    {
        return getPoint(history.size() - 1);
    }

    public double[] getPoint(int turn)
    {
        double[] point = new double[18];
        for (int i = 0; i < 6; i++)
        {
            if (turn - i >= history.size() || turn - i <= 0)
                continue;
            if (i == 0)
            {
                point[0] = Math.sqrt(  Math.pow(history.get(turn).pos.x - (RainingFire.battleFieldWidth / 2), 2)
                                     + Math.pow(history.get(turn).pos.y - (RainingFire.battleFieldHeight / 2), 2));
            }
            point[i * 2 + 1] = history.get(turn - i).velocity;
            point[i * 2 + 2] = history.get(turn - i).heading - history.get(turn - i - 1).heading;
        }
        //point[11] = averageVelocity;
        if (turn >= 0 && RainingFire.m_me != null)
        {
            point[13] = Math.sqrt(  Math.pow(history.get(turn).pos.x - RainingFire.m_me.x, 2)
                                  + Math.pow(history.get(turn).pos.y - RainingFire.m_me.y, 2));
            point[14] = Utils.normalAbsoluteAngle(FastMath.atan2(history.get(turn).pos.x - RainingFire.m_me.x, history.get(turn).pos.y - RainingFire.m_me.y) + history.get(turn).heading);
        }
        // bots can learn, so prefer recent data
        point[15] = (int)(turn / 450);
        point[16] = (int)(RainingFire.others / 3);
        point[17] = (int)(energy / 40);
        return point;
    }

    private void doUpdateTree()
    {
        if (!needTree || !history.lastElement().isAccurate)
            return;
        int index = history.size() - 2;
        for (int i = 0; i < 15 && index > 0; i++, index--)
        {
            if (history.get(index).isAccurate)
                break;
        }
        if (index == history.size() - 2)
        {
            tree.addPoint(getPoint(), history.size() - 1);
        }
        else
        {
            // improve interpolation
            double time = history.size() - 1 - index;
            double headingChange = (history.lastElement().heading - history.get(index).heading) / time;
            double dist = Math.sqrt(   Math.pow(history.lastElement().pos.x - history.get(index).pos.x, 2)
                                    +  Math.pow(history.lastElement().pos.y - history.get(index).pos.y, 2));
            double velocity = Math.min(8, dist / time);
            if (history.lastElement().velocity + history.get(index).velocity < 0)
                velocity = -velocity;
            for(index++; index < history.size() - 1; index++)
            {
                history.get(index).velocity = velocity;
                history.get(index).heading = history.get(index - 1).heading + headingChange;
                tree.addPoint(getPoint(index), index);
            }
            tree.addPoint(getPoint(), history.size() - 1);
        }
    }

    public void pushStat(double offset, boolean dirChange, double targVelocity, boolean out)
    {
        int dir = (dirChange ? 1 : 0);
        targVelocity = Math.abs(targVelocity);


        if (targVelocity < 3)
            doPushStat(offset, dir, 0, out);
        if (targVelocity > 1 && targVelocity < 5)
            doPushStat(offset, dir, 1, out);
        if (targVelocity > 3 && targVelocity < 7)
            doPushStat(offset, dir, 2, out);
        if (targVelocity > 5)
            doPushStat(offset, dir, 3, out);
/*
        if (targVelocity < 4)
            doPushStat(offset, dir, 0, out);
        else
            doPushStat(offset, dir, 2, out);
        if (targVelocity > 2 && targVelocity < 6)
            doPushStat(offset, dir, 1, out);*/
    }

    private void doPushStat(double offset, int dir, int set, boolean outOfBound)
    {
        double scale = 79.0 / 80.0; // 0.99
        double large =  1.0 / 80.0; // 0.01
        double small =  0.4 / 80.0; // 0.004
        int index = (int)Math.round(offset * 20 + 20);
        int out = (outOfBound ? 1 : 0);
        if (index < 1)
        {
            stats[out][dir][set][0] = scale * stats[out][dir][set][0] + large;
            if (index == 0)
                stats[out][dir][set][1] = scale * stats[out][dir][set][1] + small;
            for (int i = (index == 0 ? 2 : 1); i < 40; i++)
            {
                stats[out][dir][set][i] *= scale;
            }
        }
        else if (index > 38)
        {
            stats[out][dir][set][39] = scale * stats[out][dir][set][39] + large;
            if (index == 39)
                stats[out][dir][set][38] = scale * stats[out][dir][set][38] + small;
            for (int i = 0; i < (index == 39 ? 38 : 39); i++)
            {
                stats[out][dir][set][i] *= scale;
            }
        }
        else for (int i = 0; i < 40; i++)
        {
            if (i == index)
                stats[out][dir][set][i] = scale * stats[out][dir][set][i] + large;
            else if (Math.abs(index - i) == 1)
                stats[out][dir][set][i] = scale * stats[out][dir][set][i] + small;
            else
                stats[out][dir][set][i] *= scale;
        }
    }

    public void reduceStats()
    {
        for (int out = 0; out < 2; out++)
        {
            for (int dir = 0; dir < 2; dir++)
            {
                for (int i = 0; i < stats[out][dir][0].length; i++)
                {
                    stats[out][dir][0][i] *= 0.955;
                    stats[out][dir][1][i] *= 0.935;
                    stats[out][dir][2][i] *= 0.91;
                    stats[out][dir][3][i] *= 0.9;
                }
            }
        }
    }
}

class Wave
{
    // origin
    public Bot from;
    public Coord origin;
    // start time
    public long time;
    public double power;
    public Bot target;
    public double[] angles;
    //public double distance; // from nearest corner
    //public boolean dirChange; // velocity sign flipped during past 17 turns
    public double avTargVelocity; // lateral
    public Coord targCirc;

    public Wave(Bot from, double power, long time, Bot target)
    {
        this.from = from;
        origin = new Coord(from.x, from.y);
        this.time   = time;
        this.power  = power;
        this.target = target;
        targCirc  = RainingFire.targetCircular(target, power, from);
        //if (target.history.size() > 20)
        //    dirChange = (target.history.get(target.history.size() - 18).velocity * target.velocity < 0);
        //else
        //    dirChange = false;
        //distance  = Math.sqrt(Math.pow(0 - target.x, 2) + Math.pow(0 - target.y, 2));
        //distance  = Math.min(distance, Math.sqrt(Math.pow(RainingFire.battleFieldWidth - target.x, 2) + Math.pow(0 - target.y, 2)));
        //distance  = Math.min(distance, Math.sqrt(Math.pow(0 - target.x, 2) + Math.pow(RainingFire.battleFieldHeight - target.y, 2)));
        //distance  = Math.min(distance, Math.sqrt(Math.pow(RainingFire.battleFieldWidth - target.x, 2) + Math.pow(RainingFire.battleFieldHeight - target.y, 2)));
        angles    = new double[2];
        angles[0] = Utils.normalAbsoluteAngle(FastMath.atan2(target.x - origin.x, target.y - origin.y));
        avTargVelocity = Math.abs(target.averageVelocity * FastMath.sin(target.heading - angles[0]));

        double offset = FastMath.asin(8.0 / (20.0 - 3.0 * power)); //8.0 * (distance / (20.0 - 3.0 * power)) / (2.0 * distance * Math.PI);//16.0 / ((20.0 - 3.0 * power) * Math.PI);

        double lastAng = angles[0];
        if (target.history.size() > 2)
        {
            lastAng = Utils.normalAbsoluteAngle(FastMath.atan2(target.history.get(target.history.size() - 2).pos.x - origin.x,
                                                               target.history.get(target.history.size() - 2).pos.y - origin.y));
        }
        angles[1] =  (lastAng > angles[0] ? 1 : -1) * offset;
    }

    public double getRadius(long time)
    {
        return ((1 + time - this.time) * (20.0 - 3.0 * power));
    }

    public boolean dirChanged()
    {
        int index = (int)(target.history.size() + time + 15 - target.time);
        if (index >= target.history.size())
            index = target.history.size() - 1;
        else if (index < 0)
            index = 0;
        return (target.history.get(index).velocity * avTargVelocity < 0);
    }

    public double getAngle()
    {
        int out = (targCirc.power < -0.5 ? 1 : 0);
        int dir = (dirChanged() ? 1 : 0);
        //int set = (avTargVelocity < (8.0 / 3.0) ? 0 : avTargVelocity > (16.0 / 3.0) ? 2 : 1);
        int set = (int)(avTargVelocity / 2);
        if (set > 3)
            set = 3;
        int offset = 0;
        double value = 0;
        for (int i = 1; i < 39; i++)
        {
            double val =   from.stats[out][dir][set][i - 1] * 0.3
                         + from.stats[out][dir][set][i]
                         + from.stats[out][dir][set][i + 1] * 0.3;
            if (val > value)
            {
                offset = i;
                value  = val;
            }
        }
        return Utils.normalAbsoluteAngle(angles[0] + angles[1] * (offset / 20.0 - 1.0));
    }

    public double getSafeAngle()
    {
        int out = (targCirc.power < -0.5 ? 1 : 0);
        int dir = (dirChanged() ? 1 : 0);
        //int set = (avTargVelocity < (8.0 / 3.0) ? 0 : avTargVelocity > (16.0 / 3.0) ? 2 : 1);
        int set = (int)(avTargVelocity / 2);
        if (set > 3)
            set = 3;
        int offset = 3;
        double value = Double.MAX_VALUE;
        for (int i = 4; i < 34; i++)
        {
            double val =   from.stats[out][dir][set][i - 3] * 0.01
                         + from.stats[out][dir][set][i - 2] * 0.1
                         + from.stats[out][dir][set][i - 1] * 0.7
                         + from.stats[out][dir][set][i]
                         + from.stats[out][dir][set][i + 1] * 0.7
                         + from.stats[out][dir][set][i + 2] * 0.1
                         + from.stats[out][dir][set][i + 3] * 0.01;
            if (val < value)
            {
                offset = i;
                value  = val;
            }
        }
        return Utils.normalAbsoluteAngle(angles[0] + angles[1] * (offset / 20.0 - 1.0));
    }
}
